/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.base;

import com.fasterxml.util.membuf.Segment;
import com.fasterxml.util.membuf.SegmentAllocator;

public abstract class SegmentAllocatorBase<S extends Segment<S>>
extends SegmentAllocator<S> {
    public static final int MIN_SEGMENT_LENGTH = 4;
    protected S _firstReusableSegment;

    public SegmentAllocatorBase(int segmentSize, int minSegmentsToRetain, int maxSegments) {
        super(segmentSize, minSegmentsToRetain, maxSegments);
        if (segmentSize < 4) {
            throw new IllegalArgumentException("segmentSize minimum is 4 bytes");
        }
        this._firstReusableSegment = null;
    }

    @Override
    public synchronized S allocateSegments(int count, S segmentList) {
        if (count < 1) {
            throw new IllegalArgumentException("Must allocate at least one segment (count = " + count + ")");
        }
        if (!this._canAllocate(count)) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            segmentList = ((Segment)this._allocateSegment()).relink(segmentList);
        }
        return segmentList;
    }

    @Override
    public synchronized void releaseSegment(S segToRelease) {
        if (--this._bufferOwnedSegmentCount < 0) {
            int count = this._bufferOwnedSegmentCount;
            this._bufferOwnedSegmentCount = 0;
            throw new IllegalStateException("Bugger! Corruption Maximus: _bufferOwnedSegmentCount went below 0 (" + count + ")");
        }
        if (this._reusableSegmentCount < this._maxReusableSegments) {
            this._firstReusableSegment = ((Segment)segToRelease).relink(this._firstReusableSegment);
            ++this._reusableSegmentCount;
        }
    }

    protected abstract S _allocateSegment();

    protected boolean _canAllocate(int count) {
        int available = this._reusableSegmentCount + (this._maxSegmentsToAllocate - this._bufferOwnedSegmentCount);
        return available >= count;
    }
}

