/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.base;

import com.fasterxml.util.membuf.Segment;

public abstract class SegmentBase<S extends Segment<S>>
extends Segment<S> {
    public static final int ABSOLUTE_MINIMUM_LENGTH = 8;
    protected Segment.State _state = Segment.State.FREE;
    protected S _nextSegment;

    @Override
    public final Segment.State state() {
        return this._state;
    }

    @Override
    public S initForWriting() {
        if (this._state != Segment.State.FREE) {
            throw new IllegalStateException("Trying to call initForWriting on segment with state " + (Object)((Object)this._state));
        }
        this._state = Segment.State.WRITING;
        return this._this();
    }

    @Override
    public S finishWriting() {
        if (this._state != Segment.State.WRITING && this._state != Segment.State.READING_AND_WRITING) {
            throw new IllegalStateException("Trying to call finishWriting on segment with state " + (Object)((Object)this._state));
        }
        this._state = Segment.State.READING;
        return this._this();
    }

    @Override
    public S initForReading() {
        if (this._state == Segment.State.WRITING) {
            this._state = Segment.State.READING_AND_WRITING;
        } else if (this._state != Segment.State.READING) {
            throw new IllegalStateException("Trying to call initForReading on segment with state " + (Object)((Object)this._state));
        }
        return this._this();
    }

    @Override
    public S finishReading() {
        if (this._state != Segment.State.READING) {
            throw new IllegalStateException("Trying to call finishReading on segment with state " + (Object)((Object)this._state));
        }
        this._state = Segment.State.FREE;
        S result = this._nextSegment;
        this.relink(null);
        return result;
    }

    @Override
    public void clear() {
        this._state = Segment.State.FREE;
        this.initForWriting();
        this.initForReading();
    }

    @Override
    public final void markFree() {
        if (this._nextSegment != null) {
            throw new IllegalStateException("Calling markFree() with _nextSegment not null, state: " + (Object)((Object)this._state));
        }
        this._state = Segment.State.FREE;
    }

    @Override
    public S relink(S next) {
        if (next == this) {
            throw new IllegalStateException("trying to set cyclic link");
        }
        this._nextSegment = next;
        return this._this();
    }

    @Override
    public S getNext() {
        return this._nextSegment;
    }

    private final S _this() {
        return (S)this;
    }
}

