/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.base;

import com.fasterxml.util.membuf.Segment;
import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.StreamyMemBuffer;
import com.fasterxml.util.membuf.base.MemBufferBase;

public abstract class StreamyMemBufferBase<S extends Segment<S>>
extends MemBufferBase<S>
implements StreamyMemBuffer {
    public StreamyMemBufferBase(SegmentAllocator<S> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, S initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
    }

    protected StreamyMemBufferBase(StreamyMemBufferBase<S> src) {
        super(src);
    }

    @Override
    public synchronized void clear() {
        this._clear();
    }

    @Override
    public final synchronized int skip(int skipCount) {
        if (this._head == null) {
            this._reportClosed();
        }
        if ((long)skipCount > this._totalPayloadLength) {
            skipCount = (int)this._totalPayloadLength;
        }
        int remaining = skipCount;
        String error = null;
        if (remaining > 0) {
            while (true) {
                int count = this._tail.skip(remaining);
                this._totalPayloadLength -= (long)count;
                if ((remaining -= count) == 0) break;
                error = this._freeReadSegment(error);
            }
        }
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return skipCount;
    }
}

