/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.impl;

import com.fasterxml.util.membuf.base.BytesSegment;
import com.fasterxml.util.membuf.base.SegmentAllocatorBase;

public class ArrayBytesSegment
extends BytesSegment {
    protected final byte[] _buffer;
    protected int _appendPtr;
    protected int _readPtr;

    public ArrayBytesSegment(int size) {
        this._buffer = new byte[size];
    }

    public static Allocator allocator(int segmentSize, int minSegmentsToRetain, int maxSegments) {
        return new Allocator(segmentSize, minSegmentsToRetain, maxSegments);
    }

    @Override
    public ArrayBytesSegment initForWriting() {
        super.initForWriting();
        this._appendPtr = 0;
        return this;
    }

    @Override
    public ArrayBytesSegment initForReading() {
        super.initForReading();
        this._readPtr = 0;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this._appendPtr = 0;
        this._readPtr = 0;
    }

    @Override
    public int availableForAppend() {
        return this._buffer.length - this._appendPtr;
    }

    @Override
    public int availableForReading() {
        return this._buffer.length - this._readPtr;
    }

    @Override
    public void append(byte[] src, int offset, int length) {
        int dst = this._appendPtr;
        this._appendPtr += length;
        System.arraycopy(src, offset, this._buffer, dst, length);
    }

    @Override
    public boolean tryAppend(byte value) {
        if (this.availableForAppend() < 1) {
            return false;
        }
        this._buffer[this._appendPtr++] = value;
        return true;
    }

    @Override
    public int tryAppend(byte[] src, int offset, int length) {
        int actualLen = Math.min(length, this.availableForAppend());
        if (actualLen > 0) {
            int dst = this._appendPtr;
            this._appendPtr += length;
            System.arraycopy(src, offset, this._buffer, dst, actualLen);
        }
        return actualLen;
    }

    @Override
    public byte read() {
        return this._buffer[this._readPtr++];
    }

    @Override
    public void read(byte[] buffer, int offset, int length) {
        int src = this._readPtr;
        this._readPtr += length;
        System.arraycopy(this._buffer, src, buffer, offset, length);
    }

    @Override
    public int tryRead(byte[] buffer, int offset, int length) {
        length = Math.min(this.availableForReading(), length);
        if (length > 0) {
            int src = this._readPtr;
            this._readPtr += length;
            System.arraycopy(this._buffer, src, buffer, offset, length);
        }
        return length;
    }

    @Override
    public int skip(int length) {
        length = Math.min(length, this.availableForReading());
        this._readPtr += length;
        return length;
    }

    @Override
    public int readLength() {
        byte b;
        int length;
        int available = this.availableForReading();
        if (available == 0) {
            return -1;
        }
        if ((length = this._buffer[this._readPtr++]) < 0) {
            return length & 0x7F;
        }
        if (--available == 0) {
            return -(length + 1);
        }
        if ((b = this._buffer[this._readPtr++]) < 0) {
            return (length << 7) + (b & 0x7F);
        }
        length = (length << 7) + b;
        if (--available == 0) {
            return -(length + 1);
        }
        if ((b = this._buffer[this._readPtr++]) < 0) {
            return (length << 7) + (b & 0x7F);
        }
        length = (length << 7) + b;
        if (--available == 0) {
            return -(length + 1);
        }
        if ((b = this._buffer[this._readPtr++]) < 0) {
            return (length << 7) + (b & 0x7F);
        }
        length = (length << 7) + b;
        if (--available == 0) {
            return -(length + 1);
        }
        if ((b = this._buffer[this._readPtr++]) < 0) {
            return (length << 7) + (b & 0x7F);
        }
        throw new IllegalStateException("Corrupt segment: fifth byte of length was 0x" + Integer.toHexString(b) + " did not have high-bit set");
    }

    @Override
    public int readSplitLength(int partial) {
        while (true) {
            byte b;
            partial <<= 7;
            if ((b = this._buffer[this._readPtr++]) < 0) {
                return partial + (b & 0x7F);
            }
            partial += b;
        }
    }

    public static class Allocator
    extends SegmentAllocatorBase<BytesSegment> {
        public Allocator(int segmentSize, int minSegmentsToRetain, int maxSegments) {
            super(segmentSize, minSegmentsToRetain, maxSegments);
        }

        @Override
        protected BytesSegment _allocateSegment() {
            if (this._reusableSegmentCount > 0) {
                BytesSegment segment = (BytesSegment)this._firstReusableSegment;
                this._firstReusableSegment = segment.getNext();
                ++this._bufferOwnedSegmentCount;
                --this._reusableSegmentCount;
                return segment;
            }
            ArrayBytesSegment segment = new ArrayBytesSegment(this._segmentSize);
            ++this._bufferOwnedSegmentCount;
            return segment;
        }
    }
}

