/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.impl;

import com.fasterxml.util.membuf.base.LongsSegment;
import com.fasterxml.util.membuf.base.SegmentAllocatorBase;

public class ArrayLongsSegment
extends LongsSegment {
    protected final long[] _buffer;
    protected int _appendPtr;
    protected int _readPtr;

    public ArrayLongsSegment(int size) {
        this._buffer = new long[size];
    }

    public static Allocator allocator(int segmentSize, int minSegmentsToRetain, int maxSegments) {
        return new Allocator(segmentSize, minSegmentsToRetain, maxSegments);
    }

    @Override
    public ArrayLongsSegment initForWriting() {
        super.initForWriting();
        this._appendPtr = 0;
        return this;
    }

    @Override
    public ArrayLongsSegment initForReading() {
        super.initForReading();
        this._readPtr = 0;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this._appendPtr = 0;
        this._readPtr = 0;
    }

    @Override
    public final int availableForAppend() {
        return this._buffer.length - this._appendPtr;
    }

    @Override
    public final int availableForReading() {
        return this._buffer.length - this._readPtr;
    }

    @Override
    public void append(long[] src, int offset, int length) {
        int dst = this._appendPtr;
        this._appendPtr += length;
        System.arraycopy(src, offset, this._buffer, dst, length);
    }

    @Override
    public int tryAppend(long[] src, int offset, int length) {
        int actualLen = Math.min(length, this.availableForAppend());
        if (actualLen > 0) {
            int dst = this._appendPtr;
            this._appendPtr += length;
            System.arraycopy(src, offset, this._buffer, dst, actualLen);
        }
        return actualLen;
    }

    @Override
    public boolean tryAppend(long value) {
        if (this.availableForAppend() < 1) {
            return false;
        }
        this._buffer[this._appendPtr++] = value;
        return true;
    }

    @Override
    public int readLength() {
        if (this.availableForReading() < 1) {
            return -1;
        }
        long l = this._buffer[this._readPtr++];
        return (int)l;
    }

    @Override
    public long read() {
        return this._buffer[this._readPtr++];
    }

    @Override
    public void read(long[] buffer, int offset, int length) {
        int src = this._readPtr;
        this._readPtr += length;
        System.arraycopy(this._buffer, src, buffer, offset, length);
    }

    @Override
    public int tryRead(long[] buffer, int offset, int length) {
        length = Math.min(this.availableForReading(), length);
        if (length > 0) {
            int src = this._readPtr;
            this._readPtr += length;
            System.arraycopy(this._buffer, src, buffer, offset, length);
        }
        return length;
    }

    @Override
    public int skip(int length) {
        length = Math.min(length, this.availableForReading());
        this._readPtr += length;
        return length;
    }

    public static class Allocator
    extends SegmentAllocatorBase<LongsSegment> {
        public Allocator(int segmentSize, int minSegmentsToRetain, int maxSegments) {
            super(segmentSize, minSegmentsToRetain, maxSegments);
        }

        @Override
        protected LongsSegment _allocateSegment() {
            if (this._reusableSegmentCount > 0) {
                LongsSegment segment = (LongsSegment)this._firstReusableSegment;
                this._firstReusableSegment = segment.getNext();
                ++this._bufferOwnedSegmentCount;
                --this._reusableSegmentCount;
                return segment;
            }
            ArrayLongsSegment segment = new ArrayLongsSegment(this._segmentSize);
            ++this._bufferOwnedSegmentCount;
            return segment;
        }
    }
}

