/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.impl;

import com.fasterxml.util.membuf.base.BytesSegment;
import com.fasterxml.util.membuf.base.SegmentAllocatorBase;
import java.nio.ByteBuffer;

public class ByteBufferBytesSegment
extends BytesSegment {
    protected final ByteBuffer _buffer;
    protected ByteBuffer _readBuffer;

    public ByteBufferBytesSegment(int size, boolean useDirect) {
        if (size < 8) {
            size = 8;
        }
        this._buffer = useDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    public static Allocator allocator(int segmentSize, int minSegmentsToRetain, int maxSegments, boolean allocateNativeBuffers) {
        return new Allocator(segmentSize, minSegmentsToRetain, maxSegments, allocateNativeBuffers);
    }

    @Override
    public BytesSegment initForReading() {
        super.initForReading();
        this._readBuffer = this._buffer.asReadOnlyBuffer();
        this._readBuffer.clear();
        return this;
    }

    @Override
    public BytesSegment finishReading() {
        BytesSegment result = (BytesSegment)super.finishReading();
        this._buffer.clear();
        this._readBuffer = null;
        return result;
    }

    @Override
    public void clear() {
        this._readBuffer = null;
        this._buffer.clear();
        super.clear();
    }

    @Override
    public int availableForAppend() {
        return this._buffer.remaining();
    }

    @Override
    public int availableForReading() {
        if (this._readBuffer == null) {
            throw new IllegalStateException("Method should not be called when _readBuffer is null");
        }
        return this._readBuffer.remaining();
    }

    @Override
    public void append(byte[] src, int offset, int length) {
        this._buffer.put(src, offset, length);
    }

    @Override
    public int tryAppend(byte[] src, int offset, int length) {
        int actualLen = Math.min(length, this.availableForAppend());
        if (actualLen > 0) {
            this._buffer.put(src, offset, actualLen);
        }
        return actualLen;
    }

    @Override
    public boolean tryAppend(byte value) {
        if (this.availableForAppend() > 0) {
            this._buffer.put(value);
            return true;
        }
        return false;
    }

    @Override
    public byte read() {
        return this._readBuffer.get();
    }

    @Override
    public void read(byte[] buffer, int offset, int length) {
        this._readBuffer.get(buffer, offset, length);
    }

    @Override
    public int tryRead(byte[] buffer, int offset, int length) {
        int actualLen = Math.min(this.availableForReading(), length);
        if (actualLen > 0) {
            this._readBuffer.get(buffer, offset, actualLen);
        }
        return actualLen;
    }

    @Override
    public int skip(int length) {
        length = Math.min(length, this.availableForReading());
        this._readBuffer.position(this._readBuffer.position() + length);
        return length;
    }

    @Override
    public int readLength() {
        int available = this.availableForReading();
        if (available == 0) {
            return -1;
        }
        int length = this._readBuffer.get();
        if (length < 0) {
            return length & 0x7F;
        }
        if (--available == 0) {
            return -(length + 1);
        }
        byte b = this._readBuffer.get();
        if (b < 0) {
            return (length << 7) + (b & 0x7F);
        }
        length = (length << 7) + b;
        if (--available == 0) {
            return -(length + 1);
        }
        b = this._readBuffer.get();
        if (b < 0) {
            return (length << 7) + (b & 0x7F);
        }
        length = (length << 7) + b;
        if (--available == 0) {
            return -(length + 1);
        }
        b = this._readBuffer.get();
        if (b < 0) {
            return (length << 7) + (b & 0x7F);
        }
        length = (length << 7) + b;
        if (--available == 0) {
            return -(length + 1);
        }
        b = this._readBuffer.get();
        if (b < 0) {
            return (length << 7) + (b & 0x7F);
        }
        throw new IllegalStateException("Corrupt segment: fifth byte of length was 0x" + Integer.toHexString(b) + " did not have high-bit set");
    }

    @Override
    public int readSplitLength(int partial) {
        while (true) {
            partial <<= 7;
            byte b = this._readBuffer.get();
            if (b < 0) {
                return partial + (b & 0x7F);
            }
            partial += b;
        }
    }

    public static class Allocator
    extends SegmentAllocatorBase<BytesSegment> {
        protected final boolean _cfgAllocateNative;

        public Allocator(int segmentSize, int minSegmentsToRetain, int maxSegments, boolean allocateNativeBuffers) {
            super(segmentSize, minSegmentsToRetain, maxSegments);
            this._cfgAllocateNative = allocateNativeBuffers;
        }

        @Override
        protected BytesSegment _allocateSegment() {
            if (this._reusableSegmentCount > 0) {
                BytesSegment segment = (BytesSegment)this._firstReusableSegment;
                this._firstReusableSegment = segment.getNext();
                ++this._bufferOwnedSegmentCount;
                --this._reusableSegmentCount;
                return segment;
            }
            ByteBufferBytesSegment segment = new ByteBufferBytesSegment(this._segmentSize, this._cfgAllocateNative);
            ++this._bufferOwnedSegmentCount;
            return segment;
        }
    }
}

