/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.impl;

import com.fasterxml.util.membuf.base.LongsSegment;
import com.fasterxml.util.membuf.base.SegmentAllocatorBase;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;

public class ByteBufferLongsSegment
extends LongsSegment {
    protected final LongBuffer _buffer;
    protected LongBuffer _readBuffer;

    public ByteBufferLongsSegment(int size, boolean useDirect) {
        if (size < 8) {
            size = 8;
        }
        this._buffer = useDirect ? ByteBuffer.allocateDirect(size << 3).asLongBuffer() : LongBuffer.allocate(size);
    }

    public static Allocator allocator(int segmentSize, int minSegmentsToRetain, int maxSegments, boolean allocateNativeBuffers) {
        return new Allocator(segmentSize, minSegmentsToRetain, maxSegments, allocateNativeBuffers);
    }

    @Override
    public LongsSegment initForReading() {
        super.initForReading();
        this._readBuffer = this._buffer.asReadOnlyBuffer();
        this._readBuffer.clear();
        return this;
    }

    @Override
    public LongsSegment finishReading() {
        LongsSegment result = (LongsSegment)super.finishReading();
        this._buffer.clear();
        this._readBuffer = null;
        return result;
    }

    @Override
    public void clear() {
        this._readBuffer = null;
        this._buffer.clear();
        super.clear();
    }

    @Override
    public final int availableForAppend() {
        return this._buffer.remaining();
    }

    @Override
    public final int availableForReading() {
        if (this._readBuffer == null) {
            throw new IllegalStateException("Method should not be called when _readBuffer is null");
        }
        return this._readBuffer.remaining();
    }

    @Override
    public void append(long[] src, int offset, int length) {
        this._buffer.put(src, offset, length);
    }

    @Override
    public int tryAppend(long[] src, int offset, int length) {
        int actualLen = Math.min(length, this.availableForAppend());
        if (actualLen > 0) {
            this._buffer.put(src, offset, actualLen);
        }
        return actualLen;
    }

    @Override
    public boolean tryAppend(long value) {
        if (this.availableForAppend() > 0) {
            this._buffer.put(value);
            return true;
        }
        return false;
    }

    @Override
    public long read() {
        return this._readBuffer.get();
    }

    @Override
    public void read(long[] buffer, int offset, int length) {
        this._readBuffer.get(buffer, offset, length);
    }

    @Override
    public int tryRead(long[] buffer, int offset, int length) {
        int actualLen = Math.min(this.availableForReading(), length);
        if (actualLen > 0) {
            this._readBuffer.get(buffer, offset, actualLen);
        }
        return actualLen;
    }

    @Override
    public int skip(int length) {
        length = Math.min(length, this.availableForReading());
        this._readBuffer.position(this._readBuffer.position() + length);
        return length;
    }

    @Override
    public int readLength() {
        if (this.availableForReading() < 1) {
            return -1;
        }
        return (int)this._readBuffer.get();
    }

    public static class Allocator
    extends SegmentAllocatorBase<LongsSegment> {
        protected final boolean _cfgAllocateNative;

        public Allocator(int segmentSize, int minSegmentsToRetain, int maxSegments, boolean allocateNativeBuffers) {
            super(segmentSize, minSegmentsToRetain, maxSegments);
            this._cfgAllocateNative = allocateNativeBuffers;
        }

        @Override
        protected LongsSegment _allocateSegment() {
            if (this._reusableSegmentCount > 0) {
                LongsSegment segment = (LongsSegment)this._firstReusableSegment;
                this._firstReusableSegment = segment.getNext();
                ++this._bufferOwnedSegmentCount;
                --this._reusableSegmentCount;
                return segment;
            }
            ByteBufferLongsSegment segment = new ByteBufferLongsSegment(this._segmentSize, this._cfgAllocateNative);
            ++this._bufferOwnedSegmentCount;
            return segment;
        }
    }
}

