/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.impl;

import com.fasterxml.util.membuf.ChunkyBytesMemBuffer;
import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.base.BytesSegment;

public class ChunkyBytesMemBufferImpl
extends ChunkyBytesMemBuffer {
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    protected final byte[] _lengthPrefixBuffer = new byte[5];

    public ChunkyBytesMemBufferImpl(SegmentAllocator<BytesSegment> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, BytesSegment initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
    }

    protected ChunkyBytesMemBufferImpl(ChunkyBytesMemBuffer src) {
        super(src);
    }

    @Override
    public final void appendEntry(byte[] data) {
        this.appendEntry(data, 0, data.length);
    }

    @Override
    public void appendEntry(byte[] data, int dataOffset, int dataLength) {
        if (!this.tryAppendEntry(data, dataOffset, dataLength)) {
            throw new IllegalStateException("Not enough room in buffer to append entry of " + dataLength + " (can't allocate enough new segments)");
        }
    }

    @Override
    public final boolean tryAppendEntry(byte[] data) {
        return this.tryAppendEntry(data, 0, data.length);
    }

    @Override
    public synchronized boolean tryAppendEntry(byte[] data, int dataOffset, int dataLength) {
        int totalLength;
        if (this._head == null) {
            this._reportClosed();
        }
        int prefixLength = this._calcLengthPrefix(this._lengthPrefixBuffer, dataLength);
        int freeInCurrent = ((BytesSegment)this._head).availableForAppend();
        if (freeInCurrent >= (totalLength = dataLength + prefixLength)) {
            ((BytesSegment)this._head).append(this._lengthPrefixBuffer, 0, prefixLength);
            ((BytesSegment)this._head).append(data, dataOffset, dataLength);
        } else {
            int neededSegments = (totalLength - freeInCurrent + (this._segmentSize - 1)) / this._segmentSize;
            int segmentsToAlloc = neededSegments - this._freeSegmentCount;
            if (segmentsToAlloc > 0) {
                if (this._usedSegmentsCount + this._freeSegmentCount + segmentsToAlloc > this._maxSegmentsToAllocate) {
                    return false;
                }
                BytesSegment newFree = (BytesSegment)this._segmentAllocator.allocateSegments(segmentsToAlloc, this._firstFreeSegment);
                if (newFree == null) {
                    return false;
                }
                this._freeSegmentCount += segmentsToAlloc;
                this._firstFreeSegment = newFree;
            }
            this._doAppendChunked(this._lengthPrefixBuffer, 0, prefixLength);
            this._doAppendChunked(data, dataOffset, dataLength);
        }
        this._totalPayloadLength += (long)dataLength;
        if (++this._entryCount == 1) {
            this.notifyAll();
        }
        return true;
    }

    protected void _doAppendChunked(byte[] buffer, int offset, int length) {
        if (length < 1) {
            return;
        }
        BytesSegment seg = (BytesSegment)this._head;
        while (true) {
            int actual = seg.tryAppend(buffer, offset, length);
            offset += actual;
            if ((length -= actual) == 0) {
                return;
            }
            seg.finishWriting();
            BytesSegment newSeg = (BytesSegment)((BytesSegment)this._reuseFree()).initForWriting();
            seg.relink(newSeg);
            seg = newSeg;
            this._head = seg;
        }
    }

    @Override
    public synchronized int getNextEntryLength() {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            return this._peekedEntry.length;
        }
        int len = this._nextEntryLength;
        if (len < 0) {
            if (this._entryCount == 0) {
                return -1;
            }
            this._nextEntryLength = len = this._readEntryLength();
        }
        return len;
    }

    @Override
    public synchronized byte[] getNextEntry() throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            byte[] result = this._peekedEntry;
            this._peekedEntry = null;
            return result;
        }
        while (this._entryCount == 0) {
            this._waitForData();
        }
        return this._doGetNext();
    }

    @Override
    public synchronized byte[] getNextEntryIfAvailable() {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            byte[] result = this._peekedEntry;
            this._peekedEntry = null;
            return result;
        }
        if (this._entryCount == 0) {
            return null;
        }
        return this._doGetNext();
    }

    @Override
    public synchronized byte[] getNextEntry(long timeoutMsecs) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            byte[] result = this._peekedEntry;
            this._peekedEntry = null;
            return result;
        }
        if (this._entryCount > 0) {
            return this._doGetNext();
        }
        long now = System.currentTimeMillis();
        long end = now + timeoutMsecs;
        while (now < end) {
            this._waitForData(end - now);
            if (this._entryCount > 0) {
                return this._doGetNext();
            }
            now = System.currentTimeMillis();
        }
        return null;
    }

    @Override
    public synchronized int readNextEntry(byte[] buffer, int offset) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            return this._doReadPeekedEntry(buffer, offset);
        }
        while (this._entryCount == 0) {
            this._waitForData();
        }
        return this._doReadNext(buffer, offset);
    }

    @Override
    public synchronized int readNextEntryIfAvailable(byte[] buffer, int offset) {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._entryCount == 0) {
            return Integer.MIN_VALUE;
        }
        return this._doReadNext(buffer, offset);
    }

    @Override
    public synchronized int readNextEntry(long timeoutMsecs, byte[] buffer, int offset) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._entryCount > 0) {
            return this._doReadNext(buffer, offset);
        }
        long now = System.currentTimeMillis();
        long end = now + timeoutMsecs;
        while (now < end) {
            this._waitForData(end - now);
            if (this._entryCount > 0) {
                return this._doReadNext(buffer, offset);
            }
            now = System.currentTimeMillis();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public synchronized byte[] peekNextEntry() {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry == null) {
            if (this._entryCount < 1) {
                return null;
            }
            this._peekedEntry = this._doGetNext();
        }
        return this._peekedEntry;
    }

    private int _readEntryLength() {
        int len = ((BytesSegment)this._tail).readLength();
        if (len >= 0) {
            return len;
        }
        len = -len - 1;
        String error = this._freeReadSegment(null);
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return ((BytesSegment)this._tail).readSplitLength(len);
    }

    private byte[] _doGetNext() {
        int segLen = this.getNextEntryLength();
        byte[] result = new byte[segLen];
        this._nextEntryLength = -1;
        --this._entryCount;
        this._totalPayloadLength -= (long)segLen;
        if (segLen == 0) {
            return EMPTY_PAYLOAD;
        }
        int avail = ((BytesSegment)this._tail).availableForReading();
        if (avail >= segLen) {
            ((BytesSegment)this._tail).read(result, 0, segLen);
        } else {
            this._doReadChunked(result, 0, segLen);
        }
        return result;
    }

    private int _doReadNext(byte[] buffer, int offset) {
        int end = buffer.length;
        if (offset >= end || offset < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset + "): allowed values [0, " + end + "[");
        }
        int maxLen = end - offset;
        int segLen = this.getNextEntryLength();
        if (segLen > maxLen) {
            return -segLen;
        }
        this._nextEntryLength = -1;
        --this._entryCount;
        this._totalPayloadLength -= (long)segLen;
        if (segLen == 0) {
            return 0;
        }
        int avail = ((BytesSegment)this._tail).availableForReading();
        if (avail >= segLen) {
            ((BytesSegment)this._tail).read(buffer, offset, segLen);
        } else {
            this._doReadChunked(buffer, offset, segLen);
        }
        return segLen;
    }

    protected void _doReadChunked(byte[] buffer, int offset, int length) {
        String error = null;
        while (true) {
            int actual = ((BytesSegment)this._tail).tryRead(buffer, offset, length);
            offset += actual;
            if ((length -= actual) == 0) break;
            error = this._freeReadSegment(error);
        }
        if (error != null) {
            throw new IllegalStateException(error);
        }
    }

    private int _doReadPeekedEntry(byte[] buffer, int offset) {
        int end = buffer.length;
        if (offset >= end || offset < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset + "): allowed values [0, " + end + "[");
        }
        int segLen = this._peekedEntry.length;
        int maxLen = end - offset;
        if (segLen > maxLen) {
            return -segLen;
        }
        if (segLen > 0) {
            System.arraycopy(this._peekedEntry, 0, buffer, offset, segLen);
        }
        this._peekedEntry = null;
        return segLen;
    }

    private int _calcLengthPrefix(byte[] buffer, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative length: " + length);
        }
        if (length <= 127) {
            buffer[0] = (byte)(length | 0x80);
            return 1;
        }
        if (length <= 16383) {
            buffer[0] = (byte)(length >> 7 & 0x7F);
            buffer[1] = (byte)(length & 0x7F | 0x80);
            return 2;
        }
        if (length <= 0x1FFFFF) {
            buffer[0] = (byte)(length >> 14 & 0x7F);
            buffer[1] = (byte)(length >> 7 & 0x7F);
            buffer[2] = (byte)(length & 0x7F | 0x80);
            return 3;
        }
        if (length <= 0xFFFFFFF) {
            buffer[0] = (byte)(length >> 21 & 0x7F);
            buffer[1] = (byte)(length >> 14 & 0x7F);
            buffer[2] = (byte)(length >> 7 & 0x7F);
            buffer[3] = (byte)(length & 0x7F | 0x80);
            return 4;
        }
        buffer[0] = (byte)(length >> 28 & 0x7F);
        buffer[1] = (byte)(length >> 21 & 0x7F);
        buffer[2] = (byte)(length >> 14 & 0x7F);
        buffer[3] = (byte)(length >> 7 & 0x7F);
        buffer[4] = (byte)(length & 0x7F | 0x80);
        return 5;
    }
}

