/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.impl;

import com.fasterxml.util.membuf.ChunkyLongsMemBuffer;
import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.base.LongsSegment;

public class ChunkyLongsMemBufferImpl
extends ChunkyLongsMemBuffer {
    private static final long[] EMPTY_PAYLOAD = new long[0];

    public ChunkyLongsMemBufferImpl(SegmentAllocator<LongsSegment> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, LongsSegment initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
    }

    protected ChunkyLongsMemBufferImpl(ChunkyLongsMemBuffer src) {
        super(src);
    }

    @Override
    public synchronized boolean tryAppendEntry(long[] data, int dataOffset, int dataLength) {
        int totalLength;
        int freeInCurrent;
        if (this._head == null) {
            this._reportClosed();
        }
        if ((freeInCurrent = ((LongsSegment)this._head).availableForAppend()) >= (totalLength = dataLength + 1)) {
            if (!((LongsSegment)this._head).tryAppend(dataLength)) {
                throw new IllegalStateException();
            }
            ((LongsSegment)this._head).append(data, dataOffset, dataLength);
        } else {
            int neededSegments = (totalLength - freeInCurrent + (this._segmentSize - 1)) / this._segmentSize;
            int segmentsToAlloc = neededSegments - this._freeSegmentCount;
            if (segmentsToAlloc > 0) {
                if (this._usedSegmentsCount + this._freeSegmentCount + segmentsToAlloc > this._maxSegmentsToAllocate) {
                    return false;
                }
                LongsSegment newFree = (LongsSegment)this._segmentAllocator.allocateSegments(segmentsToAlloc, this._firstFreeSegment);
                if (newFree == null) {
                    return false;
                }
                this._freeSegmentCount += segmentsToAlloc;
                this._firstFreeSegment = newFree;
            }
            this._doAppendChunked(data, dataOffset, dataLength);
        }
        this._totalPayloadLength += (long)dataLength;
        if (++this._entryCount == 1) {
            this.notifyAll();
        }
        return true;
    }

    protected void _doAppendChunked(long[] buffer, int offset, int length) {
        LongsSegment seg;
        if (!((LongsSegment)this._head).tryAppend(length)) {
            seg = (LongsSegment)this._head;
            seg.finishWriting();
            LongsSegment newSeg = (LongsSegment)((LongsSegment)this._reuseFree()).initForWriting();
            seg.relink(newSeg);
            this._head = newSeg;
            if (!((LongsSegment)this._head).tryAppend(length)) {
                throw new IllegalStateException();
            }
        }
        if (length > 0) {
            seg = (LongsSegment)this._head;
            while (true) {
                int actual = seg.tryAppend(buffer, offset, length);
                offset += actual;
                if ((length -= actual) == 0) {
                    return;
                }
                seg.finishWriting();
                LongsSegment newSeg = (LongsSegment)((LongsSegment)this._reuseFree()).initForWriting();
                seg.relink(newSeg);
                seg = newSeg;
                this._head = seg;
            }
        }
    }

    @Override
    public synchronized int getNextEntryLength() {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            return this._peekedEntry.length;
        }
        int len = this._nextEntryLength;
        if (len < 0) {
            if (this._entryCount == 0) {
                return -1;
            }
            this._nextEntryLength = len = this._readEntryLength();
        }
        return len;
    }

    @Override
    public synchronized long[] getNextEntry() throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            long[] result = this._peekedEntry;
            this._peekedEntry = null;
            return result;
        }
        while (this._entryCount == 0) {
            this._waitForData();
        }
        return this._doGetNext();
    }

    @Override
    public synchronized long[] getNextEntryIfAvailable() {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            long[] result = this._peekedEntry;
            this._peekedEntry = null;
            return result;
        }
        if (this._entryCount == 0) {
            return null;
        }
        return this._doGetNext();
    }

    @Override
    public synchronized long[] getNextEntry(long timeoutMsecs) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            long[] result = this._peekedEntry;
            this._peekedEntry = null;
            return result;
        }
        if (this._entryCount > 0) {
            return this._doGetNext();
        }
        long now = System.currentTimeMillis();
        long end = now + timeoutMsecs;
        while (now < end) {
            this._waitForData(end - now);
            if (this._entryCount > 0) {
                return this._doGetNext();
            }
            now = System.currentTimeMillis();
        }
        return null;
    }

    @Override
    public synchronized int readNextEntry(long[] buffer, int offset) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry != null) {
            return this._doReadPeekedEntry(buffer, offset);
        }
        while (this._entryCount == 0) {
            this._waitForData();
        }
        return this._doReadNext(buffer, offset);
    }

    @Override
    public synchronized int readNextEntryIfAvailable(long[] buffer, int offset) {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._entryCount == 0) {
            return Integer.MIN_VALUE;
        }
        return this._doReadNext(buffer, offset);
    }

    @Override
    public synchronized int readNextEntry(long timeoutMsecs, long[] buffer, int offset) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._entryCount > 0) {
            return this._doReadNext(buffer, offset);
        }
        long now = System.currentTimeMillis();
        long end = now + timeoutMsecs;
        while (now < end) {
            this._waitForData(end - now);
            if (this._entryCount > 0) {
                return this._doReadNext(buffer, offset);
            }
            now = System.currentTimeMillis();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public synchronized long[] peekNextEntry() {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._peekedEntry == null) {
            if (this._entryCount < 1) {
                return null;
            }
            this._peekedEntry = this._doGetNext();
        }
        return this._peekedEntry;
    }

    private int _readEntryLength() {
        int len = ((LongsSegment)this._tail).readLength();
        if (len >= 0) {
            return len;
        }
        String error = this._freeReadSegment(null);
        if (error != null) {
            throw new IllegalStateException(error);
        }
        len = ((LongsSegment)this._tail).readLength();
        if (len < 0) {
            throw new IllegalStateException("Failed to read next segment length");
        }
        return len;
    }

    private long[] _doGetNext() {
        int segLen = this.getNextEntryLength();
        long[] result = new long[segLen];
        this._nextEntryLength = -1;
        --this._entryCount;
        this._totalPayloadLength -= (long)segLen;
        if (segLen == 0) {
            return EMPTY_PAYLOAD;
        }
        int avail = ((LongsSegment)this._tail).availableForReading();
        if (avail >= segLen) {
            ((LongsSegment)this._tail).read(result, 0, segLen);
        } else {
            this._doReadChunked(result, 0, segLen);
        }
        return result;
    }

    private int _doReadNext(long[] buffer, int offset) {
        int end = buffer.length;
        if (offset >= end || offset < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset + "): allowed values [0, " + end + "[");
        }
        int maxLen = end - offset;
        int segLen = this.getNextEntryLength();
        if (segLen > maxLen) {
            return -segLen;
        }
        this._nextEntryLength = -1;
        --this._entryCount;
        if (segLen == 0) {
            return 0;
        }
        this._totalPayloadLength -= (long)segLen;
        int avail = ((LongsSegment)this._tail).availableForReading();
        if (avail >= segLen) {
            ((LongsSegment)this._tail).read(buffer, offset, segLen);
        } else {
            this._doReadChunked(buffer, offset, segLen);
        }
        return segLen;
    }

    private final void _doReadChunked(long[] buffer, int offset, int length) {
        String error = null;
        while (true) {
            int actual = ((LongsSegment)this._tail).tryRead(buffer, offset, length);
            offset += actual;
            if ((length -= actual) == 0) break;
            error = this._freeReadSegment(error);
        }
        if (error != null) {
            throw new IllegalStateException(error);
        }
    }

    private int _doReadPeekedEntry(long[] buffer, int offset) {
        int end = buffer.length;
        if (offset >= end || offset < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset + "): allowed values [0, " + end + "[");
        }
        int segLen = this._peekedEntry.length;
        int maxLen = end - offset;
        if (segLen > maxLen) {
            return -segLen;
        }
        if (segLen > 0) {
            System.arraycopy(this._peekedEntry, 0, buffer, offset, segLen);
        }
        this._peekedEntry = null;
        return segLen;
    }
}

