/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.util.membuf.impl;

import com.fasterxml.util.membuf.SegmentAllocator;
import com.fasterxml.util.membuf.StreamyLongsMemBuffer;
import com.fasterxml.util.membuf.base.LongsSegment;

public class StreamyLongsMemBufferImpl
extends StreamyLongsMemBuffer {
    public StreamyLongsMemBufferImpl(SegmentAllocator<LongsSegment> allocator, int minSegmentsToAllocate, int maxSegmentsToAllocate, LongsSegment initialSegments) {
        super(allocator, minSegmentsToAllocate, maxSegmentsToAllocate, initialSegments);
    }

    protected StreamyLongsMemBufferImpl(StreamyLongsMemBuffer src) {
        super(src);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this._totalPayloadLength == 0L;
    }

    @Override
    public synchronized long available() {
        return this._totalPayloadLength;
    }

    @Override
    public synchronized boolean tryAppend(long value) {
        if (this._head == null) {
            this._reportClosed();
        }
        if (((LongsSegment)this._head).tryAppend(value)) {
            ++this._totalPayloadLength;
            return true;
        }
        if (this._freeSegmentCount <= 0) {
            if (this._usedSegmentsCount >= this._maxSegmentsToAllocate) {
                return false;
            }
            LongsSegment newFree = (LongsSegment)this._segmentAllocator.allocateSegments(1, this._firstFreeSegment);
            if (newFree == null) {
                return false;
            }
            ++this._freeSegmentCount;
            this._firstFreeSegment = newFree;
        }
        LongsSegment seg = (LongsSegment)this._head;
        seg.finishWriting();
        LongsSegment newSeg = (LongsSegment)((LongsSegment)this._reuseFree()).initForWriting();
        seg.relink(newSeg);
        this._head = newSeg;
        if (!((LongsSegment)this._head).tryAppend(value)) {
            throw new IllegalStateException("Should have room for a byte after allocation");
        }
        ++this._totalPayloadLength;
        return true;
    }

    @Override
    public synchronized boolean tryAppend(long[] data, int dataOffset, int dataLength) {
        int freeInCurrent;
        if (this._head == null) {
            this._reportClosed();
        }
        if ((freeInCurrent = ((LongsSegment)this._head).availableForAppend()) >= dataLength) {
            ((LongsSegment)this._head).append(data, dataOffset, dataLength);
        } else {
            int neededSegments = (dataLength - freeInCurrent + (this._segmentSize - 1)) / this._segmentSize;
            int segmentsToAlloc = neededSegments - this._freeSegmentCount;
            if (segmentsToAlloc > 0) {
                if (this._usedSegmentsCount + this._freeSegmentCount + segmentsToAlloc > this._maxSegmentsToAllocate) {
                    return false;
                }
                LongsSegment newFree = (LongsSegment)this._segmentAllocator.allocateSegments(segmentsToAlloc, this._firstFreeSegment);
                if (newFree == null) {
                    return false;
                }
                this._freeSegmentCount += segmentsToAlloc;
                this._firstFreeSegment = newFree;
            }
            this._doAppendChunked(data, dataOffset, dataLength);
        }
        boolean wasEmpty = this._totalPayloadLength == 0L;
        this._totalPayloadLength += (long)dataLength;
        if (wasEmpty) {
            this.notifyAll();
        }
        return true;
    }

    protected void _doAppendChunked(long[] buffer, int offset, int length) {
        if (length < 1) {
            return;
        }
        LongsSegment seg = (LongsSegment)this._head;
        while (true) {
            int actual = seg.tryAppend(buffer, offset, length);
            offset += actual;
            if ((length -= actual) == 0) {
                return;
            }
            seg.finishWriting();
            LongsSegment newSeg = (LongsSegment)((LongsSegment)this._reuseFree()).initForWriting();
            seg.relink(newSeg);
            seg = newSeg;
            this._head = seg;
        }
    }

    @Override
    public synchronized long read() throws InterruptedException {
        String error;
        if (this._head == null) {
            this._reportClosed();
        }
        while (this._totalPayloadLength == 0L) {
            this._waitForData();
        }
        if (((LongsSegment)this._tail).availableForReading() == 0 && (error = this._freeReadSegment(null)) != null) {
            throw new IllegalStateException(error);
        }
        long l = ((LongsSegment)this._tail).read();
        --this._totalPayloadLength;
        return l;
    }

    @Override
    public synchronized int read(long[] buffer, int offset, int length) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (length < 1) {
            return 0;
        }
        while (this._totalPayloadLength == 0L) {
            this._waitForData();
        }
        return this._doRead(buffer, offset, length);
    }

    @Override
    public synchronized int readIfAvailable(long[] buffer, int offset, int length) {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._totalPayloadLength == 0L) {
            return 0;
        }
        return this._doRead(buffer, offset, length);
    }

    @Override
    public synchronized int read(long timeoutMsecs, long[] buffer, int offset, int length) throws InterruptedException {
        if (this._head == null) {
            this._reportClosed();
        }
        if (this._totalPayloadLength > 0L) {
            return this._doRead(buffer, offset, length);
        }
        long now = System.currentTimeMillis();
        long end = now + timeoutMsecs;
        while (now < end) {
            this._waitForData(end - now);
            if (this._totalPayloadLength > 0L) {
                return this._doRead(buffer, offset, length);
            }
            now = System.currentTimeMillis();
        }
        return 0;
    }

    private final int _doRead(long[] buffer, int offset, int length) {
        int avail;
        if (length < 1) {
            return 0;
        }
        int end = buffer.length;
        if (offset >= end || offset < 0) {
            throw new IllegalArgumentException("Illegal offset (" + offset + "): allowed values [0, " + end + "[");
        }
        if (offset + length > end) {
            throw new IllegalArgumentException("Illegal length (" + length + "): offset (" + offset + ") + length end past end of buffer (" + end + ")");
        }
        if ((long)length > this._totalPayloadLength) {
            length = (int)this._totalPayloadLength;
        }
        if ((avail = ((LongsSegment)this._tail).availableForReading()) >= length) {
            this._totalPayloadLength -= (long)length;
            ((LongsSegment)this._tail).read(buffer, offset, length);
            return length;
        }
        String error = null;
        int remaining = length;
        while (true) {
            int actual = ((LongsSegment)this._tail).tryRead(buffer, offset, remaining);
            this._totalPayloadLength -= (long)actual;
            offset += actual;
            if ((remaining -= actual) == 0) break;
            error = this._freeReadSegment(error);
        }
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return length;
    }

    @Override
    protected void _clearPeeked() {
    }

    @Override
    protected int _peekedLength() {
        return 0;
    }
}

