/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.javaluator.examples;

import com.fathzer.soft.javaluator.DoubleEvaluator;
import com.fathzer.soft.javaluator.Parameters;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;

public class LocalizedEvaluator
extends DoubleEvaluator {
    private static final Parameters PARAMS = DoubleEvaluator.getDefaultParameters();
    private DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(Locale.FRENCH);

    public LocalizedEvaluator() {
        super(PARAMS);
        this.format.setGroupingUsed(true);
    }

    protected Double toValue(String literal, Object evaluationContext) {
        try {
            literal = literal.replace(' ', '\u00a0');
            return this.format.parse(literal).doubleValue();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(literal + " is not a number");
        }
    }

    public static void main(String[] args) {
        LocalizedEvaluator evaluator = new LocalizedEvaluator();
        String expression = "3 000 +moyenne(3 ; somme(1,5 ; 7 ; -3,5))";
        System.out.println(expression + " = " + evaluator.format.format(evaluator.evaluate(expression)));
    }

    static {
        PARAMS.setTranslation(DoubleEvaluator.SUM, "somme");
        PARAMS.setTranslation(DoubleEvaluator.AVERAGE, "moyenne");
        PARAMS.setFunctionArgumentSeparator(';');
    }
}

