/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.javaluator;

import com.fathzer.soft.javaluator.AbstractEvaluator;
import com.fathzer.soft.javaluator.BracketPair;
import com.fathzer.soft.javaluator.Constant;
import com.fathzer.soft.javaluator.Function;
import com.fathzer.soft.javaluator.Operator;
import com.fathzer.soft.javaluator.Parameters;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DoubleEvaluator
extends AbstractEvaluator<Double> {
    public static final Constant PI = new Constant("pi");
    public static final Constant E = new Constant("e");
    public static final Function CEIL = new Function("ceil", 1);
    public static final Function FLOOR = new Function("floor", 1);
    public static final Function ROUND = new Function("round", 1);
    public static final Function ABS = new Function("abs", 1);
    public static final Function SINE = new Function("sin", 1);
    public static final Function COSINE = new Function("cos", 1);
    public static final Function TANGENT = new Function("tan", 1);
    public static final Function ACOSINE = new Function("acos", 1);
    public static final Function ASINE = new Function("asin", 1);
    public static final Function ATAN = new Function("atan", 1);
    public static final Function SINEH = new Function("sinh", 1);
    public static final Function COSINEH = new Function("cosh", 1);
    public static final Function TANGENTH = new Function("tanh", 1);
    public static final Function MIN = new Function("min", 1, Integer.MAX_VALUE);
    public static final Function MAX = new Function("max", 1, Integer.MAX_VALUE);
    public static final Function SUM = new Function("sum", 1, Integer.MAX_VALUE);
    public static final Function AVERAGE = new Function("avg", 1, Integer.MAX_VALUE);
    public static final Function LN = new Function("ln", 1);
    public static final Function LOG = new Function("log", 1);
    public static final Function RANDOM = new Function("random", 0);
    public static final Operator NEGATE = new Operator("-", 1, Operator.Associativity.RIGHT, 3);
    public static final Operator NEGATE_HIGH = new Operator("-", 1, Operator.Associativity.RIGHT, 5);
    public static final Operator MINUS = new Operator("-", 2, Operator.Associativity.LEFT, 1);
    public static final Operator PLUS = new Operator("+", 2, Operator.Associativity.LEFT, 1);
    public static final Operator MULTIPLY = new Operator("*", 2, Operator.Associativity.LEFT, 2);
    public static final Operator DIVIDE = new Operator("/", 2, Operator.Associativity.LEFT, 2);
    public static final Operator EXPONENT = new Operator("^", 2, Operator.Associativity.LEFT, 4);
    public static final Operator MODULO = new Operator("%", 2, Operator.Associativity.LEFT, 2);
    private static final Operator[] OPERATORS = new Operator[]{NEGATE, MINUS, PLUS, MULTIPLY, DIVIDE, EXPONENT, MODULO};
    private static final Operator[] OPERATORS_EXCEL = new Operator[]{NEGATE_HIGH, MINUS, PLUS, MULTIPLY, DIVIDE, EXPONENT, MODULO};
    private static final Function[] FUNCTIONS = new Function[]{SINE, COSINE, TANGENT, ASINE, ACOSINE, ATAN, SINEH, COSINEH, TANGENTH, MIN, MAX, SUM, AVERAGE, LN, LOG, ROUND, CEIL, FLOOR, ABS, RANDOM};
    private static final Constant[] CONSTANTS = new Constant[]{PI, E};
    private static Parameters defaultParameters;
    private static final Pattern SCIENTIFIC_NOTATION_PATTERN;
    private static final ThreadLocal<NumberFormat> FORMATTER;
    private boolean supportsScientificNotation;

    public static Parameters getDefaultParameters() {
        return DoubleEvaluator.getDefaultParameters(Style.STANDARD);
    }

    public static Parameters getDefaultParameters(Style style) {
        Parameters result = new Parameters();
        result.addOperators(style == Style.STANDARD ? Arrays.asList(OPERATORS) : Arrays.asList(OPERATORS_EXCEL));
        result.addFunctions(Arrays.asList(FUNCTIONS));
        result.addConstants(Arrays.asList(CONSTANTS));
        result.addFunctionBracket(BracketPair.PARENTHESES);
        result.addExpressionBracket(BracketPair.PARENTHESES);
        return result;
    }

    private static Parameters getParameters() {
        if (defaultParameters == null) {
            defaultParameters = DoubleEvaluator.getDefaultParameters();
        }
        return defaultParameters;
    }

    public DoubleEvaluator() {
        this(DoubleEvaluator.getParameters());
    }

    public DoubleEvaluator(Parameters parameters) {
        super(parameters);
    }

    public DoubleEvaluator(Parameters parameters, boolean supportsScientificNotation) {
        super(parameters);
        this.supportsScientificNotation = supportsScientificNotation;
    }

    @Override
    protected Iterator<String> tokenize(String expression) {
        if (this.supportsScientificNotation) {
            ArrayList<String> tokens = new ArrayList<String>();
            Iterator<String> rawTokens = super.tokenize(expression);
            while (rawTokens.hasNext()) {
                tokens.add(rawTokens.next());
            }
            for (int i = 1; i < tokens.size() - 1; ++i) {
                this.testScientificNotation(tokens, i);
            }
            return tokens.iterator();
        }
        return super.tokenize(expression);
    }

    private void testScientificNotation(List<String> tokens, int index) {
        String previous = tokens.get(index - 1);
        String next = tokens.get(index + 1);
        String current = tokens.get(index);
        String candidate = previous + current + next;
        if (DoubleEvaluator.isScientificNotation(candidate)) {
            tokens.set(index - 1, candidate);
            tokens.remove(index);
            tokens.remove(index);
        }
    }

    public static boolean isScientificNotation(String str) {
        Matcher matcher = SCIENTIFIC_NOTATION_PATTERN.matcher(str);
        if (!matcher.find()) {
            return false;
        }
        String matched = matcher.group();
        return matched.length() == str.length();
    }

    @Override
    protected Double toValue(String literal, Object evaluationContext) {
        ParsePosition p = new ParsePosition(0);
        Number result = FORMATTER.get().parse(literal, p);
        if (p.getIndex() == 0 || p.getIndex() != literal.length()) {
            if (this.supportsScientificNotation && DoubleEvaluator.isScientificNotation(literal)) {
                return Double.valueOf(literal);
            }
            throw new IllegalArgumentException(literal + " is not a number");
        }
        return result.doubleValue();
    }

    @Override
    protected Double evaluate(Constant constant, Object evaluationContext) {
        if (PI.equals(constant)) {
            return Math.PI;
        }
        if (E.equals(constant)) {
            return Math.E;
        }
        return (Double)super.evaluate(constant, evaluationContext);
    }

    @Override
    protected Double evaluate(Operator operator, Iterator<Double> operands, Object evaluationContext) {
        if (NEGATE.equals(operator) || NEGATE_HIGH.equals(operator)) {
            return -operands.next().doubleValue();
        }
        if (MINUS.equals(operator)) {
            return operands.next() - operands.next();
        }
        if (PLUS.equals(operator)) {
            return operands.next() + operands.next();
        }
        if (MULTIPLY.equals(operator)) {
            return operands.next() * operands.next();
        }
        if (DIVIDE.equals(operator)) {
            return operands.next() / operands.next();
        }
        if (EXPONENT.equals(operator)) {
            return Math.pow(operands.next(), operands.next());
        }
        if (MODULO.equals(operator)) {
            return operands.next() % operands.next();
        }
        return super.evaluate(operator, operands, evaluationContext);
    }

    @Override
    protected Double evaluate(Function function, Iterator<Double> arguments, Object evaluationContext) {
        Double result;
        if (ABS.equals(function)) {
            result = Math.abs(arguments.next());
        } else if (CEIL.equals(function)) {
            result = Math.ceil(arguments.next());
        } else if (FLOOR.equals(function)) {
            result = Math.floor(arguments.next());
        } else if (ROUND.equals(function)) {
            Double arg = arguments.next();
            result = arg == Double.NEGATIVE_INFINITY || arg == Double.POSITIVE_INFINITY ? arg : Double.valueOf(Math.round(arg));
        } else if (SINEH.equals(function)) {
            result = Math.sinh(arguments.next());
        } else if (COSINEH.equals(function)) {
            result = Math.cosh(arguments.next());
        } else if (TANGENTH.equals(function)) {
            result = Math.tanh(arguments.next());
        } else if (SINE.equals(function)) {
            result = Math.sin(arguments.next());
        } else if (COSINE.equals(function)) {
            result = Math.cos(arguments.next());
        } else if (TANGENT.equals(function)) {
            result = Math.tan(arguments.next());
        } else if (ACOSINE.equals(function)) {
            result = Math.acos(arguments.next());
        } else if (ASINE.equals(function)) {
            result = Math.asin(arguments.next());
        } else if (ATAN.equals(function)) {
            result = Math.atan(arguments.next());
        } else if (MIN.equals(function)) {
            result = arguments.next();
            while (arguments.hasNext()) {
                result = Math.min(result, arguments.next());
            }
        } else if (MAX.equals(function)) {
            result = arguments.next();
            while (arguments.hasNext()) {
                result = Math.max(result, arguments.next());
            }
        } else if (SUM.equals(function)) {
            result = 0.0;
            while (arguments.hasNext()) {
                result = result + arguments.next();
            }
        } else if (AVERAGE.equals(function)) {
            result = 0.0;
            int nb = 0;
            while (arguments.hasNext()) {
                result = result + arguments.next();
                ++nb;
            }
            result = result / (double)nb;
        } else {
            result = LN.equals(function) ? Double.valueOf(Math.log(arguments.next())) : (LOG.equals(function) ? Double.valueOf(Math.log10(arguments.next())) : (RANDOM.equals(function) ? Double.valueOf(Math.random()) : super.evaluate(function, arguments, evaluationContext)));
        }
        this.errIfNaN(result, function);
        return result;
    }

    private void errIfNaN(Double result, Function function) {
        if (result.equals(Double.NaN)) {
            throw new IllegalArgumentException("Invalid argument passed to " + function.getName());
        }
    }

    static {
        SCIENTIFIC_NOTATION_PATTERN = Pattern.compile("([+-]?(?:\\d+(?:\\.\\d*)?|\\.\\d+)[eE][+-]?\\d+)$");
        FORMATTER = new ThreadLocal<NumberFormat>(){

            @Override
            protected NumberFormat initialValue() {
                return NumberFormat.getNumberInstance(Locale.US);
            }
        };
    }

    public static enum Style {
        STANDARD,
        EXCEL;

    }
}

