/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.common;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.faunadb.common.http.DriverVersionChecker;
import java.io.IOError;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final String API_VERSION = "4";
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final String DEFAULT_USER_AGENT = "Fauna JVM Http Client";
    private static final URL FAUNA_ROOT;
    private static final String X_FAUNADB_HOST = "X-FaunaDB-Host";
    private static final String X_FAUNADB_BUILD = "X-FaunaDB-Build";
    private static final String X_DRIVER_ENV = "X-Driver-Env";
    private static final String X_QUERY_TIMEOUT = "X-Query-Timeout";
    private static final String X_LAST_SEEN_TXN = "X-Last-Seen-Txn";
    private static final String X_FAUNADB_API_VERSION = "X-FaunaDB-API-Version";
    private static final String USER_AGENT = "User-Agent";
    private final URL faunaRoot;
    private final String authHeader;
    private final String runtimeEnvironmentHeader;
    private HttpClient client;
    private final MetricRegistry registry;
    private final Optional<Duration> defaultQueryTimeout;
    private final String userAgent;
    private final Map<String, String> customHeaders;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper json = new ObjectMapper();
    private final AtomicLong txnTime = new AtomicLong(0L);

    public static Builder builder() {
        return new Builder();
    }

    private Connection(URL uRL, String string, HttpClient httpClient, MetricRegistry metricRegistry, String string2, long l, Optional<Duration> optional, String string3, Map<String, String> map) {
        this.faunaRoot = uRL;
        this.authHeader = Connection.generateAuthHeader(string);
        this.runtimeEnvironmentHeader = string2;
        this.client = httpClient;
        this.registry = metricRegistry;
        this.txnTime.set(l);
        this.defaultQueryTimeout = optional;
        this.userAgent = string3;
        this.customHeaders = map;
    }

    public Connection newSessionConnection(String string) {
        return new Connection(this.faunaRoot, string, this.client, this.registry, this.runtimeEnvironmentHeader, this.getLastTxnTime(), this.defaultQueryTimeout, this.userAgent, this.customHeaders);
    }

    public long getLastTxnTime() {
        return this.txnTime.get();
    }

    public void syncLastTxnTime(long l) {
        long l2;
        while ((l2 = this.getLastTxnTime()) < l && !this.txnTime.compareAndSet(l2, l)) {
        }
    }

    public CompletableFuture<HttpResponse<String>> get(String string, Optional<Duration> optional) {
        return this.performRequest("GET", string, Optional.empty(), Map.of(), optional);
    }

    public CompletableFuture<HttpResponse<String>> get(String string, Map<String, List<String>> map, Optional<Duration> optional) {
        return this.performRequest("GET", string, Optional.empty(), map, optional);
    }

    public CompletableFuture<HttpResponse<String>> post(String string, JsonNode jsonNode, Optional<Duration> optional) {
        return this.performRequest("POST", string, Optional.of(jsonNode), Map.of(), optional);
    }

    public CompletableFuture<HttpResponse<String>> put(String string, JsonNode jsonNode, Optional<Duration> optional) {
        return this.performRequest("PUT", string, Optional.of(jsonNode), Map.of(), optional);
    }

    public CompletableFuture<HttpResponse<String>> patch(String string, JsonNode jsonNode, Optional<Duration> optional) {
        return this.performRequest("PATCH", string, Optional.of(jsonNode), Map.of(), optional);
    }

    private static URI appendUri(URI uRI, String string2, List<String> list) throws URISyntaxException {
        String string3 = URLEncoder.encode(string2, StandardCharsets.UTF_8);
        String string4 = list.stream().map(string -> URLEncoder.encode(string, StandardCharsets.UTF_8)).collect(Collectors.joining(","));
        String string5 = string3 + "=" + string4;
        return new URI(uRI.getScheme(), uRI.getAuthority(), uRI.getPath(), uRI.getQuery() == null ? string5 : uRI.getQuery() + "&" + string5, uRI.getFragment());
    }

    private CompletableFuture<HttpResponse<String>> performRequest(String string, String string2, Optional<JsonNode> optional, Map<String, List<String>> map, Optional<Duration> optional2) {
        HttpRequest httpRequest;
        Timer.Context context = this.registry.timer("fauna-request").time();
        CompletableFuture<HttpResponse<String>> completableFuture = new CompletableFuture<HttpResponse<String>>();
        try {
            httpRequest = this.makeHttpRequest(string, string2, optional, map, optional2, HttpClient.Version.HTTP_1_1);
        }
        catch (JsonProcessingException | IllegalArgumentException | MalformedURLException | URISyntaxException throwable2) {
            completableFuture.completeExceptionally(throwable2);
            return completableFuture;
        }
        this.sendRequest(httpRequest).whenCompleteAsync((httpResponse, throwable) -> {
            context.stop();
            if (throwable != null) {
                this.logFailure(httpRequest, (Throwable)throwable);
                completableFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            Optional<String> optional = httpResponse.headers().firstValue("x-txn-time");
            optional.ifPresent(string -> this.syncLastTxnTime(Long.parseLong(string)));
            this.logSuccess(httpRequest, (HttpResponse<String>)httpResponse);
            completableFuture.complete((HttpResponse<String>)httpResponse);
        });
        return completableFuture;
    }

    private CompletableFuture<HttpResponse<String>> sendRequest(HttpRequest httpRequest) {
        return this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
    }

    public CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>> streamRequest(HttpRequest httpRequest) {
        return this.client.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofPublisher());
    }

    public CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>> performStreamRequest(String string, String string2, JsonNode jsonNode, Map<String, List<String>> map) {
        HttpRequest httpRequest;
        Timer.Context context = this.registry.timer("fauna-request").time();
        CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>> completableFuture = new CompletableFuture<HttpResponse<Flow.Publisher<List<ByteBuffer>>>>();
        try {
            httpRequest = this.makeHttpRequest(string, string2, Optional.of(jsonNode), map, Optional.empty(), HttpClient.Version.HTTP_2);
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException throwable2) {
            completableFuture.completeExceptionally(throwable2);
            return completableFuture;
        }
        this.streamRequest(httpRequest).whenCompleteAsync((httpResponse, throwable) -> {
            context.stop();
            if (throwable != null) {
                this.logFailure(httpRequest, (Throwable)throwable);
                completableFuture.completeExceptionally((Throwable)throwable);
                return;
            }
            Optional<String> optional = httpResponse.headers().firstValue("x-txn-time");
            optional.ifPresent(string -> this.syncLastTxnTime(Long.parseLong(string)));
            completableFuture.complete((HttpResponse<Flow.Publisher<List<ByteBuffer>>>)httpResponse);
        });
        return completableFuture;
    }

    private HttpRequest makeHttpRequest(String string, String string2, Optional<JsonNode> optional, Map<String, List<String>> map, Optional<Duration> optional2, HttpClient.Version version) throws MalformedURLException, URISyntaxException, JsonProcessingException {
        List<String> list;
        Map.Entry<String, List<String>> entry2;
        URI uRI = URI.create(this.mkUrl(string2));
        for (Map.Entry<String, List<String>> entry2 : map.entrySet()) {
            list = entry2.getValue();
            if (list.isEmpty()) continue;
            uRI = Connection.appendUri(uRI, (String)entry2.getKey(), list);
        }
        Object object = HttpRequest.BodyPublishers.noBody();
        if (optional.isPresent()) {
            entry2 = (Map.Entry<String, List<String>>)this.json.writeValueAsBytes((Object)optional.get());
            object = HttpRequest.BodyPublishers.ofByteArray((byte[])entry2);
        }
        entry2 = optional2.or(() -> this.defaultQueryTimeout).orElse(DEFAULT_REQUEST_TIMEOUT);
        list = this.getLastTxnTime() > 0L ? Optional.of(this.getLastTxnTime()) : Optional.empty();
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uRI).version(version).timeout((Duration)((Object)entry2)).method(string, (HttpRequest.BodyPublisher)object).headers(this.mkHeaders((Duration)((Object)entry2)));
        ((Optional)((Object)list)).ifPresent(l -> builder.header(X_LAST_SEEN_TXN, Long.toString(l)));
        return builder.build();
    }

    private String[] mkHeaders(Duration duration) {
        Map<String, String> map = Map.of("Authorization", this.authHeader, X_FAUNADB_API_VERSION, API_VERSION, USER_AGENT, this.userAgent, X_QUERY_TIMEOUT, String.valueOf(duration.toMillis()), X_DRIVER_ENV, this.runtimeEnvironmentHeader, "Content-type", "application/json; charset=utf-8");
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        if (this.customHeaders != null) {
            for (Map.Entry entry : this.customHeaders.entrySet()) {
                hashMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        String[] stringArray = new String[hashMap.size() * 2];
        boolean n = false;
        for (Map.Entry entry : hashMap.entrySet()) {
            stringArray[var5_7] = (String)entry.getKey();
            stringArray[var5_7 + true] = (String)entry.getValue();
            var5_7 += 2;
        }
        return stringArray;
    }

    private String mkUrl(String string) throws MalformedURLException {
        return new URL(this.faunaRoot, string).toString();
    }

    private void logSuccess(HttpRequest httpRequest, HttpResponse<String> httpResponse) {
        if (this.log.isDebugEnabled()) {
            String string = httpRequest.bodyPublisher().map(Object::toString).orElse("NoBody");
            String string2 = Optional.ofNullable(httpResponse.body()).orElse("");
            String string3 = httpResponse.headers().firstValue(X_FAUNADB_HOST).orElse("Unknown");
            String string4 = httpResponse.headers().firstValue(X_FAUNADB_BUILD).orElse("Unknown");
            this.log.debug(String.format("Request: %s %s: [%s]. Response: Status=%d, Fauna Host: %s, Fauna Build: %s: %s", httpRequest.method(), httpRequest.uri(), string, httpResponse.statusCode(), string3, string4, string2));
        }
    }

    private void logFailure(HttpRequest httpRequest, Throwable throwable) {
        this.log.info(String.format("Request: %s %s: %s. Failed: %s", httpRequest.method(), httpRequest.uri(), httpRequest.bodyPublisher().map(Object::toString).orElse("NoBody"), throwable.getMessage()), throwable);
    }

    private static String generateAuthHeader(String string) {
        return "Bearer " + string;
    }

    static {
        try {
            FAUNA_ROOT = new URL("https://db.fauna.com");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOError(malformedURLException);
        }
    }

    public static class Builder {
        private URL faunaRoot;
        private String authToken;
        private MetricRegistry metricRegistry;
        private long lastSeenTxn;
        private HttpClient client;
        private JvmDriver jvmDriver;
        private String scalaVersion;
        private Optional<Duration> queryTimeout = Optional.empty();
        private Optional<String> userAgent = Optional.empty();
        private boolean checkNewDriverVersion = true;
        private Map<String, String> customHeaders;

        private Builder() {
        }

        public Builder withFaunaRoot(String string) throws MalformedURLException {
            this.faunaRoot = new URL(string);
            return this;
        }

        public Builder withFaunaRoot(URL uRL) {
            this.faunaRoot = uRL;
            return this;
        }

        public Builder withAuthToken(String string) {
            this.authToken = string;
            return this;
        }

        public Builder withMetrics(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public Builder withJvmDriver(JvmDriver jvmDriver) {
            this.jvmDriver = jvmDriver;
            return this;
        }

        public Builder withScalaVersion(String string) {
            this.scalaVersion = string;
            return this;
        }

        public Builder withCheckNewDriverVersion(boolean bl) {
            this.checkNewDriverVersion = bl;
            return this;
        }

        public Builder withLastSeenTxn(long l) {
            this.lastSeenTxn = l;
            return this;
        }

        public Builder withHttpClient(HttpClient httpClient) {
            this.client = httpClient;
            return this;
        }

        public Builder withQueryTimeout(Duration duration) {
            this.queryTimeout = Optional.ofNullable(duration);
            return this;
        }

        public Builder withUserAgent(String string) {
            this.userAgent = Optional.ofNullable(string);
            return this;
        }

        public Builder withCustomHeaders(Map<String, String> map) {
            this.customHeaders = map;
            return this;
        }

        public Connection build() {
            MetricRegistry metricRegistry = Objects.requireNonNullElseGet(this.metricRegistry, MetricRegistry::new);
            URL uRL = Objects.requireNonNullElseGet(this.faunaRoot, () -> FAUNA_ROOT);
            HttpClient httpClient = Objects.requireNonNullElseGet(this.client, () -> HttpClient.newBuilder().connectTimeout(DEFAULT_CONNECTION_TIMEOUT).build());
            String string = this.userAgent.orElse(Connection.DEFAULT_USER_AGENT);
            String string2 = new RuntimeEnvironmentHeader(this.jvmDriver, this.scalaVersion, this.checkNewDriverVersion).toString();
            return new Connection(uRL, this.authToken, httpClient, metricRegistry, string2, this.lastSeenTxn, this.queryTimeout, string, this.customHeaders);
        }
    }

    private static class RuntimeEnvironmentHeader {
        private String runtime;
        private String driverVersion = Connection.class.getPackage().getSpecificationVersion();
        private String os = System.getProperty("os.name");
        private String env = this.getRuntimeEnv();

        RuntimeEnvironmentHeader(JvmDriver jvmDriver, String string, boolean bl) {
            this.runtime = String.format("java-%s", System.getProperty("java.version"));
            if (jvmDriver == JvmDriver.SCALA) {
                this.runtime = String.format("%s,scala-%s", this.runtime, string);
            }
            if (bl && !DriverVersionChecker.isAlreadyChecked()) {
                DriverVersionChecker.checkLatestVersion();
            }
        }

        public String toString() {
            return String.format("driver=jvm-%s; runtime=%s; env=%s; os=%s", this.driverVersion, this.runtime, this.env, this.os).toLowerCase();
        }

        private String getRuntimeEnv() {
            if (System.getenv("NETLIFY_IMAGES_CDN_DOMAIN") != null) {
                return "Netlify";
            }
            if (System.getenv("VERCEL") != null) {
                return "Vercel";
            }
            if (System.getenv("PATH") != null && System.getenv("PATH").contains(".heroku")) {
                return "Heroku";
            }
            if (System.getenv("AWS_LAMBDA_FUNCTION_VERSION") != null) {
                return "AWS Lambda";
            }
            if (System.getenv("_") != null && System.getenv("_").contains("google")) {
                return "GCP Cloud Functions";
            }
            if (System.getenv("GOOGLE_CLOUD_PROJECT") != null) {
                return "GCP Compute Instances";
            }
            if (System.getenv("ORYX_ENV_TYPE") != null && System.getenv("WEBSITE_INSTANCE_ID") != null && System.getenv("ORYX_ENV_TYPE") == "AppService") {
                return "Azure Compute";
            }
            return "Unknown";
        }
    }

    public static enum JvmDriver {
        JAVA("Java"),
        SCALA("Scala");

        private String stringValue;

        private JvmDriver(String string2) {
            this.stringValue = string2;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

