/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.common.http;

import com.faunadb.common.Connection;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DriverVersionChecker {
    private static boolean alreadyChecked = false;
    private static final String urlString = "https://repo.maven.apache.org/maven2/com/faunadb/faunadb-common/maven-metadata.xml";
    private static boolean javaDriver;

    public static void setAlreadyChecked() {
        alreadyChecked = true;
    }

    public static boolean isAlreadyChecked() {
        return alreadyChecked;
    }

    public static void checkLatestVersion() {
        if (alreadyChecked) {
            return;
        }
        try {
            DriverVersionChecker.getVersion();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        DriverVersionChecker.setAlreadyChecked();
    }

    private static void getVersion() throws IOException, ParserConfigurationException, SAXException {
        String string;
        URL uRL = new URL(urlString);
        URLConnection uRLConnection = uRL.openConnection();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(uRLConnection.getInputStream());
        String string2 = document.getDocumentElement().getElementsByTagName("latest").item(0).getFirstChild().getNodeValue();
        if (!string2.equals(string = Connection.class.getPackage().getSpecificationVersion())) {
            System.out.println("\n");
            System.out.println("=".repeat(80));
            System.out.println("New fauna version available " + string2 + " -> " + string);
            System.out.println("Changelog: https://github.com/fauna/faunadb-jvm/blob/main/CHANGELOG.txt");
            System.out.println("=".repeat(80));
        }
    }
}

