/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.common.models.request;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestParameters {
    private static final int MAX_TAGS_PER_REQUEST = 25;
    private static final int KEY_CHAR_LIMIT = 40;
    private static final int VALUE_CHAR_LIMIT = 80;
    private static final Pattern ALLOWABLE_CHARACTER_REGEX = Pattern.compile("^\\w+$");
    private final Optional<Duration> timeout;
    private final Optional<String> traceId;
    private final Map<String, String> tags;

    public static RequestParameters fromOptionalTimeout(Optional<Duration> optional) {
        return new RequestParameters(optional, Optional.empty(), new HashMap<String, String>());
    }

    public RequestParameters() {
        this.timeout = Optional.empty();
        this.traceId = Optional.empty();
        this.tags = new HashMap<String, String>();
    }

    public RequestParameters(Optional<Duration> optional, Optional<String> optional2, Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("Tags cannot be null. Consider passing an empty set instead");
        }
        if (map.size() > 25) {
            throw new IllegalArgumentException(String.format("Maximum number of tags provided, current max is %s", 25));
        }
        this.timeout = optional;
        this.traceId = optional2;
        this.tags = new HashMap<String, String>(this.getValidatedTags(map));
    }

    public Optional<Duration> getTimeout() {
        return this.timeout;
    }

    public Optional<String> getTraceId() {
        return this.traceId;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    private Map<String, String> getValidatedTags(Map<String, String> map) {
        map.entrySet().stream().forEach(entry -> {
            this.validateKey((String)entry.getKey());
            this.validateValue((String)entry.getValue());
        });
        return map;
    }

    private void validateKey(String string) {
        if (string == null || string.isBlank()) {
            throw new IllegalArgumentException("Empty keys not allowed");
        }
        if (string.length() > 40) {
            throw new IllegalArgumentException(String.format("Key, %s, is longer than the allowable limit of %d characters", string, 40));
        }
        Matcher matcher = ALLOWABLE_CHARACTER_REGEX.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Provided key, %s, contains invalid characters", string));
        }
    }

    private void validateValue(String string) {
        if (string == null || string.isBlank()) {
            throw new IllegalArgumentException("Empty values not allowed");
        }
        if (string.length() > 80) {
            throw new IllegalArgumentException(String.format("Value, %s, is longer than the allowable limit of %d characters", string, 80));
        }
        Matcher matcher = ALLOWABLE_CHARACTER_REGEX.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Provided value, %s, contains invalid characters", string));
        }
    }
}

