/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.faunadb.client.HttpResponses;
import com.faunadb.client.errors.BadRequestException;
import com.faunadb.client.errors.FaunaException;
import com.faunadb.client.errors.InternalException;
import com.faunadb.client.errors.NotFoundException;
import com.faunadb.client.errors.PermissionDeniedException;
import com.faunadb.client.errors.UnauthorizedException;
import com.faunadb.client.errors.UnavailableException;
import com.faunadb.client.errors.UnknownException;
import com.faunadb.client.query.Expr;
import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Field;
import com.faunadb.client.types.Value;
import com.faunadb.common.Connection;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import faunadb.com.google.common.util.concurrent.Futures;
import faunadb.com.google.common.util.concurrent.ListenableFuture;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Response;

public class FaunaClient
implements AutoCloseable {
    private final ObjectMapper json = new ObjectMapper().registerModule(new GuavaModule());
    private final Connection connection;

    public static Builder builder() {
        return new Builder();
    }

    private FaunaClient(Connection connection) {
        this.connection = connection;
    }

    public FaunaClient newSessionClient(String string) {
        return new FaunaClient(this.connection.newSessionConnection(string));
    }

    @Override
    public void close() {
        this.connection.close();
    }

    public ListenableFuture<Value> query(Expr expr) {
        return this.performRequest((JsonNode)this.json.valueToTree(expr));
    }

    public ListenableFuture<ImmutableList<Value>> query(List<? extends Expr> list) {
        return Futures.transform(this.performRequest((JsonNode)this.json.valueToTree(list)), new Function<Value, ImmutableList<Value>>(){

            @Override
            public ImmutableList<Value> apply(Value value) {
                return value.collect(Field.as(Codec.VALUE));
            }
        });
    }

    private ListenableFuture<Value> performRequest(JsonNode jsonNode) {
        try {
            return this.handleNetworkExceptions(Futures.transform(this.connection.post("/", jsonNode), new Function<Response, Value>(){

                @Override
                public Value apply(Response response) {
                    try {
                        FaunaClient.this.handleQueryErrors(response);
                        JsonNode jsonNode = FaunaClient.this.parseResponseBody(response);
                        JsonNode jsonNode2 = jsonNode.get("resource");
                        return FaunaClient.this.json.treeToValue(jsonNode2, Value.class);
                    }
                    catch (IOException iOException) {
                        throw new AssertionError((Object)iOException);
                    }
                }
            }));
        }
        catch (IOException iOException) {
            return Futures.immediateFailedFuture(iOException);
        }
    }

    private void handleQueryErrors(Response response) throws FaunaException {
        int n = response.getStatusCode();
        if (n >= 300) {
            try {
                ArrayNode arrayNode = (ArrayNode)this.parseResponseBody(response).get("errors");
                ImmutableList.Builder builder = ImmutableList.builder();
                for (JsonNode jsonNode : arrayNode) {
                    builder.add(this.json.treeToValue(jsonNode, HttpResponses.QueryError.class));
                }
                HttpResponses.QueryErrorResponse queryErrorResponse = HttpResponses.QueryErrorResponse.create(n, (ImmutableList<HttpResponses.QueryError>)builder.build());
                switch (n) {
                    case 400: {
                        throw new BadRequestException(queryErrorResponse);
                    }
                    case 401: {
                        throw new UnauthorizedException(queryErrorResponse);
                    }
                    case 403: {
                        throw new PermissionDeniedException(queryErrorResponse);
                    }
                    case 404: {
                        throw new NotFoundException(queryErrorResponse);
                    }
                    case 500: {
                        throw new InternalException(queryErrorResponse);
                    }
                    case 503: {
                        throw new UnavailableException(queryErrorResponse);
                    }
                }
                throw new UnknownException(queryErrorResponse);
            }
            catch (IOException iOException) {
                switch (n) {
                    case 503: {
                        throw new UnavailableException("Service Unavailable: Unparseable response.");
                    }
                }
                throw new UnknownException("Unparseable service " + n + "response.");
            }
        }
    }

    private <V> ListenableFuture<V> handleNetworkExceptions(ListenableFuture<V> listenableFuture) {
        ListenableFuture<V> listenableFuture2 = Futures.catching(listenableFuture, ConnectException.class, new Function<ConnectException, V>(){

            @Override
            public V apply(ConnectException connectException) {
                throw new UnavailableException(connectException.getMessage());
            }
        });
        return Futures.catching(listenableFuture2, TimeoutException.class, new Function<TimeoutException, V>(){

            @Override
            public V apply(TimeoutException timeoutException) {
                throw new UnavailableException(timeoutException.getMessage());
            }
        });
    }

    private JsonNode parseResponseBody(Response response) throws IOException {
        return this.json.readTree(response.getResponseBody(CharsetUtil.UTF_8));
    }

    public static final class Builder {
        private String secret;
        private URL endpoint;
        private MetricRegistry registry;
        private AsyncHttpClient httpClient;

        private Builder() {
        }

        public Builder withSecret(String string) {
            this.secret = string;
            return this;
        }

        public Builder withEndpoint(String string) throws MalformedURLException {
            this.endpoint = new URL(string);
            return this;
        }

        public Builder withMetrics(MetricRegistry metricRegistry) {
            this.registry = metricRegistry;
            return this;
        }

        public Builder withHttpClient(AsyncHttpClient asyncHttpClient) {
            this.httpClient = asyncHttpClient;
            return this;
        }

        public FaunaClient build() {
            Connection.Builder builder = Connection.builder().withAuthToken(this.secret).withFaunaRoot(this.endpoint);
            if (this.registry != null) {
                builder.withMetrics(this.registry);
            }
            if (this.httpClient != null) {
                builder.withHttpClient(this.httpClient);
            }
            return new FaunaClient(builder.build());
        }
    }
}

