/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.ImmutableList;
import java.io.IOException;

public class HttpResponses {

    public static class QueryErrorResponse {
        private final int status;
        private final ImmutableList<QueryError> errors;

        public static QueryErrorResponse create(int n, ImmutableList<QueryError> immutableList) {
            return new QueryErrorResponse(n, immutableList);
        }

        QueryErrorResponse(int n, ImmutableList<QueryError> immutableList) {
            this.status = n;
            this.errors = immutableList;
        }

        public int status() {
            return this.status;
        }

        public ImmutableList<QueryError> errors() {
            return this.errors;
        }
    }

    @JsonDeserialize(using=Codec.QueryErrorDeserializer.class)
    public static class QueryError {
        private final ImmutableList<String> position;
        private final String code;
        private final String description;
        private final ImmutableList<ValidationFailure> failures;

        public QueryError(ImmutableList<String> immutableList, String string, String string2, ImmutableList<ValidationFailure> immutableList2) {
            this.position = immutableList;
            this.code = string;
            this.description = string2;
            this.failures = immutableList2;
        }

        public ImmutableList<String> position() {
            return this.position;
        }

        public String code() {
            return this.code;
        }

        public String description() {
            return this.description;
        }

        public ImmutableList<ValidationFailure> failures() {
            return this.failures;
        }
    }

    @JsonDeserialize(using=Codec.ValidationFailureDeserializer.class)
    public static class ValidationFailure {
        private final ImmutableList<String> field;
        private final String code;
        private final String description;

        public ValidationFailure(ImmutableList<String> immutableList, String string, String string2) {
            this.field = immutableList;
            this.code = string;
            this.description = string2;
        }

        public String code() {
            return this.code;
        }

        public String description() {
            return this.description;
        }

        public ImmutableList<String> field() {
            return this.field;
        }
    }

    static class Codec {
        Codec() {
        }

        static class QueryErrorDeserializer
        extends JsonDeserializer<QueryError> {
            QueryErrorDeserializer() {
            }

            @Override
            public QueryError deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
                JsonNode jsonNode = (JsonNode)objectMapper.readTree(jsonParser);
                TypeFactory typeFactory = deserializationContext.getTypeFactory();
                ImmutableList immutableList = jsonNode.has("position") ? (ImmutableList)objectMapper.convertValue((Object)jsonNode.get("position"), typeFactory.constructCollectionType(ImmutableList.class, String.class)) : ImmutableList.of();
                if (!jsonNode.has("code")) {
                    throw new JsonParseException("Cannot deserialize QueryError: no 'code' field.", jsonParser.getTokenLocation());
                }
                String string = jsonNode.get("code").asText();
                if (!jsonNode.has("description")) {
                    throw new JsonParseException("Cannot deserialize QueryError: no 'description' field.", jsonParser.getTokenLocation());
                }
                String string2 = jsonNode.get("description").asText();
                ImmutableList immutableList2 = jsonNode.has("failures") ? (ImmutableList)objectMapper.convertValue((Object)jsonNode.get("failures"), typeFactory.constructCollectionType(ImmutableList.class, ValidationFailure.class)) : ImmutableList.of();
                return new QueryError(immutableList, string, string2, immutableList2);
            }
        }

        static class ValidationFailureDeserializer
        extends JsonDeserializer<ValidationFailure> {
            ValidationFailureDeserializer() {
            }

            @Override
            public ValidationFailure deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                String string;
                ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
                TypeFactory typeFactory = deserializationContext.getTypeFactory();
                JsonNode jsonNode = (JsonNode)objectMapper.readTree(jsonParser);
                if (!jsonNode.has("field")) {
                    throw new JsonParseException("Cannot deserialize ValidationFailure: no 'field' field.", jsonParser.getTokenLocation());
                }
                ImmutableList immutableList = (ImmutableList)objectMapper.convertValue((Object)jsonNode.get("field"), typeFactory.constructCollectionType(ImmutableList.class, String.class));
                if (!jsonNode.has("code")) {
                    throw new JsonParseException("Cannot deserialize ValidationFailure: no 'code' field.", jsonParser.getTokenLocation());
                }
                String string2 = jsonNode.get("code").asText();
                if (jsonNode.has("description")) {
                    string = jsonNode.get("description").asText();
                } else if (jsonNode.has("reason")) {
                    string = jsonNode.get("reason").asText();
                } else {
                    throw new JsonParseException("Cannot deserialize ValidationFailure: no 'description' field.", jsonParser.getTokenLocation());
                }
                return new ValidationFailure(immutableList, string2, string);
            }
        }
    }
}

