/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.errors;

import com.faunadb.client.HttpResponses;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;

public class FaunaException
extends RuntimeException {
    private final Optional<HttpResponses.QueryErrorResponse> response;

    public FaunaException(HttpResponses.QueryErrorResponse queryErrorResponse) {
        super(FaunaException.constructErrorMessage(queryErrorResponse.errors()));
        this.response = Optional.of(queryErrorResponse);
    }

    public FaunaException(String string) {
        super(string);
        this.response = Optional.absent();
    }

    public ImmutableList<HttpResponses.QueryError> errors() {
        if (this.response.isPresent()) {
            return this.response.get().errors();
        }
        return ImmutableList.of();
    }

    public int status() {
        if (this.response.isPresent()) {
            return this.response.get().status();
        }
        return 0;
    }

    private static String constructErrorMessage(ImmutableList<HttpResponses.QueryError> immutableList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (HttpResponses.QueryError queryError : immutableList) {
            builder.add(queryError.code() + ": " + queryError.description());
        }
        return Joiner.on(", ").join(builder.build());
    }
}

