/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.query;

import com.faunadb.client.query.Expr;
import com.faunadb.client.query.Fn;
import com.faunadb.client.query.Pagination;
import com.faunadb.client.types.Value;
import com.faunadb.client.types.time.HighPrecisionTime;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

public final class Language {
    private Language() {
    }

    private static Expr varargs(List<? extends Expr> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        return Language.Arr(list);
    }

    public static Expr Ref(String string) {
        return new Value.RefV(string);
    }

    public static Expr Ref(Expr expr, Expr expr2) {
        return Fn.apply("ref", expr, "id", expr2);
    }

    public static Expr Ref(Expr expr, String string) {
        return Language.Ref(expr, Language.Value(string));
    }

    public static Expr Value(String string) {
        return new Value.StringV(string);
    }

    public static Expr Value(long l) {
        return new Value.LongV(l);
    }

    public static Expr Value(double d) {
        return new Value.DoubleV(d);
    }

    public static Expr Value(boolean bl) {
        return Value.BooleanV.valueOf(bl);
    }

    public static Expr Value(Instant instant) {
        return new Value.TimeV(HighPrecisionTime.fromInstant(instant));
    }

    public static Expr Value(HighPrecisionTime highPrecisionTime) {
        return new Value.TimeV(highPrecisionTime);
    }

    public static Expr Value(LocalDate localDate) {
        return new Value.DateV(localDate);
    }

    public static Expr Value(byte[] byArray) {
        return new Value.BytesV(byArray);
    }

    public static Expr Null() {
        return Value.NullV.NULL;
    }

    public static Expr Obj(Map<String, ? extends Expr> map) {
        return Fn.apply("object", Fn.apply(map));
    }

    public static Expr Obj() {
        return Language.Obj(ImmutableMap.of());
    }

    public static Expr Obj(String string, Expr expr) {
        return Language.Obj(ImmutableMap.of(string, expr));
    }

    public static Expr Obj(String string, Expr expr, String string2, Expr expr2) {
        return Language.Obj(ImmutableMap.of(string, expr, string2, expr2));
    }

    public static Expr Obj(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3) {
        return Language.Obj(ImmutableMap.of(string, expr, string2, expr2, string3, expr3));
    }

    public static Expr Obj(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4) {
        return Language.Obj(ImmutableMap.of(string, expr, string2, expr2, string3, expr3, string4, expr4));
    }

    public static Expr Obj(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4, String string5, Expr expr5) {
        return Language.Obj(ImmutableMap.of(string, expr, string2, expr2, string3, expr3, string4, expr4, string5, expr5));
    }

    public static Expr Arr(List<? extends Expr> list) {
        return Fn.apply(list);
    }

    public static Expr Arr(Expr ... exprArray) {
        return Language.Arr(ImmutableList.copyOf(exprArray));
    }

    public static Expr Call(Expr expr, List<? extends Expr> list) {
        return Fn.apply("call", expr, "arguments", Language.varargs(list));
    }

    public static Expr Call(Expr expr, Expr ... exprArray) {
        return Language.Call(expr, ImmutableList.copyOf(exprArray));
    }

    public static Expr Query(Expr expr) {
        return Fn.apply("query", expr);
    }

    public static Expr At(Expr expr, Expr expr2) {
        return Fn.apply("at", expr, "expr", expr2);
    }

    public static LetBinding Let(Map<String, ? extends Expr> map) {
        return new LetBinding(ImmutableMap.copyOf(map));
    }

    public static LetBinding Let(String string, Expr expr) {
        return Language.Let(ImmutableMap.of(string, expr));
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2) {
        return Language.Let(ImmutableMap.of(string, expr, string2, expr2));
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3) {
        return Language.Let(ImmutableMap.of(string, expr, string2, expr2, string3, expr3));
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4) {
        return Language.Let(ImmutableMap.of(string, expr, string2, expr2, string3, expr3, string4, expr4));
    }

    public static LetBinding Let(String string, Expr expr, String string2, Expr expr2, String string3, Expr expr3, String string4, Expr expr4, String string5, Expr expr5) {
        return Language.Let(ImmutableMap.of(string, expr, string2, expr2, string3, expr3, string4, expr4, string5, expr5));
    }

    public static Expr Var(String string) {
        return Fn.apply("var", Language.Value(string));
    }

    public static Expr If(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("if", expr, "then", expr2, "else", expr3);
    }

    public static Expr Do(List<? extends Expr> list) {
        return Fn.apply("do", Fn.apply(list));
    }

    public static Expr Do(Expr ... exprArray) {
        return Language.Do(ImmutableList.copyOf(exprArray));
    }

    public static Expr Lambda(Expr expr, Expr expr2) {
        return Fn.apply("lambda", expr, "expr", expr2);
    }

    public static Expr Map(Expr expr, Expr expr2) {
        return Fn.apply("map", expr2, "collection", expr);
    }

    public static Expr Foreach(Expr expr, Expr expr2) {
        return Fn.apply("foreach", expr2, "collection", expr);
    }

    public static Expr Filter(Expr expr, Expr expr2) {
        return Fn.apply("filter", expr2, "collection", expr);
    }

    public static Expr Take(Expr expr, Expr expr2) {
        return Fn.apply("take", expr, "collection", expr2);
    }

    public static Expr Drop(Expr expr, Expr expr2) {
        return Fn.apply("drop", expr, "collection", expr2);
    }

    public static Expr Prepend(Expr expr, Expr expr2) {
        return Fn.apply("prepend", expr, "collection", expr2);
    }

    public static Expr Append(Expr expr, Expr expr2) {
        return Fn.apply("append", expr, "collection", expr2);
    }

    public static Expr Get(Expr expr) {
        return Fn.apply("get", expr);
    }

    public static Expr Get(Expr expr, Expr expr2) {
        return Fn.apply("get", expr, "ts", expr2);
    }

    public static Expr KeyFromSecret(Expr expr) {
        return Fn.apply("key_from_secret", expr);
    }

    public static Pagination Paginate(Expr expr) {
        return new Pagination(expr);
    }

    public static Expr Exists(Expr expr) {
        return Fn.apply("exists", expr);
    }

    public static Expr Exists(Expr expr, Expr expr2) {
        return Fn.apply("exists", expr, "ts", expr2);
    }

    public static Expr Create(Expr expr, Expr expr2) {
        return Fn.apply("create", expr, "params", expr2);
    }

    public static Expr Update(Expr expr, Expr expr2) {
        return Fn.apply("update", expr, "params", expr2);
    }

    public static Expr Replace(Expr expr, Expr expr2) {
        return Fn.apply("replace", expr, "params", expr2);
    }

    public static Expr Delete(Expr expr) {
        return Fn.apply("delete", expr);
    }

    public static Expr Insert(Expr expr, Expr expr2, Expr expr3, Expr expr4) {
        return Fn.apply("insert", expr, "ts", expr2, "action", expr3, "params", expr4);
    }

    public static Expr Insert(Expr expr, Expr expr2, Action action, Expr expr3) {
        return Language.Insert(expr, expr2, action.value, expr3);
    }

    public static Expr Remove(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("remove", expr, "ts", expr2, "action", expr3);
    }

    public static Expr Remove(Expr expr, Expr expr2, Action action) {
        return Language.Remove(expr, expr2, action.value);
    }

    public static Expr CreateClass(Expr expr) {
        return Fn.apply("create_class", expr);
    }

    public static Expr CreateDatabase(Expr expr) {
        return Fn.apply("create_database", expr);
    }

    public static Expr CreateKey(Expr expr) {
        return Fn.apply("create_key", expr);
    }

    public static Expr CreateIndex(Expr expr) {
        return Fn.apply("create_index", expr);
    }

    public static Expr CreateFunction(Expr expr) {
        return Fn.apply("create_function", expr);
    }

    public static Expr Match(Expr expr) {
        return Fn.apply("match", expr);
    }

    public static Expr Match(Expr expr, Expr expr2) {
        return Fn.apply("match", expr, "terms", expr2);
    }

    public static Expr Union(List<? extends Expr> list) {
        return Fn.apply("union", Language.varargs(list));
    }

    public static Expr Union(Expr ... exprArray) {
        return Language.Union(ImmutableList.copyOf(exprArray));
    }

    public static Expr Intersection(List<? extends Expr> list) {
        return Fn.apply("intersection", Language.varargs(list));
    }

    public static Expr Intersection(Expr ... exprArray) {
        return Language.Intersection(ImmutableList.copyOf(exprArray));
    }

    public static Expr Difference(List<? extends Expr> list) {
        return Fn.apply("difference", Language.varargs(list));
    }

    public static Expr Difference(Expr ... exprArray) {
        return Language.Difference(ImmutableList.copyOf(exprArray));
    }

    public static Expr Distinct(Expr expr) {
        return Fn.apply("distinct", expr);
    }

    public static Expr Join(Expr expr, Expr expr2) {
        return Fn.apply("join", expr, "with", expr2);
    }

    public static Expr Login(Expr expr, Expr expr2) {
        return Fn.apply("login", expr, "params", expr2);
    }

    public static Expr Logout(Expr expr) {
        return Fn.apply("logout", expr);
    }

    public static Expr Identify(Expr expr, Expr expr2) {
        return Fn.apply("identify", expr, "password", expr2);
    }

    public static Expr Concat(Expr expr) {
        return Fn.apply("concat", expr);
    }

    public static Expr Concat(Expr expr, Expr expr2) {
        return Fn.apply("concat", expr, "separator", expr2);
    }

    public static Expr Casefold(Expr expr) {
        return Fn.apply("casefold", expr);
    }

    public static Expr Time(Expr expr) {
        return Fn.apply("time", expr);
    }

    public static Expr Epoch(Expr expr, TimeUnit timeUnit) {
        return Language.Epoch(expr, timeUnit.value);
    }

    public static Expr Epoch(Expr expr, Expr expr2) {
        return Fn.apply("epoch", expr, "unit", expr2);
    }

    public static Expr Date(Expr expr) {
        return Fn.apply("date", expr);
    }

    public static Expr NextId() {
        return Fn.apply("next_id", Value.NullV.NULL);
    }

    public static Expr Class(Expr expr) {
        return Fn.apply("class", expr);
    }

    public static Expr Database(Expr expr) {
        return Fn.apply("database", expr);
    }

    public static Expr Index(Expr expr) {
        return Fn.apply("index", expr);
    }

    public static Expr Equals(List<? extends Expr> list) {
        return Fn.apply("equals", Language.varargs(list));
    }

    public static Expr Equals(Expr ... exprArray) {
        return Language.Equals(ImmutableList.copyOf(exprArray));
    }

    public static Expr Contains(Expr expr, Expr expr2) {
        return Fn.apply("contains", expr, "in", expr2);
    }

    public static Expr Contains(Path path, Expr expr) {
        return Language.Contains(Language.Arr(path.segments), expr);
    }

    public static Path Path(String ... stringArray) {
        return new Path().at(stringArray);
    }

    public static Path Path(int ... nArray) {
        return new Path().at(nArray);
    }

    public static Expr Select(Expr expr, Expr expr2) {
        return Fn.apply("select", expr, "from", expr2);
    }

    public static Expr Select(Expr expr, Expr expr2, Expr expr3) {
        return Fn.apply("select", expr, "from", expr2, "default", expr3);
    }

    public static Expr Select(Path path, Expr expr) {
        return Language.Select(Language.Arr(path.segments), expr);
    }

    public static Expr Select(Path path, Expr expr, Expr expr2) {
        return Language.Select(Language.Arr(path.segments), expr, expr2);
    }

    public static Expr Add(List<? extends Expr> list) {
        return Fn.apply("add", Language.varargs(list));
    }

    public static Expr Add(Expr ... exprArray) {
        return Language.Add(ImmutableList.copyOf(exprArray));
    }

    public static Expr Multiply(List<? extends Expr> list) {
        return Fn.apply("multiply", Language.varargs(list));
    }

    public static Expr Multiply(Expr ... exprArray) {
        return Language.Multiply(ImmutableList.copyOf(exprArray));
    }

    public static Expr Subtract(List<? extends Expr> list) {
        return Fn.apply("subtract", Language.varargs(list));
    }

    public static Expr Subtract(Expr ... exprArray) {
        return Language.Subtract(ImmutableList.copyOf(exprArray));
    }

    public static Expr Divide(List<? extends Expr> list) {
        return Fn.apply("divide", Language.varargs(list));
    }

    public static Expr Divide(Expr ... exprArray) {
        return Language.Divide(ImmutableList.copyOf(exprArray));
    }

    public static Expr Modulo(List<? extends Expr> list) {
        return Fn.apply("modulo", Language.varargs(list));
    }

    public static Expr Modulo(Expr ... exprArray) {
        return Language.Modulo(ImmutableList.copyOf(exprArray));
    }

    public static Expr LT(List<? extends Expr> list) {
        return Fn.apply("lt", Language.varargs(list));
    }

    public static Expr LT(Expr ... exprArray) {
        return Language.LT(ImmutableList.copyOf(exprArray));
    }

    public static Expr LTE(List<? extends Expr> list) {
        return Fn.apply("lte", Language.varargs(list));
    }

    public static Expr LTE(Expr ... exprArray) {
        return Language.LTE(ImmutableList.copyOf(exprArray));
    }

    public static Expr GT(List<? extends Expr> list) {
        return Fn.apply("gt", Language.varargs(list));
    }

    public static Expr GT(Expr ... exprArray) {
        return Language.GT(ImmutableList.copyOf(exprArray));
    }

    public static Expr GTE(List<? extends Expr> list) {
        return Fn.apply("gte", Language.varargs(list));
    }

    public static Expr GTE(Expr ... exprArray) {
        return Language.GTE(ImmutableList.copyOf(exprArray));
    }

    public static Expr And(List<? extends Expr> list) {
        return Fn.apply("and", Language.varargs(list));
    }

    public static Expr And(Expr ... exprArray) {
        return Language.And(ImmutableList.copyOf(exprArray));
    }

    public static Expr Or(List<? extends Expr> list) {
        return Fn.apply("or", Language.varargs(list));
    }

    public static Expr Or(Expr ... exprArray) {
        return Language.Or(ImmutableList.copyOf(exprArray));
    }

    public static Expr Not(Expr expr) {
        return Fn.apply("not", expr);
    }

    public static final class Path {
        private final ImmutableList<Expr> segments;

        private Path() {
            this(ImmutableList.of());
        }

        private Path(ImmutableList<Expr> immutableList) {
            this.segments = immutableList;
        }

        public Path at(String ... stringArray) {
            ImmutableCollection.Builder builder = ImmutableList.builder().addAll(this.segments);
            for (String string : stringArray) {
                ((ImmutableList.Builder)builder).add(Language.Value(string));
            }
            return new Path((ImmutableList<Expr>)((ImmutableList.Builder)builder).build());
        }

        public Path at(int ... nArray) {
            ImmutableCollection.Builder builder = ImmutableList.builder().addAll(this.segments);
            for (int n : nArray) {
                ((ImmutableList.Builder)builder).add(Language.Value(n));
            }
            return new Path((ImmutableList<Expr>)((ImmutableList.Builder)builder).build());
        }
    }

    public static final class LetBinding {
        private final Expr bindings;

        private LetBinding(ImmutableMap<String, Expr> immutableMap) {
            this.bindings = Fn.apply(immutableMap);
        }

        public Expr in(Expr expr) {
            return Fn.apply("let", this.bindings, "in", expr);
        }
    }

    public static enum Action {
        CREATE("create"),
        DELETE("delete");

        private final Expr value;

        private Action(String string2) {
            this.value = Language.Value(string2);
        }
    }

    public static enum TimeUnit {
        SECOND("second"),
        MILLISECOND("millisecond"),
        MICROSECOND("microsecond"),
        NANOSECOND("nanosecond");

        private final Expr value;

        private TimeUnit(String string2) {
            this.value = Language.Value(string2);
        }
    }
}

