/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.query;

import com.fasterxml.jackson.annotation.JsonValue;
import com.faunadb.client.query.Expr;
import com.faunadb.client.types.Value;
import com.faunadb.client.util.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;

public final class Pagination
extends Expr {
    private final Expr resource;
    private Optional<Cursor> cursor = Optional.absent();
    private Optional<Expr> ts = Optional.absent();
    private Optional<Expr> size = Optional.absent();
    private Optional<Expr> sources = Optional.absent();
    private Optional<Expr> events = Optional.absent();

    Pagination(Expr expr) {
        this.resource = expr;
    }

    @Override
    @JsonValue
    protected ImmutableMap<String, Expr> toJson() {
        ImmutableMap.Builder<String, Expr> builder = ImmutableMap.builder();
        builder.put("paginate", this.resource);
        if (this.cursor.isPresent()) {
            builder.put(this.cursor.get().name, this.cursor.get().ref);
        }
        if (this.events.isPresent()) {
            builder.put("events", this.events.get());
        }
        if (this.sources.isPresent()) {
            builder.put("sources", this.sources.get());
        }
        if (this.ts.isPresent()) {
            builder.put("ts", this.ts.get());
        }
        if (this.size.isPresent()) {
            builder.put("size", this.size.get());
        }
        return builder.build();
    }

    public Pagination before(Expr expr) {
        this.cursor = Optional.of(new Before(expr));
        return this;
    }

    public Pagination after(Expr expr) {
        this.cursor = Optional.of(new After(expr));
        return this;
    }

    public Pagination ts(Expr expr) {
        this.ts = Optional.of(expr);
        return this;
    }

    public Pagination ts(Long l) {
        return this.ts(new Value.LongV(l));
    }

    public Pagination size(Expr expr) {
        this.size = Optional.of(expr);
        return this;
    }

    public Pagination size(Integer n) {
        return this.size(new Value.LongV(n.intValue()));
    }

    public Pagination sources(Expr expr) {
        this.sources = Optional.of(expr);
        return this;
    }

    public Pagination sources(boolean bl) {
        if (!bl) {
            return this;
        }
        return this.sources(Value.BooleanV.TRUE);
    }

    public Pagination events(Expr expr) {
        this.events = Optional.of(expr);
        return this;
    }

    public Pagination events(boolean bl) {
        if (!bl) {
            return this;
        }
        return this.events(Value.BooleanV.TRUE);
    }

    private static final class After
    extends Cursor {
        private After(Expr expr) {
            super("after", expr);
        }
    }

    private static final class Before
    extends Cursor {
        private Before(Expr expr) {
            super("before", expr);
        }
    }

    private static abstract class Cursor {
        private final String name;
        private final Expr ref;

        private Cursor(String string, Expr expr) {
            this.name = Objects.requireNonNull(string);
            this.ref = Objects.requireNonNull(expr);
        }
    }
}

