/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import com.google.common.base.Function;

final class Cast {
    Cast() {
    }

    static <V extends Value, O> Codec<O> mapTo(final Class<V> clazz, final Function<V, O> function) {
        return new Codec<O>(){

            @Override
            public Result<O> apply(Value value) {
                return Cast.cast(clazz, value).map(function);
            }
        };
    }

    private static <T> Result<T> cast(Class<T> clazz, Value value) {
        if (value.getClass() == clazz) {
            return Result.success(clazz.cast(value));
        }
        return Result.fail(String.format("Can not convert %s to %s", value.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    static <T extends Value.ScalarValue<R>, R> Function<T, R> scalarValue() {
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                return ((Value.ScalarValue)t).value;
            }
        };
    }
}

