/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Cast;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import com.faunadb.client.types.time.HighPrecisionTime;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

public interface Codec<T>
extends Function<Value, Result<T>> {
    public static final Codec<Value> VALUE = new Codec<Value>(){

        @Override
        public Result<Value> apply(Value value) {
            if (value == Value.NullV.NULL) {
                return Result.fail("Value is null");
            }
            return Result.success(value);
        }
    };
    public static final Codec<Value.RefV> REF = Cast.mapTo(Value.RefV.class, Functions.identity());
    public static final Codec<Value.SetRefV> SET_REF = Cast.mapTo(Value.SetRefV.class, Functions.identity());
    public static final Codec<Long> LONG = Cast.mapTo(Value.LongV.class, Cast.scalarValue());
    public static final Codec<Instant> TIME = Cast.mapTo(Value.TimeV.class, new Function<Value.TimeV, Instant>(){

        @Override
        public Instant apply(Value.TimeV timeV) {
            return timeV.truncated();
        }
    });
    public static final Codec<HighPrecisionTime> HP_TIME = Cast.mapTo(Value.TimeV.class, Cast.scalarValue());
    public static final Codec<String> STRING = Cast.mapTo(Value.StringV.class, Cast.scalarValue());
    public static final Codec<Double> DOUBLE = Cast.mapTo(Value.DoubleV.class, Cast.scalarValue());
    public static final Codec<Boolean> BOOLEAN = Cast.mapTo(Value.BooleanV.class, Cast.scalarValue());
    public static final Codec<LocalDate> DATE = Cast.mapTo(Value.DateV.class, Cast.scalarValue());
    public static final Codec<ImmutableList<Value>> ARRAY = Cast.mapTo(Value.ArrayV.class, new Function<Value.ArrayV, ImmutableList<Value>>(){

        @Override
        public ImmutableList<Value> apply(Value.ArrayV arrayV) {
            return arrayV.values;
        }
    });
    public static final Codec<ImmutableMap<String, Value>> OBJECT = Cast.mapTo(Value.ObjectV.class, new Function<Value.ObjectV, ImmutableMap<String, Value>>(){

        @Override
        public ImmutableMap<String, Value> apply(Value.ObjectV objectV) {
            return objectV.values;
        }
    });
    public static final Codec<byte[]> BYTES = Cast.mapTo(Value.BytesV.class, Cast.scalarValue());
}

