/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.faunadb.client.types.Value;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class Deserializer {
    Deserializer() {
    }

    private static Value toValueOrNullV(JsonNode jsonNode, ObjectMapper objectMapper) {
        Value value = objectMapper.convertValue((Object)jsonNode, Value.class);
        return value != null ? value : Value.NullV.NULL;
    }

    static class ObjectDeserializer
    extends TreeDeserializer<Value.ObjectV> {
        ObjectDeserializer() {
        }

        @Override
        Value.ObjectV deserializeTree(JsonNode jsonNode, ObjectMapper objectMapper, JsonLocation jsonLocation) throws JsonParseException {
            ImmutableMap.Builder<String, Value> builder = ImmutableMap.builder();
            Iterator<Map.Entry<String, JsonNode>> iterator = jsonNode.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                builder.put(entry.getKey(), Deserializer.toValueOrNullV(entry.getValue(), objectMapper));
            }
            return new Value.ObjectV(builder.build());
        }
    }

    static class ArrayDeserializer
    extends TreeDeserializer<Value.ArrayV> {
        ArrayDeserializer() {
        }

        @Override
        Value.ArrayV deserializeTree(JsonNode jsonNode, ObjectMapper objectMapper, JsonLocation jsonLocation) throws JsonParseException {
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterator<JsonNode> iterator = jsonNode.elements();
            while (iterator.hasNext()) {
                builder.add(Deserializer.toValueOrNullV(iterator.next(), objectMapper));
            }
            return new Value.ArrayV((List<? extends Value>)((Object)builder.build()));
        }
    }

    static class ValueDeserializer
    extends TreeDeserializer<Value> {
        ValueDeserializer() {
        }

        @Override
        Value deserializeTree(JsonNode jsonNode, ObjectMapper objectMapper, JsonLocation jsonLocation) throws JsonParseException {
            switch (jsonNode.getNodeType()) {
                case OBJECT: {
                    return this.deserializeSpecial(jsonNode, objectMapper);
                }
                case ARRAY: {
                    return objectMapper.convertValue((Object)jsonNode, Value.ArrayV.class);
                }
                case STRING: {
                    return objectMapper.convertValue((Object)jsonNode, Value.StringV.class);
                }
                case BOOLEAN: {
                    return objectMapper.convertValue((Object)jsonNode, Value.BooleanV.class);
                }
                case NUMBER: {
                    return jsonNode.isDouble() ? (Value)objectMapper.convertValue((Object)jsonNode, Value.DoubleV.class) : (Value)objectMapper.convertValue((Object)jsonNode, Value.LongV.class);
                }
                case NULL: {
                    return Value.NullV.NULL;
                }
            }
            throw new JsonParseException("Cannot deserialize as a Value", jsonLocation);
        }

        private Value deserializeSpecial(JsonNode jsonNode, ObjectMapper objectMapper) {
            String string;
            if (jsonNode.size() == 0) {
                return objectMapper.convertValue((Object)jsonNode, Value.ObjectV.class);
            }
            switch (string = jsonNode.fieldNames().next()) {
                case "@ref": {
                    return objectMapper.convertValue((Object)jsonNode, Value.RefV.class);
                }
                case "@set": {
                    return objectMapper.convertValue((Object)jsonNode, Value.SetRefV.class);
                }
                case "@ts": {
                    return objectMapper.convertValue((Object)jsonNode, Value.TimeV.class);
                }
                case "@date": {
                    return objectMapper.convertValue((Object)jsonNode, Value.DateV.class);
                }
                case "@bytes": {
                    return objectMapper.convertValue((Object)jsonNode, Value.BytesV.class);
                }
                case "@query": {
                    return objectMapper.convertValue((Object)jsonNode, Value.QueryV.class);
                }
                case "@obj": {
                    return objectMapper.convertValue((Object)jsonNode.get("@obj"), Value.ObjectV.class);
                }
            }
            return objectMapper.convertValue((Object)jsonNode, Value.ObjectV.class);
        }
    }

    private static abstract class TreeDeserializer<T>
    extends JsonDeserializer<T> {
        private TreeDeserializer() {
        }

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonLocation jsonLocation = jsonParser.getTokenLocation();
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            JsonNode jsonNode = (JsonNode)objectMapper.readTree(jsonParser);
            return this.deserializeTree(jsonNode, objectMapper, jsonLocation);
        }

        abstract T deserializeTree(JsonNode var1, ObjectMapper var2, JsonLocation var3) throws JsonParseException;
    }
}

