/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Path;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;

public final class Field<T> {
    private final Path path;
    private final Codec<T> codec;

    public static Field<Value> at(String ... stringArray) {
        return new Field<Value>(Path.from(stringArray), Codec.VALUE);
    }

    public static Field<Value> at(int ... nArray) {
        return new Field<Value>(Path.from(nArray), Codec.VALUE);
    }

    public static <T> Field<T> as(Codec<T> codec) {
        return new Field<T>(Path.empty(), codec);
    }

    static Field<Value> root() {
        return new Field<Value>(Path.empty(), Codec.VALUE);
    }

    private Field(Path path, Codec<T> codec) {
        this.path = path;
        this.codec = codec;
    }

    public <A> Field<A> at(Field<A> field) {
        return new Field<T>(this.path.subPath(field.path), field.codec);
    }

    public <A> Field<A> to(Codec<A> codec) {
        return new Field<A>(this.path, codec);
    }

    public <A> Field<ImmutableList<A>> collect(Field<A> field) {
        return new Field<ImmutableList<A>>(this.path, new CollectionCodec<A>(this.path, field));
    }

    Result<T> get(Value value) {
        return this.path.get(value).flatMap(this.codec);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Field && this.path.equals(((Field)object).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path.toString();
    }

    private final class CollectionCodec<A>
    implements Codec<ImmutableList<A>> {
        private final Path path;
        private final Field<A> field;
        private final Function<ImmutableList<Value>, Result<ImmutableList<A>>> toList = new Function<ImmutableList<Value>, Result<ImmutableList<A>>>(){

            @Override
            public Result<ImmutableList<A>> apply(ImmutableList<Value> immutableList) {
                ImmutableList.Builder builder = ImmutableList.builder();
                ImmutableList.Builder builder2 = ImmutableList.builder();
                for (int i = 0; i < immutableList.size(); ++i) {
                    Result result = CollectionCodec.this.field.get((Value)immutableList.get(i));
                    if (result.isSuccess()) {
                        builder.add(result.get());
                        continue;
                    }
                    Path path = CollectionCodec.this.path.subPath(Path.from(i)).subPath(CollectionCodec.this.field.path);
                    builder2.add(String.format("\"%s\" %s", path, result));
                }
                ImmutableCollection immutableCollection = builder2.build();
                if (!immutableCollection.isEmpty()) {
                    return Result.fail(String.format("Failed to collect values: %s", Joiner.on(", ").join(immutableCollection)));
                }
                return Result.success(builder.build());
            }
        };

        public CollectionCodec(Path path, Field<A> field2) {
            this.path = path;
            this.field = field2;
        }

        @Override
        public Result<ImmutableList<A>> apply(Value value) {
            return value.to(ARRAY).flatMap(this.toList);
        }
    }
}

