/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;

final class Path {
    private final List<Segment> segments;

    static Path empty() {
        return new Path(ImmutableList.of());
    }

    static Path from(String ... stringArray) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String string : stringArray) {
            builder.add(new ObjectKey(string));
        }
        return new Path((List<Segment>)((Object)builder.build()));
    }

    static Path from(int ... nArray) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray2[i];
            builder.add(new ArrayIndex(n2));
        }
        return new Path((List<Segment>)((Object)builder.build()));
    }

    private Path(List<Segment> list) {
        this.segments = list;
    }

    Path subPath(Path path) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.segments);
        builder.addAll(path.segments);
        return new Path((List<Segment>)((Object)builder.build()));
    }

    Result<Value> get(Value value) {
        Result<Value> result = Result.success(value);
        for (Segment segment : this.segments) {
            result = segment.get(result.get());
            if (!result.isFailure()) continue;
            return Result.fail(String.format("Can not find path \"%s\". %s", this, result));
        }
        return result;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Path && this.segments.equals(((Path)object).segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return Joiner.on("/").join(this.segments);
    }

    private static final class ArrayIndex
    extends Segment<Integer> {
        private ArrayIndex(Integer n) {
            super(n);
        }

        @Override
        public Result<Value> get(Value value) {
            return value.to(Codec.ARRAY).flatMap(new Function<ImmutableList<Value>, Result<Value>>(){

                @Override
                public Result<Value> apply(ImmutableList<Value> immutableList) {
                    try {
                        return Result.success(immutableList.get((Integer)segment));
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        return Result.fail(String.format("Array index \"%s\" not found", segment));
                    }
                }
            });
        }
    }

    private static final class ObjectKey
    extends Segment<String> {
        private ObjectKey(String string) {
            super(string);
        }

        @Override
        public Result<Value> get(Value value) {
            return value.to(Codec.OBJECT).flatMap(new Function<ImmutableMap<String, Value>, Result<Value>>(){

                @Override
                public Result<Value> apply(ImmutableMap<String, Value> immutableMap) {
                    Value value = immutableMap.get(segment);
                    if (value != null) {
                        return Result.success(value);
                    }
                    return Result.fail(String.format("Object key \"%s\" not found", segment));
                }
            });
        }
    }

    private static abstract class Segment<T> {
        final T segment;

        private Segment(T t) {
            this.segment = t;
        }

        abstract Result<Value> get(Value var1);

        public boolean equals(Object object) {
            return object != null && object instanceof Segment && this.segment.equals(((Segment)object).segment);
        }

        public int hashCode() {
            return this.segment.hashCode();
        }

        public String toString() {
            return this.segment.toString();
        }
    }
}

