/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.google.common.base.Function;
import com.google.common.base.Optional;

public abstract class Result<T> {
    public static <T> Result<T> success(T t) {
        return new Success(t);
    }

    public static <T> Result<T> fail(String string) {
        return new Failure(string);
    }

    private Result() {
    }

    public abstract boolean isSuccess();

    public abstract boolean isFailure();

    public abstract T get();

    public abstract Optional<T> getOptional();

    public abstract T getOrElse(T var1);

    public abstract <U> Result<U> map(Function<T, U> var1);

    public abstract <U> Result<U> flatMap(Function<T, Result<U>> var1);

    private static final class Failure<A>
    extends Result<A> {
        private final String error;

        private Failure(String string) {
            this.error = string;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public A get() {
            throw new IllegalStateException(this.error);
        }

        @Override
        public Optional<A> getOptional() {
            return Optional.absent();
        }

        @Override
        public A getOrElse(A a) {
            return a;
        }

        @Override
        public <U> Result<U> map(Function<A, U> function) {
            return new Failure<A>(this.error);
        }

        @Override
        public <U> Result<U> flatMap(Function<A, Result<U>> function) {
            return new Failure<A>(this.error);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Failure && this.error.equals(((Failure)object).error);
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        public String toString() {
            return this.error;
        }
    }

    private static final class Success<A>
    extends Result<A> {
        private final A value;

        private Success(A a) {
            this.value = a;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public A get() {
            return this.value;
        }

        @Override
        public Optional<A> getOptional() {
            return Optional.of(this.value);
        }

        @Override
        public A getOrElse(A a) {
            return this.value;
        }

        @Override
        public <U> Result<U> map(Function<A, U> function) {
            return new Success<U>(function.apply(this.value));
        }

        @Override
        public <U> Result<U> flatMap(Function<A, Result<U>> function) {
            return function.apply(this.value);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Success && this.value.equals(((Success)object).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

