/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.faunadb.client.query.Expr;
import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Deserializer;
import com.faunadb.client.types.Field;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.time.HighPrecisionTime;
import com.faunadb.client.util.Objects;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

@JsonDeserialize(using=Deserializer.ValueDeserializer.class)
public abstract class Value
extends Expr {
    private Value() {
    }

    public final <T> Result<T> to(Codec<T> codec) {
        return (Result)codec.apply(this);
    }

    public final <T> T get(Field<T> field) {
        return field.get(this).get();
    }

    public final <T> Optional<T> getOptional(Field<T> field) {
        return field.get(this).getOptional();
    }

    public final <T> ImmutableList<T> collect(Field<T> field) {
        return Field.root().collect(field).get(this).get();
    }

    public final Value at(String ... stringArray) {
        return Field.at(stringArray).get(this).getOrElse(NullV.NULL);
    }

    public final Value at(int ... nArray) {
        return Field.at(nArray).get(this).getOrElse(NullV.NULL);
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    public static final class QueryV
    extends Value {
        private Map<String, Object> lambda;

        private QueryV(@JsonProperty(value="@query") Map<String, Object> map) {
            this.lambda = map;
        }

        @Override
        @JsonProperty(value="@query")
        protected Map<String, Object> toJson() {
            return this.lambda;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof QueryV && this.lambda.equals(((QueryV)object).lambda);
        }

        public int hashCode() {
            return this.lambda.hashCode();
        }
    }

    public static final class BytesV
    extends ScalarValue<byte[]> {
        public BytesV(byte[] byArray) {
            super(byArray);
        }

        @JsonCreator
        public BytesV(@JsonProperty(value="@bytes") String string) {
            super(BaseEncoding.base64Url().decode(string));
        }

        @Override
        @JsonProperty(value="@bytes")
        protected Object toJson() {
            return BaseEncoding.base64Url().encode((byte[])this.value);
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object instanceof BytesV && Arrays.equals((byte[])this.value, (byte[])((BytesV)object).value);
        }

        @Override
        public int hashCode() {
            return ((byte[])this.value).hashCode();
        }

        @Override
        public String toString() {
            String string = FluentIterable.from(Bytes.asList((byte[])this.value)).transform(new Function<Byte, String>(){

                @Override
                public String apply(Byte by) {
                    return String.format("0x%02x", by);
                }
            }).join(Joiner.on(", "));
            return String.format("BytesV(%s)", string);
        }
    }

    public static final class RefV
    extends ScalarValue<String> {
        @JsonCreator
        public RefV(@JsonProperty(value="@ref") String string) {
            super(string);
        }

        @Override
        @JsonProperty(value="@ref")
        protected String toJson() {
            return (String)this.value;
        }

        public String strValue() {
            return (String)this.value;
        }
    }

    public static final class SetRefV
    extends ScalarValue<ImmutableMap<String, Value>> {
        public SetRefV(@JsonProperty(value="@set") ImmutableMap<String, Value> immutableMap) {
            super(immutableMap);
        }

        public ImmutableMap<String, Value> parameters() {
            return (ImmutableMap)this.value;
        }

        @Override
        @JsonProperty(value="@set")
        protected ImmutableMap<String, Value> toJson() {
            return (ImmutableMap)this.value;
        }
    }

    public static final class DateV
    extends ScalarValue<LocalDate> {
        public DateV(LocalDate localDate) {
            super(localDate);
        }

        @JsonCreator
        private DateV(@JsonProperty(value="@date") String string) {
            super(LocalDate.parse(string));
        }

        @Override
        @JsonProperty(value="@date")
        protected String toJson() {
            return ((LocalDate)this.value).toString();
        }
    }

    public static final class TimeV
    extends ScalarValue<HighPrecisionTime> {
        public TimeV(HighPrecisionTime highPrecisionTime) {
            super(highPrecisionTime);
        }

        @JsonCreator
        private TimeV(@JsonProperty(value="@ts") String string) {
            this(HighPrecisionTime.parse(string));
        }

        Instant truncated() {
            return ((HighPrecisionTime)this.value).toInstant();
        }

        @Override
        @JsonProperty(value="@ts")
        protected String toJson() {
            return ((HighPrecisionTime)this.value).toString();
        }
    }

    public static final class NullV
    extends Value {
        public static final NullV NULL = new NullV();

        private NullV() {
        }

        @Override
        @JsonValue
        protected NullNode toJson() {
            return NullNode.getInstance();
        }

        public boolean equals(Object object) {
            return object != null && object instanceof NullV;
        }

        public int hashCode() {
            return -1;
        }

        @Override
        public String toString() {
            return "NullV";
        }
    }

    public static final class StringV
    extends ScalarValue<String> {
        public StringV(String string) {
            super(string);
        }

        @Override
        @JsonValue
        protected String toJson() {
            return (String)this.value;
        }
    }

    public static final class LongV
    extends ScalarValue<Long> {
        public LongV(long l) {
            super(l);
        }

        @Override
        @JsonValue
        protected Long toJson() {
            return (Long)this.value;
        }
    }

    public static final class DoubleV
    extends ScalarValue<Double> {
        public DoubleV(double d) {
            super(d);
        }

        @Override
        @JsonValue
        protected Double toJson() {
            return (Double)this.value;
        }
    }

    public static final class BooleanV
    extends ScalarValue<Boolean> {
        public static final BooleanV TRUE = new BooleanV(true);
        public static final BooleanV FALSE = new BooleanV(false);

        public static BooleanV valueOf(boolean bl) {
            return bl ? TRUE : FALSE;
        }

        private BooleanV(Boolean bl) {
            super(bl);
        }

        @Override
        @JsonValue
        protected Boolean toJson() {
            return (Boolean)this.value;
        }
    }

    @JsonDeserialize(using=Deserializer.ArrayDeserializer.class)
    public static final class ArrayV
    extends Value {
        final ImmutableList<Value> values;

        public ArrayV(List<? extends Value> list) {
            Objects.requireNonNull(list);
            this.values = ImmutableList.copyOf(list);
        }

        @Override
        @JsonValue
        protected ImmutableList<Value> toJson() {
            return this.values;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof ArrayV && this.values.equals(((ArrayV)object).values);
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        @Override
        public String toString() {
            return String.format("Arr(%s)", this.values);
        }
    }

    @JsonDeserialize(using=Deserializer.ObjectDeserializer.class)
    public static final class ObjectV
    extends Value {
        final ImmutableMap<String, Value> values;

        public ObjectV(Map<String, ? extends Value> map) {
            Objects.requireNonNull(map);
            this.values = ImmutableMap.copyOf(map);
        }

        @Override
        @JsonValue
        protected ImmutableMap<String, ImmutableMap<String, Value>> toJson() {
            return ImmutableMap.of("object", this.values);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof ObjectV && this.values.equals(((ObjectV)object).values);
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        @Override
        public String toString() {
            return String.format("ObjectV(%s)", this.values);
        }
    }

    @JsonDeserialize(using=JsonDeserializer.None.class)
    static abstract class ScalarValue<T>
    extends Value {
        @JsonIgnore
        final T value;

        ScalarValue(T t) {
            this.value = Objects.requireNonNull(t);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof ScalarValue && this.value.equals(((ScalarValue)object).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return String.format("%s(%s)", this.getClass().getSimpleName(), this.value);
        }
    }
}

