/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types.time;

import com.faunadb.client.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Instant;
import org.joda.time.format.ISODateTimeFormat;

public class HighPrecisionTime
implements Comparable<HighPrecisionTime> {
    private static final int NANOS_IN_A_MICRO = 1000;
    private static final int NANOS_IN_A_MILLI = 1000000;
    private static final int NANOS_IN_A_SECOND = 1000000000;
    private static final int MILLIS_IN_A_SECOND = 1000;
    private static final Pattern PRECISION_GROUPS = Pattern.compile("\\.\\d{3}(\\d{3})(\\d{3})?Z");
    private final long secondsSinceEpoch;
    private final int nanoSecondsOffset;

    public static HighPrecisionTime parse(String string) {
        Instant instant = ISODateTimeFormat.dateTimeParser().parseDateTime(string).toInstant();
        Matcher matcher = PRECISION_GROUPS.matcher(string);
        if (matcher.find()) {
            return HighPrecisionTime.create(instant, HighPrecisionTime.toLong(matcher.group(1)), HighPrecisionTime.toLong(matcher.group(2)));
        }
        return HighPrecisionTime.create(instant, 0L, 0L);
    }

    private static long toLong(String string) {
        return string != null ? Long.valueOf(string) : 0L;
    }

    public static HighPrecisionTime fromInstant(Instant instant) {
        return HighPrecisionTime.create(instant, 0L, 0L);
    }

    public static HighPrecisionTime fromInstantWithNanos(Instant instant, long l) {
        return HighPrecisionTime.create(instant, 0L, l);
    }

    public static HighPrecisionTime fromInstantWithMicros(Instant instant, long l) {
        return HighPrecisionTime.create(instant, l, 0L);
    }

    private static HighPrecisionTime create(Instant instant, long l, long l2) {
        Objects.requireNonNull(instant);
        long l3 = instant.getMillis() % 1000L * 1000000L + l * 1000L + l2;
        return new HighPrecisionTime(instant.getMillis() / 1000L, l3);
    }

    public HighPrecisionTime(long l, long l2) {
        this.secondsSinceEpoch = l + l2 / 1000000000L;
        this.nanoSecondsOffset = (int)(l2 % 1000000000L);
    }

    public Instant toInstant() {
        return new Instant(this.getMillisecondsFromEpoch());
    }

    public long getMillisecondsFromEpoch() {
        return this.secondsSinceEpoch * 1000L + (long)(this.nanoSecondsOffset / 1000000);
    }

    public long getNanosecondsOffset() {
        return this.nanoSecondsOffset;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HighPrecisionTime)) {
            return false;
        }
        HighPrecisionTime highPrecisionTime = (HighPrecisionTime)object;
        return this.secondsSinceEpoch == highPrecisionTime.secondsSinceEpoch && this.nanoSecondsOffset == highPrecisionTime.nanoSecondsOffset;
    }

    public int hashCode() {
        return Objects.hash(this.secondsSinceEpoch, this.nanoSecondsOffset);
    }

    @Override
    public int compareTo(HighPrecisionTime highPrecisionTime) {
        int n = Objects.compare(this.secondsSinceEpoch, highPrecisionTime.secondsSinceEpoch);
        if (n != 0) {
            return n;
        }
        return Objects.compare(this.nanoSecondsOffset, highPrecisionTime.nanoSecondsOffset);
    }

    public String toString() {
        return String.format("%s.%09dZ", this.toInstant().toString(ISODateTimeFormat.dateHourMinuteSecond()), this.nanoSecondsOffset);
    }
}

