/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.common;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.faunadb.common.RefAwareHttpClient;
import com.google.common.base.Optional;
import faunadb.com.google.common.util.concurrent.ListenableFuture;
import faunadb.com.google.common.util.concurrent.SettableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.CharsetUtil;
import java.io.IOError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Connection
implements AutoCloseable {
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 10000;
    private static final int DEFAULT_REQUEST_TIMEOUT_MS = 60000;
    private static final int DEFAULT_IDLE_TIMEOUT_MS = 4750;
    private static final int DEFAULT_MAX_RETRIES = 0;
    private static final URL FAUNA_ROOT;
    private static final String X_FAUNADB_HOST = "X-FaunaDB-Host";
    private static final String X_FAUNADB_BUILD = "X-FaunaDB-Build";
    private final URL faunaRoot;
    private final String authHeader;
    private final RefAwareHttpClient client;
    private final MetricRegistry registry;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper json = new ObjectMapper();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicLong txnTime = new AtomicLong(0L);

    public static Builder builder() {
        return new Builder();
    }

    private Connection(URL uRL, String string, RefAwareHttpClient refAwareHttpClient, MetricRegistry metricRegistry) {
        this.faunaRoot = uRL;
        this.authHeader = Connection.generateAuthHeader(string);
        this.client = refAwareHttpClient;
        this.registry = metricRegistry;
    }

    public Connection newSessionConnection(String string) {
        if (this.client.retain()) {
            return new Connection(this.faunaRoot, string, this.client, this.registry);
        }
        throw new IllegalStateException("Can not create a session connection from a closed http connection");
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.client.close();
        }
    }

    public ListenableFuture<Response> get(String string) throws IOException {
        Request request = ((RequestBuilder)new RequestBuilder("GET").setUrl(this.mkUrl(string))).build();
        return this.performRequest(request);
    }

    public ListenableFuture<Response> get(String string, Map<String, List<String>> map) throws IOException {
        Request request = ((RequestBuilder)((RequestBuilder)new RequestBuilder("GET").setUrl(this.mkUrl(string))).setQueryParams(map)).build();
        return this.performRequest(request);
    }

    public ListenableFuture<Response> post(String string, JsonNode jsonNode) throws IOException {
        Request request = ((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder("POST").setUrl(this.mkUrl(string))).setBody(this.json.writeValueAsString(jsonNode))).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "application/json; charset=utf-8")).build();
        return this.performRequest(request);
    }

    public ListenableFuture<Response> put(String string, JsonNode jsonNode) throws IOException {
        Request request = ((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder("PUT").setUrl(this.mkUrl(string))).setBody(this.json.writeValueAsString(jsonNode))).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "application/json; charset=utf-8")).build();
        return this.performRequest(request);
    }

    public ListenableFuture<Response> patch(String string, JsonNode jsonNode) throws IOException {
        Request request = ((RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder("PATCH").setUrl(this.mkUrl(string))).setBody(this.json.writeValueAsString(jsonNode))).setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, "application/json; charset=utf-8")).build();
        return this.performRequest(request);
    }

    private ListenableFuture<Response> performRequest(final Request request) {
        final Timer.Context context = this.registry.timer("fauna-request").time();
        final SettableFuture<Response> settableFuture = SettableFuture.create();
        BoundRequestBuilder boundRequestBuilder = (BoundRequestBuilder)this.client.prepareRequest(request).addHeader((CharSequence)"Authorization", this.authHeader);
        long l = this.txnTime.get();
        if (l > 0L) {
            boundRequestBuilder = (BoundRequestBuilder)boundRequestBuilder.setHeader((CharSequence)"X-Last-Seen-Txn", Long.toString(l));
        }
        boundRequestBuilder.execute(new AsyncCompletionHandler<Response>(){

            @Override
            public void onThrowable(Throwable throwable) {
                context.stop();
                settableFuture.setException(throwable);
                Connection.this.logFailure(request, throwable);
            }

            @Override
            public Response onCompleted(Response response) throws Exception {
                context.stop();
                settableFuture.set(response);
                String string = response.getHeader("X-Txn-Time");
                if (string != null) {
                    boolean bl;
                    long l;
                    long l2 = Long.valueOf(string);
                    while ((l = Connection.this.txnTime.get()) < l2 && !(bl = Connection.this.txnTime.compareAndSet(l, l2))) {
                    }
                }
                Connection.this.logSuccess(request, response);
                return response;
            }
        });
        return settableFuture;
    }

    private String mkUrl(String string) throws MalformedURLException {
        return new URL(this.faunaRoot, string).toString();
    }

    private void logSuccess(Request request, Response response) {
        if (this.log.isDebugEnabled()) {
            String string = Optional.fromNullable(request.getStringData()).or("");
            String string2 = Optional.fromNullable(response.getHeader(X_FAUNADB_HOST)).or("Unknown");
            String string3 = Optional.fromNullable(response.getHeader(X_FAUNADB_BUILD)).or("Unknown");
            String string4 = Optional.fromNullable(this.getResponseBody(response)).or("");
            this.log.debug(String.format("Request: %s %s: %s. Response: Status=%d, Fauna Host: %s, Fauna Build: %s: %s", request.getMethod(), request.getUrl(), string, response.getStatusCode(), string2, string3, string4));
        }
    }

    private String getResponseBody(Response response) {
        return response.getResponseBody();
    }

    private void logFailure(Request request, Throwable throwable) {
        String string = Optional.fromNullable(request.getStringData()).or("");
        this.log.info(String.format("Request: %s %s: %s. Failed: %s", request.getMethod(), request.getUrl(), string, throwable.getMessage()), throwable);
    }

    private static String generateAuthHeader(String string) {
        String string2 = string + ":";
        ByteBuf byteBuf = Unpooled.wrappedBuffer(string2.getBytes(CharsetUtil.US_ASCII));
        ByteBuf byteBuf2 = Base64.encode(byteBuf, false);
        String string3 = "Basic " + byteBuf2.toString(CharsetUtil.US_ASCII);
        byteBuf2.release();
        return string3;
    }

    static {
        try {
            FAUNA_ROOT = new URL("https://db.fauna.com");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOError(malformedURLException);
        }
    }

    public static class Builder {
        private URL faunaRoot;
        private String authToken;
        private AsyncHttpClient client;
        private MetricRegistry metricRegistry;

        private Builder() {
        }

        public Builder withFaunaRoot(String string) throws MalformedURLException {
            this.faunaRoot = new URL(string);
            return this;
        }

        public Builder withFaunaRoot(URL uRL) {
            this.faunaRoot = uRL;
            return this;
        }

        public Builder withAuthToken(String string) {
            this.authToken = string;
            return this;
        }

        public Builder withHttpClient(AsyncHttpClient asyncHttpClient) {
            this.client = asyncHttpClient;
            return this;
        }

        public Builder withMetrics(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        public Connection build() {
            MetricRegistry metricRegistry = this.metricRegistry == null ? new MetricRegistry() : this.metricRegistry;
            AsyncHttpClient asyncHttpClient = this.client == null ? new DefaultAsyncHttpClient(new DefaultAsyncHttpClientConfig.Builder().setConnectTimeout(10000).setRequestTimeout(60000).setPooledConnectionIdleTimeout(4750).setMaxRequestRetry(0).build()) : this.client;
            URL uRL = this.faunaRoot == null ? FAUNA_ROOT : this.faunaRoot;
            return new Connection(uRL, this.authToken, new RefAwareHttpClient(asyncHttpClient), metricRegistry);
        }
    }
}

