/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.common;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Request;

final class RefAwareHttpClient
implements AutoCloseable {
    private static final int INITIAL_REF_COUNT = 1;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final AsyncHttpClient delegate;

    RefAwareHttpClient(AsyncHttpClient asyncHttpClient) {
        this.delegate = asyncHttpClient;
    }

    boolean retain() {
        return this.refCount.incrementAndGet() > 1 && !this.delegate.isClosed();
    }

    @Override
    public void close() {
        if (this.refCount.decrementAndGet() < 1 && !this.delegate.isClosed()) {
            try {
                this.delegate.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    BoundRequestBuilder prepareRequest(Request request) {
        return this.delegate.prepareRequest(request);
    }
}

