/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.spnego;

import java.io.IOException;
import java.util.Base64;
import org.asynchttpclient.spnego.SpnegoEngineException;
import org.asynchttpclient.spnego.SpnegoTokenGenerator;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpnegoEngine {
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private static SpnegoEngine instance;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SpnegoTokenGenerator spnegoGenerator;

    public SpnegoEngine(SpnegoTokenGenerator spnegoGenerator) {
        this.spnegoGenerator = spnegoGenerator;
    }

    public SpnegoEngine() {
        this(null);
    }

    public static SpnegoEngine instance() {
        if (instance == null) {
            instance = new SpnegoEngine();
        }
        return instance;
    }

    public String generateToken(String server) throws SpnegoEngineException {
        GSSContext gssContext = null;
        byte[] token = null;
        try {
            GSSName serverName;
            GSSManager manager;
            this.log.debug("init {}", (Object)server);
            Oid negotiationOid = new Oid(SPNEGO_OID);
            boolean tryKerberos = false;
            try {
                manager = GSSManager.getInstance();
                serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                gssContext = manager.createContext(serverName.canonicalize(negotiationOid), negotiationOid, null, 0);
                gssContext.requestMutualAuth(true);
                gssContext.requestCredDeleg(true);
            }
            catch (GSSException ex) {
                this.log.error("generateToken", ex);
                if (ex.getMajor() == 2) {
                    this.log.debug("GSSException BAD_MECH, retry with Kerberos MECH");
                    tryKerberos = true;
                }
                throw ex;
            }
            if (tryKerberos) {
                this.log.debug("Using Kerberos MECH {}", (Object)KERBEROS_OID);
                negotiationOid = new Oid(KERBEROS_OID);
                manager = GSSManager.getInstance();
                serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                gssContext = manager.createContext(serverName.canonicalize(negotiationOid), negotiationOid, null, 0);
                gssContext.requestMutualAuth(true);
                gssContext.requestCredDeleg(true);
            }
            if (token == null) {
                token = new byte[]{};
            }
            if ((token = gssContext.initSecContext(token, 0, token.length)) == null) {
                throw new SpnegoEngineException("GSS security context initialization failed");
            }
            if (this.spnegoGenerator != null && negotiationOid.toString().equals(KERBEROS_OID)) {
                token = this.spnegoGenerator.generateSpnegoDERObject(token);
            }
            gssContext.dispose();
            String tokenstr = Base64.getEncoder().encodeToString(token);
            this.log.debug("Sending response '{}' back to the server", (Object)tokenstr);
            return tokenstr;
        }
        catch (GSSException gsse) {
            this.log.error("generateToken", gsse);
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new SpnegoEngineException(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new SpnegoEngineException(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                throw new SpnegoEngineException(gsse.getMessage(), gsse);
            }
            throw new SpnegoEngineException(gsse.getMessage());
        }
        catch (IOException ex) {
            throw new SpnegoEngineException(ex.getMessage());
        }
    }
}

