/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.query;

import com.fasterxml.jackson.annotation.JsonValue;
import com.faunadb.client.query.Expr;
import com.faunadb.client.types.Value;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class Pagination
extends Expr {
    private final Expr resource;
    private Optional<Cursor> cursor = Optional.empty();
    private Optional<Expr> ts = Optional.empty();
    private Optional<Expr> size = Optional.empty();
    private Optional<Expr> sources = Optional.empty();
    private Optional<Expr> events = Optional.empty();

    Pagination(Expr expr) {
        this.resource = expr;
    }

    @Override
    @JsonValue
    protected Map<String, Expr> toJson() {
        LinkedHashMap<String, Expr> linkedHashMap = new LinkedHashMap<String, Expr>();
        linkedHashMap.put("paginate", this.resource);
        this.cursor.ifPresent(cursor -> linkedHashMap.put(cursor.name, cursor.ref));
        Pagination.putIfPresent(this.events, linkedHashMap, "events");
        Pagination.putIfPresent(this.sources, linkedHashMap, "sources");
        Pagination.putIfPresent(this.ts, linkedHashMap, "ts");
        Pagination.putIfPresent(this.size, linkedHashMap, "size");
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static void putIfPresent(Optional<Expr> optional, Map<String, Expr> map, String string) {
        optional.ifPresent(expr -> map.put(string, (Expr)expr));
    }

    public Pagination cursor(Expr expr) {
        this.cursor = Optional.of(new RawCursor(expr));
        return this;
    }

    public Pagination before(Expr expr) {
        this.cursor = Optional.of(new Before(expr));
        return this;
    }

    public Pagination after(Expr expr) {
        this.cursor = Optional.of(new After(expr));
        return this;
    }

    public Pagination ts(Expr expr) {
        this.ts = Optional.of(expr);
        return this;
    }

    public Pagination ts(Long l) {
        return this.ts(new Value.LongV(l));
    }

    public Pagination size(Expr expr) {
        this.size = Optional.of(expr);
        return this;
    }

    public Pagination size(Integer n) {
        return this.size(new Value.LongV(n.intValue()));
    }

    public Pagination sources(Expr expr) {
        this.sources = Optional.of(expr);
        return this;
    }

    public Pagination sources(boolean bl) {
        if (!bl) {
            return this;
        }
        return this.sources(Value.BooleanV.TRUE);
    }

    public Pagination events(Expr expr) {
        this.events = Optional.of(expr);
        return this;
    }

    public Pagination events(boolean bl) {
        if (!bl) {
            return this;
        }
        return this.events(Value.BooleanV.TRUE);
    }

    private static final class RawCursor
    extends Cursor {
        private RawCursor(Expr expr) {
            super("cursor", expr);
        }
    }

    private static final class After
    extends Cursor {
        private After(Expr expr) {
            super("after", expr);
        }
    }

    private static final class Before
    extends Cursor {
        private Before(Expr expr) {
            super("before", expr);
        }
    }

    private static abstract class Cursor {
        private final String name;
        private final Expr ref;

        private Cursor(String string, Expr expr) {
            this.name = Objects.requireNonNull(string);
            this.ref = Objects.requireNonNull(expr);
        }
    }
}

