/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.errors.FaunaException;
import com.faunadb.client.types.Decoder;
import com.faunadb.client.types.FaunaConstructor;
import com.faunadb.client.types.FaunaField;
import com.faunadb.client.types.Properties;
import com.faunadb.client.types.Types;
import com.faunadb.client.types.Value;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;

final class Constructors {
    private static Object[] EMPTY_ARGUMENTS = new Object[0];

    private Constructors() {
    }

    static Function<Value, Object> createDecoder(Class<?> clazz) {
        Function<Value, Object> function = Constructors.getStaticFactoryMethodDecoder(clazz);
        if (function == null) {
            function = Constructors.getAnnotatedConstructorDecoder(clazz);
        }
        if (function == null) {
            function = Constructors.getDefaultConstructorDecoder(clazz);
        }
        if (function != null) {
            return function;
        }
        throw new FaunaException(String.format("No suitable constructor or factory method found for type %s. Ensure that a factory method or constructor is annotated with @%s", clazz.getName(), FaunaConstructor.class.getSimpleName()));
    }

    private static Function<Value, Object> getStaticFactoryMethodDecoder(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(FaunaConstructor.class) || (method.getModifiers() & 9) == 0) continue;
            if (method.getParameterTypes().length == 0) {
                return new NoArgsStaticFactoryMethodDecoder(method);
            }
            return new StaticFactoryMethodDecoder(method);
        }
        return null;
    }

    private static Function<Value, Object> getAnnotatedConstructorDecoder(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(FaunaConstructor.class)) continue;
            if (constructor.getParameterTypes().length == 0) {
                return new DefaultConstructorDecoder(constructor);
            }
            return new ConstructorDecoder(constructor);
        }
        return null;
    }

    private static Function<Value, Object> getDefaultConstructorDecoder(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return new DefaultConstructorDecoder(constructor);
        }
        return null;
    }

    private static class NoArgsStaticFactoryMethodDecoder
    extends StaticFactoryMethodDecoder {
        private NoArgsStaticFactoryMethodDecoder(Method method) {
            super(method);
        }

        @Override
        protected Object[] buildArguments(Value.ObjectV objectV) {
            return EMPTY_ARGUMENTS;
        }
    }

    private static class DefaultConstructorDecoder
    extends ConstructorDecoder {
        private DefaultConstructorDecoder(Constructor<?> constructor) {
            super(constructor);
        }

        @Override
        protected Object[] buildArguments(Value.ObjectV objectV) {
            return EMPTY_ARGUMENTS;
        }
    }

    private static class StaticFactoryMethodDecoder
    extends AbstractConstructorDecoder {
        private final Method method;

        private StaticFactoryMethodDecoder(Method method) {
            super(method);
            this.method = method;
            this.method.setAccessible(true);
        }

        @Override
        protected Object newInstance(Object[] objectArray) {
            try {
                return this.method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw new FaunaException(String.format("Error while invoking static method %s", this.method), exception);
            }
        }
    }

    private static class ConstructorDecoder
    extends AbstractConstructorDecoder {
        private final Constructor<?> constructor;

        private ConstructorDecoder(Constructor<?> constructor) {
            super(constructor);
            this.constructor = constructor;
            this.constructor.setAccessible(true);
        }

        @Override
        protected Object newInstance(Object[] objectArray) {
            try {
                return this.constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new FaunaException(String.format("Error while invoking constructor %s", this.constructor), exception);
            }
        }
    }

    private static abstract class AbstractConstructorDecoder
    implements Function<Value, Object> {
        private final Class<?> rawClass;
        private final String[] parameterNames;
        private final Types.SimpleType[] parameterTypes;
        private final Properties.Property[] writeProperties;

        AbstractConstructorDecoder(Constructor<?> constructor) {
            this.rawClass = constructor.getDeclaringClass();
            this.parameterNames = this.getParameterNames(constructor.getParameterAnnotations());
            this.parameterTypes = this.getParameterTypes(constructor.getGenericParameterTypes());
            this.writeProperties = AbstractConstructorDecoder.filterProperties(Properties.getWriteProperties(constructor.getDeclaringClass()), this.parameterNames);
        }

        AbstractConstructorDecoder(Method method) {
            this.rawClass = method.getDeclaringClass();
            this.parameterNames = this.getParameterNames(method.getParameterAnnotations());
            this.parameterTypes = this.getParameterTypes(method.getGenericParameterTypes());
            this.writeProperties = AbstractConstructorDecoder.filterProperties(Properties.getWriteProperties(method.getDeclaringClass()), this.parameterNames);
        }

        private Types.SimpleType[] getParameterTypes(Type[] typeArray) {
            Types.SimpleType[] simpleTypeArray = new Types.SimpleType[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                simpleTypeArray[i] = Types.of(typeArray[i]);
            }
            return simpleTypeArray;
        }

        private static Properties.Property[] filterProperties(Properties.Property[] propertyArray, String[] stringArray) {
            if (stringArray.length == 0) {
                return propertyArray;
            }
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
            return (Properties.Property[])Arrays.stream(propertyArray).filter(property -> !hashSet.contains(property.getName())).toArray(Properties.Property[]::new);
        }

        private String[] getParameterNames(Annotation[][] annotationArray) {
            String[] stringArray = new String[annotationArray.length];
            for (int i = 0; i < annotationArray.length; ++i) {
                Annotation[] annotationArray2;
                for (Annotation annotation : annotationArray2 = annotationArray[i]) {
                    if (annotation.annotationType() != FaunaField.class) continue;
                    stringArray[i] = ((FaunaField)annotation).value();
                    break;
                }
                if (stringArray[i] != null) continue;
                throw new FaunaException(String.format("All constructor or factory method arguments must be annotated with @%s", FaunaField.class.getSimpleName()));
            }
            return stringArray;
        }

        @Override
        public Object apply(Value value) {
            try {
                Value.ObjectV objectV = (Value.ObjectV)value;
                Object object = this.newInstance(this.buildArguments(objectV));
                for (Properties.Property property : this.writeProperties) {
                    Object object2 = Decoder.decodeImpl(objectV.values.get(property.getName()), property.getType());
                    property.set(object, object2);
                }
                return object;
            }
            catch (Exception exception) {
                throw new FaunaException(String.format("Could not instantiate object of class %s", this.rawClass.getName()), exception);
            }
        }

        protected Object[] buildArguments(Value.ObjectV objectV) {
            Object[] objectArray = new Object[this.parameterTypes.length];
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                objectArray[i] = Decoder.decodeImpl(objectV.values.get(this.parameterNames[i]), this.parameterTypes[i]);
            }
            return objectArray;
        }

        protected abstract Object newInstance(Object[] var1);
    }
}

