/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.errors.FaunaException;
import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Codecs;
import com.faunadb.client.types.Enums;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Types;
import com.faunadb.client.types.Value;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Decoder {
    private static final Double DOUBLE_DEFAULT = 0.0;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);

    private Decoder() {
    }

    public static <T> Result<T> decode(Value value, Type type) {
        if (value == null || value == Value.NullV.NULL) {
            return Result.fail("Value is null");
        }
        try {
            return Result.success(Decoder.decodeImpl(value, Types.of(type)));
        }
        catch (Exception exception) {
            return Result.fail(exception.getMessage(), exception);
        }
    }

    public static <T> Result<T> decode(Value value, Class<T> clazz) {
        return Decoder.decode(value, clazz);
    }

    static Object decodeImpl(Value value, Types.SimpleType simpleType) {
        Class<?> clazz = simpleType.getRawClass();
        if (value == null || value == Value.NullV.NULL) {
            return Decoder.defaultValue(clazz);
        }
        if (Value.class.isAssignableFrom(clazz)) {
            return Decoder.toValue(value, clazz);
        }
        if (clazz.isEnum()) {
            return Decoder.toEnum(value, clazz);
        }
        if (clazz == byte[].class && value.getClass() == Value.BytesV.class) {
            return value.to(Codec.BYTES).get();
        }
        if (clazz.isArray()) {
            return Decoder.toArray(value, clazz);
        }
        if (simpleType.getClass() == Types.CollectionType.class) {
            return Decoder.toCollection(value, (Types.CollectionType)simpleType);
        }
        if (simpleType.getClass() == Types.MapType.class) {
            return Decoder.toMap(value, (Types.MapType)simpleType);
        }
        if (clazz == Object.class) {
            return value;
        }
        return Codecs.getDecoder(clazz).decode(value).get();
    }

    private static <T> T defaultValue(Class<T> clazz) {
        if (clazz == Boolean.TYPE) {
            return (T)Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return (T)Character.valueOf('\u0000');
        }
        if (clazz == Byte.TYPE) {
            return (T)Byte.valueOf((byte)0);
        }
        if (clazz == Short.TYPE) {
            return (T)Short.valueOf((short)0);
        }
        if (clazz == Integer.TYPE) {
            return (T)Integer.valueOf(0);
        }
        if (clazz == Long.TYPE) {
            return (T)Long.valueOf(0L);
        }
        if (clazz == Float.TYPE) {
            return (T)FLOAT_DEFAULT;
        }
        if (clazz == Double.TYPE) {
            return (T)DOUBLE_DEFAULT;
        }
        return null;
    }

    private static Enum toEnum(Value value, Class<?> clazz) {
        Map<String, Enum> map = Enums.getDecodingMap(clazz);
        return map.get(value.to(Codec.STRING).get());
    }

    private static Map<String, Object> toMap(Value value, Types.MapType mapType) {
        try {
            Map<String, Value> map = value.to(Codec.OBJECT).get();
            Map map2 = (Map)Decoder.getConcreteClass(mapType.getRawClass()).newInstance();
            Types.SimpleType simpleType = mapType.getValueType();
            for (Map.Entry<String, Value> entry : map.entrySet()) {
                Object object = Decoder.decodeImpl(entry.getValue(), simpleType);
                map2.put(entry.getKey(), object);
            }
            return map2;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            return Decoder.couldNotInstantiateMap(mapType, reflectiveOperationException);
        }
    }

    private static Map<String, Object> couldNotInstantiateMap(Type type, Exception exception) {
        throw new FaunaException(String.format("Could not instantiate map of type %s", type), exception);
    }

    private static Collection<Object> toCollection(Value value, Types.CollectionType collectionType) {
        try {
            List<Value> list = value.to(Codec.ARRAY).get();
            Types.SimpleType simpleType = collectionType.getElementType();
            Collection collection = (Collection)Decoder.getConcreteClass(collectionType.getRawClass()).newInstance();
            for (Value value2 : list) {
                Object object = Decoder.decodeImpl(value2, simpleType);
                collection.add(object);
            }
            return collection;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            return (Collection)Decoder.couldNotInstantiateCollection(collectionType, reflectiveOperationException);
        }
    }

    private static <T> T couldNotInstantiateCollection(Type type, Exception exception) {
        throw new FaunaException(String.format("Could not instantiate collection of type %s", type), exception);
    }

    private static Class<?> getConcreteClass(Class<?> clazz) {
        if (!Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface()) {
            return clazz;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ArrayList.class;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return HashSet.class;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return HashMap.class;
        }
        throw new FaunaException(String.format("Abstract class not supported: $%s", clazz));
    }

    private static Object toArray(Value value, Class<?> clazz) {
        List<Value> list = value.to(Codec.ARRAY).get();
        Types.SimpleType simpleType = Types.of(clazz.getComponentType());
        int n = list.size();
        Object object = Array.newInstance(clazz.getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            Object object2 = Decoder.decodeImpl(list.get(i), simpleType);
            Array.set(object, i, object2);
        }
        return object;
    }

    private static Value toValue(Value value, Class<?> clazz) {
        if (clazz.isAssignableFrom(value.getClass())) {
            return value;
        }
        throw new FaunaException(String.format("Cannot cast %s to %s", value.getClass(), clazz));
    }
}

