/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.errors.FaunaException;
import com.faunadb.client.types.FaunaField;
import com.faunadb.client.types.FaunaIgnore;
import com.faunadb.client.types.Types;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class Properties {
    Properties() {
    }

    static Property[] getReadProperties(Class<?> clazz) {
        return Properties.getProperties(clazz, false);
    }

    static Property[] getWriteProperties(Class<?> clazz) {
        return Properties.getProperties(clazz, true);
    }

    private static Property[] getProperties(Class<?> clazz, boolean bl) {
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        for (Field field : clazz.getDeclaredFields()) {
            FaunaField object2;
            if ((field.getModifiers() & 8) != 0 || bl && (field.getModifiers() & 0x10) != 0 || field.isAnnotationPresent(FaunaIgnore.class) || (object2 = field.getAnnotation(FaunaField.class)) == null) continue;
            if (object2.value().length() > 0) {
                hashMap.put(object2.value(), field);
                continue;
            }
            hashMap.put(field.getName(), field);
        }
        HashMap hashMap2 = new HashMap();
        for (Method method : clazz.getMethods()) {
            String string;
            int n;
            if ((method.getModifiers() & 1) == 0 || (n = Properties.getPrefixOffset(method, bl)) < 0 || "class".equals(string = Properties.removePrefix(method.getName(), n)) || method.isAnnotationPresent(FaunaIgnore.class)) continue;
            FaunaField faunaField = method.getAnnotation(FaunaField.class);
            if (faunaField != null && faunaField.value().length() > 0) {
                string = faunaField.value();
            }
            if (!hashMap.containsKey(string)) {
                hashMap2.put(string, method);
                continue;
            }
            if (faunaField == null) continue;
            hashMap.remove(string);
            hashMap2.put(string, method);
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            arrayList.add(new FieldProperty((String)entry.getKey(), (Field)entry.getValue()));
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            Method method = (Method)entry.getValue();
            Type type = bl ? method.getGenericParameterTypes()[0] : method.getGenericReturnType();
            arrayList.add(new MethodProperty((String)entry.getKey(), method, type));
        }
        return arrayList.toArray(new Property[arrayList.size()]);
    }

    private static int getPrefixOffset(Method method, boolean bl) {
        if (bl && Properties.isSetter(method)) {
            return 3;
        }
        if (!bl && Properties.isGetter(method)) {
            return 3;
        }
        if (!bl && Properties.isBooleanGetter(method)) {
            return 2;
        }
        return -1;
    }

    private static String removePrefix(String string, int n) {
        char[] cArray = string.toCharArray();
        cArray[n] = Character.toLowerCase(cArray[n]);
        return new String(cArray, n, cArray.length - n);
    }

    private static boolean isGetter(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0;
    }

    private static boolean isBooleanGetter(Method method) {
        Class<?> clazz = method.getReturnType();
        return method.getName().startsWith("is") && method.getParameterTypes().length == 0 && (clazz == Boolean.TYPE || clazz == Boolean.class);
    }

    private static boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1;
    }

    static class MethodProperty
    implements Property {
        private final String name;
        private final Method method;
        private final Types.SimpleType type;

        MethodProperty(String string, Method method, Type type) {
            this.name = string;
            this.method = method;
            this.type = Types.of(type);
            this.method.setAccessible(true);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Types.SimpleType getType() {
            return this.type;
        }

        @Override
        public void set(Object object, Object object2) {
            try {
                this.method.invoke(object, object2);
            }
            catch (Exception exception) {
                throw new FaunaException(String.format("Error while invoking method %s on object %s", this.method, object), exception);
            }
        }

        @Override
        public Object get(Object object) {
            try {
                return this.method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw new FaunaException(String.format("Error while invoking method %s on object %s", this.method, object), exception);
            }
        }
    }

    static class FieldProperty
    implements Property {
        private final String name;
        private final Field field;
        private final Types.SimpleType type;

        FieldProperty(String string, Field field) {
            this.name = string;
            this.field = field;
            this.type = Types.of(field.getGenericType());
            this.field.setAccessible(true);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Types.SimpleType getType() {
            return this.type;
        }

        @Override
        public void set(Object object, Object object2) {
            try {
                this.field.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FaunaException(String.format("Error while setting field %s on object %s", this.field, object), illegalAccessException);
            }
        }

        @Override
        public Object get(Object object) {
            try {
                return this.field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FaunaException(String.format("Error while getting field %s from object %s", this.field, object), illegalAccessException);
            }
        }
    }

    public static interface Property {
        public String getName();

        public Types.SimpleType getType();

        public void set(Object var1, Object var2);

        public Object get(Object var1);
    }
}

