/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

final class Transformations {
    static final Function<Long, Integer> LONG_TO_INTEGER = Long::intValue;
    static final Function<Integer, Long> INTEGER_TO_LONG = Integer::longValue;
    static final Function<Long, Short> LONG_TO_SHORT = Long::shortValue;
    static final Function<Short, Long> SHORT_TO_LONG = Short::longValue;
    static final Function<Long, Byte> LONG_TO_BYTE = Long::byteValue;
    static final Function<Byte, Long> BYTE_TO_LONG = Byte::longValue;
    static final Function<Long, Character> LONG_TO_CHAR = l -> Character.valueOf((char)l.longValue());
    static final Function<Character, Long> CHAR_TO_LONG = Long::valueOf;
    static final Function<Double, Float> DOUBLE_TO_FLOAT = Double::floatValue;
    static final Function<Float, Double> FLOAT_TO_DOUBLE = Float::doubleValue;
    static final Function<Long, Value> LONG_TO_VALUE = Value.LongV::new;
    static final Function<Double, Value> DOUBLE_TO_VALUE = Value.DoubleV::new;
    static final Function<String, Value> STRING_TO_VALUE = Value.StringV::new;
    static final Function<Boolean, Value> BOOLEAN_TO_VALUE = Value.BooleanV::valueOf;
    static final Function<Instant, Value> INSTANT_TO_VALUE = Value.TimeV::new;
    static final Function<LocalDate, Value> LOCAL_DATE_TO_VALUE = Value.DateV::new;
    static final Function<Map<String, Value>, Value> MAP_TO_VALUE = Value.ObjectV::new;
    static final Function<List<Value>, Value> LIST_TO_VALUE = Value.ArrayV::new;
    static final Function<byte[], Value> BYTES_TO_VALUE = Value.BytesV::new;
    static final Function<Value.TimeV, Instant> VALUE_TO_INSTANT = Value.TimeV::truncated;
    static final Function<Value.ArrayV, List<Value>> VALUE_TO_LIST = arrayV -> arrayV.values;
    static final Function<Value.ObjectV, Map<String, Value>> VALUE_TO_MAP = objectV -> objectV.values;

    Transformations() {
    }

    static <V extends Value, O> Codec<O> mapTo(final Class<V> clazz, final Function<V, O> function, final Function<O, Value> function2) {
        return new Codec<O>(){

            @Override
            public Result<O> decode(Value value) {
                try {
                    return Transformations.cast(clazz, value).map(function);
                }
                catch (Exception exception) {
                    return Result.fail(exception.getMessage(), exception);
                }
            }

            @Override
            public Result<Value> encode(O o) {
                try {
                    return Result.success((Value)function2.apply(o));
                }
                catch (Exception exception) {
                    return Result.fail(exception.getMessage(), exception);
                }
            }
        };
    }

    static <I, O> Codec<O> mapWith(final Codec<I> codec, final Function<I, O> function, final Function<O, I> function2) {
        return new Codec<O>(){

            @Override
            public Result<O> decode(Value value) {
                try {
                    return codec.decode(value).map(function);
                }
                catch (Exception exception) {
                    return Result.fail(exception.getMessage(), exception);
                }
            }

            @Override
            public Result<Value> encode(O o) {
                try {
                    return codec.encode(function2.apply(o));
                }
                catch (Exception exception) {
                    return Result.fail(exception.getMessage(), exception);
                }
            }
        };
    }

    private static <T> Result<T> cast(Class<T> clazz, Value value) {
        if (clazz.isInstance(value)) {
            return Result.success(clazz.cast(value));
        }
        return Result.fail(String.format("Can not convert %s to %s", value.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    static <T extends Value.ScalarValue<R>, R> Function<T, R> scalarValue() {
        return scalarValue -> scalarValue.value;
    }

    static <I extends O, O> Function<I, O> upCast() {
        return Function.identity();
    }
}

