/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.errors.FaunaException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Types {
    private static final SimpleType STRING_TYPE = new SimpleType(String.class);
    private static final SimpleType OBJ_TYPE = new SimpleType(Object.class);
    private static final SimpleType[] EMPTY_BINDING = new SimpleType[]{OBJ_TYPE, OBJ_TYPE};
    private static final ConcurrentHashMap<Type, SimpleType> KNOWN_TYPES = new ConcurrentHashMap();

    private Types() {
    }

    public static CollectionType collectionOf(Class<? extends Collection> clazz, Type type) {
        return new CollectionType(clazz, Types.of(type));
    }

    public static CollectionType arrayListOf(Type type) {
        return Types.collectionOf(ArrayList.class, type);
    }

    public static CollectionType hashSetOf(Type type) {
        return Types.collectionOf(HashSet.class, type);
    }

    public static MapType mapOf(Class<? extends Map> clazz, Type type) {
        return new MapType(clazz, Types.of(String.class), Types.of(type));
    }

    public static MapType hashMapOf(Type type) {
        return Types.mapOf(HashMap.class, type);
    }

    static SimpleType of(Type type) {
        SimpleType simpleType = KNOWN_TYPES.get(type);
        if (simpleType != null) {
            return simpleType;
        }
        if (type instanceof Class) {
            return Types.fromClass((Class)type, new SimpleType[0]);
        }
        if (type instanceof ParameterizedType) {
            return Types.fromParameterizedType((ParameterizedType)type);
        }
        if (type instanceof SimpleType) {
            return (SimpleType)type;
        }
        throw new FaunaException(String.format("Unknown java type: %s", type));
    }

    private static SimpleType fromClass(Class<?> clazz, SimpleType ... simpleTypeArray) {
        if (simpleTypeArray.length == 0) {
            simpleTypeArray = EMPTY_BINDING;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Types.collectionOf(clazz, simpleTypeArray[0]);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            SimpleType simpleType = simpleTypeArray[0];
            if (simpleType != STRING_TYPE) {
                throw new FaunaException("Only string keys are supported for maps");
            }
            return Types.mapOf(clazz, simpleTypeArray[1]);
        }
        SimpleType simpleType = new SimpleType(clazz);
        KNOWN_TYPES.put(clazz, simpleType);
        return simpleType;
    }

    private static SimpleType fromParameterizedType(ParameterizedType parameterizedType) {
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        SimpleType[] simpleTypeArray = new SimpleType[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            simpleTypeArray[i] = Types.of(typeArray[i]);
        }
        return Types.fromClass(clazz, simpleTypeArray);
    }

    static {
        KNOWN_TYPES.put((Type)((Object)String.class), STRING_TYPE);
        KNOWN_TYPES.put(Boolean.TYPE, new SimpleType(Boolean.TYPE));
        KNOWN_TYPES.put(Long.TYPE, new SimpleType(Long.TYPE));
        KNOWN_TYPES.put(Integer.TYPE, new SimpleType(Integer.TYPE));
        KNOWN_TYPES.put(Short.TYPE, new SimpleType(Short.TYPE));
        KNOWN_TYPES.put(Byte.TYPE, new SimpleType(Byte.TYPE));
        KNOWN_TYPES.put(Character.TYPE, new SimpleType(Character.TYPE));
        KNOWN_TYPES.put(Float.TYPE, new SimpleType(Float.TYPE));
        KNOWN_TYPES.put(Double.TYPE, new SimpleType(Double.TYPE));
        KNOWN_TYPES.put((Type)((Object)Boolean.class), new SimpleType(Boolean.class));
        KNOWN_TYPES.put((Type)((Object)Long.class), new SimpleType(Long.class));
        KNOWN_TYPES.put((Type)((Object)Integer.class), new SimpleType(Integer.class));
        KNOWN_TYPES.put((Type)((Object)Short.class), new SimpleType(Short.class));
        KNOWN_TYPES.put((Type)((Object)Byte.class), new SimpleType(Byte.class));
        KNOWN_TYPES.put((Type)((Object)Character.class), new SimpleType(Character.class));
        KNOWN_TYPES.put((Type)((Object)Float.class), new SimpleType(Float.class));
        KNOWN_TYPES.put((Type)((Object)Double.class), new SimpleType(Double.class));
    }

    static class MapType
    extends SimpleType {
        private final SimpleType keyType;
        private final SimpleType valueType;

        MapType(Class<?> clazz, SimpleType simpleType, SimpleType simpleType2) {
            super(clazz);
            this.keyType = simpleType;
            this.valueType = simpleType2;
        }

        SimpleType getKeyType() {
            return this.keyType;
        }

        SimpleType getValueType() {
            return this.valueType;
        }

        @Override
        public String toString() {
            return String.format("%s<%s,%s>", this.getRawClass().getName(), this.keyType, this.valueType);
        }
    }

    static class CollectionType
    extends SimpleType {
        private final SimpleType elementType;

        CollectionType(Class<?> clazz, SimpleType simpleType) {
            super(clazz);
            this.elementType = simpleType;
        }

        SimpleType getElementType() {
            return this.elementType;
        }

        @Override
        public String toString() {
            return String.format("%s<%s>", this.getRawClass().getName(), this.elementType);
        }
    }

    static class SimpleType
    implements Type {
        private final Class<?> rawClass;

        SimpleType(Class<?> clazz) {
            this.rawClass = clazz;
        }

        Class<?> getRawClass() {
            return this.rawClass;
        }

        public String toString() {
            return this.rawClass.getName();
        }
    }
}

