/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.streaming;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.faunadb.client.HttpResponses;
import com.faunadb.client.errors.StreamingException;
import com.faunadb.client.types.Field;
import com.faunadb.client.types.Value;
import com.faunadb.common.Connection;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyValueFlowProcessor
extends SubmissionPublisher<Value>
implements Flow.Processor<List<ByteBuffer>, Value> {
    private static Value ErrorValue = new Value.StringV("error");
    private static Field<Long> TxnField = Field.at("txn").to(Long.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper json;
    private Connection connection;
    private Flow.Subscription subscription = null;
    private Flow.Subscriber<? super Value> subscriber = null;

    public BodyValueFlowProcessor(ObjectMapper objectMapper, Connection connection) {
        this.json = objectMapper;
        this.connection = connection;
    }

    private void requestOne() {
        this.subscription.request(1L);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Value> subscriber) {
        if (this.subscriber != null) {
            throw new IllegalStateException("BodyValueFlowProcessor can have only one subscriber");
        }
        this.subscriber = subscriber;
        super.subscribe(subscriber);
        this.requestOne();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public void onNext(List<ByteBuffer> list) {
        String string = list.stream().map(byteBuffer -> StandardCharsets.UTF_8.decode((ByteBuffer)byteBuffer).toString()).collect(Collectors.joining());
        try {
            JsonNode jsonNode = this.json.readTree(string);
            Value value2 = (Value)this.json.treeToValue((TreeNode)jsonNode, Value.class);
            value2.getOptional(TxnField).ifPresent(l -> this.connection.syncLastTxnTime(l.longValue()));
            Boolean bl = value2.at("type").getOptional().map(value -> value.equals(ErrorValue)).orElse(false);
            if (bl.booleanValue()) {
                HttpResponses.QueryError queryError = (HttpResponses.QueryError)this.json.treeToValue((TreeNode)jsonNode.get("event"), HttpResponses.QueryError.class);
                StreamingException streamingException = new StreamingException(queryError);
                this.subscriber.onError(streamingException);
                this.subscription.cancel();
            } else {
                this.submit(value2);
            }
        }
        catch (Exception exception) {
            this.log.error("could not parse event " + string, (Throwable)exception);
            this.subscriber.onError(exception);
            this.subscription.cancel();
        }
        this.requestOne();
    }

    @Override
    public void onError(Throwable throwable) {
        this.log.error("unrecoverable error encountered by subscription", throwable);
        this.subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.log.debug("subscription completed");
        this.subscriber.onComplete();
    }
}

