/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.streaming;

import com.faunadb.client.query.Expr;
import com.faunadb.client.types.Field;
import com.faunadb.client.types.Value;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.SubmissionPublisher;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotEventFlowProcessor
extends SubmissionPublisher<Value>
implements Flow.Processor<Value, Value> {
    private static Field<Long> TxnField = Field.at("txn").to(Long.class);
    private static Field<Long> TsField = Field.at("ts").to(Long.class);
    private static Field<String> TypeField = Field.at("type").to(String.class);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Function<Expr, CompletableFuture<Value>> loadDocument;
    private Expr target;
    private Flow.Subscription subscription = null;
    private Flow.Subscriber<? super Value> subscriber = null;
    private Long snapshotTS = null;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public SnapshotEventFlowProcessor(Expr expr, Function<Expr, CompletableFuture<Value>> function) {
        this.loadDocument = function;
        this.target = expr;
    }

    private void requestOne() {
        this.subscription.request(1L);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Value> subscriber) {
        if (this.subscriber != null) {
            throw new IllegalStateException("SnapshotEventFlowProcessor can have only one subscriber");
        }
        this.subscriber = subscriber;
        super.subscribe(subscriber);
        this.requestOne();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public void onNext(Value value) {
        if (this.initialized.get()) {
            Long l = value.get(TxnField);
            if (l > this.snapshotTS) {
                this.submit(value);
            }
            this.requestOne();
        } else {
            boolean bl = value.getOptional(TypeField).map(string -> string.equals("start")).orElse(false);
            if (bl) {
                this.loadDocument.apply(this.target).whenComplete((value2, throwable) -> {
                    if (throwable != null) {
                        this.onError((Throwable)throwable);
                        this.subscription.cancel();
                    } else {
                        this.snapshotTS = value2.get(TsField);
                        this.submit(value);
                        HashMap<String, Value> hashMap = new HashMap<String, Value>();
                        hashMap.put("type", new Value.StringV("snapshot"));
                        hashMap.put("txn", new Value.LongV(this.snapshotTS));
                        hashMap.put("event", (Value)value2);
                        Value.ObjectV objectV = new Value.ObjectV(hashMap);
                        this.submit(objectV);
                        this.initialized.set(true);
                        this.requestOne();
                    }
                });
            } else {
                this.onError(new IllegalArgumentException("Stream did not begin with a `start` event but with" + value));
                this.subscription.cancel();
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.log.error("unrecoverable error encountered by subscription", throwable);
        this.subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.log.debug("subscription completed");
        this.subscriber.onComplete();
    }
}

