/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.Result;
import com.faunadb.client.types.Transformations;
import com.faunadb.client.types.Value;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface Codec<T> {
    public static final Codec<Value> VALUE = new Codec<Value>(){

        @Override
        public Result<Value> decode(Value value) {
            if (value == Value.NullV.NULL) {
                return Result.fail("Value is null");
            }
            return Result.success(value);
        }

        @Override
        public Result<Value> encode(Value value) {
            if (value == Value.NullV.NULL) {
                return Result.fail("Value is null");
            }
            return Result.success(value);
        }
    };
    public static final Codec<Value.RefV> REF = Transformations.mapTo(Value.RefV.class, Function.identity(), Transformations.upCast());
    public static final Codec<Value.SetRefV> SET_REF = Transformations.mapTo(Value.SetRefV.class, Function.identity(), Transformations.upCast());
    public static final Codec<Long> LONG = Transformations.mapTo(Value.LongV.class, Transformations.scalarValue(), Transformations.LONG_TO_VALUE);
    public static final Codec<Integer> INTEGER = Transformations.mapWith(LONG, Transformations.LONG_TO_INTEGER, Transformations.INTEGER_TO_LONG);
    public static final Codec<Short> SHORT = Transformations.mapWith(LONG, Transformations.LONG_TO_SHORT, Transformations.SHORT_TO_LONG);
    public static final Codec<Byte> BYTE = Transformations.mapWith(LONG, Transformations.LONG_TO_BYTE, Transformations.BYTE_TO_LONG);
    public static final Codec<Character> CHAR = Transformations.mapWith(LONG, Transformations.LONG_TO_CHAR, Transformations.CHAR_TO_LONG);
    public static final Codec<Instant> TIME = Transformations.mapTo(Value.TimeV.class, Transformations.VALUE_TO_INSTANT, Transformations.INSTANT_TO_VALUE);
    public static final Codec<String> STRING = Transformations.mapTo(Value.StringV.class, Transformations.scalarValue(), Transformations.STRING_TO_VALUE);
    public static final Codec<Double> DOUBLE = Transformations.mapTo(Value.DoubleV.class, Transformations.scalarValue(), Transformations.DOUBLE_TO_VALUE);
    public static final Codec<Float> FLOAT = Transformations.mapWith(DOUBLE, Transformations.DOUBLE_TO_FLOAT, Transformations.FLOAT_TO_DOUBLE);
    public static final Codec<Boolean> BOOLEAN = Transformations.mapTo(Value.BooleanV.class, Transformations.scalarValue(), Transformations.BOOLEAN_TO_VALUE);
    public static final Codec<LocalDate> DATE = Transformations.mapTo(Value.DateV.class, Transformations.scalarValue(), Transformations.LOCAL_DATE_TO_VALUE);
    public static final Codec<List<Value>> ARRAY = Transformations.mapTo(Value.ArrayV.class, Transformations.VALUE_TO_LIST, Transformations.LIST_TO_VALUE);
    public static final Codec<Map<String, Value>> OBJECT = Transformations.mapTo(Value.ObjectV.class, Transformations.VALUE_TO_MAP, Transformations.MAP_TO_VALUE);
    public static final Codec<byte[]> BYTES = Transformations.mapTo(Value.BytesV.class, Transformations.scalarValue(), Transformations.BYTES_TO_VALUE);

    public Result<T> decode(Value var1);

    public Result<Value> encode(T var1);
}

