/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.faunadb.client.types.Value;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class Deserializer {
    Deserializer() {
    }

    private static Value toValueOrNullV(JsonNode jsonNode, ObjectMapper objectMapper) {
        Value value = (Value)objectMapper.convertValue((Object)jsonNode, Value.class);
        return value != null ? value : Value.NullV.NULL;
    }

    static class ObjectDeserializer
    extends TreeDeserializer<Value.ObjectV> {
        ObjectDeserializer() {
        }

        @Override
        Value.ObjectV deserializeTree(JsonParser jsonParser, JsonNode jsonNode, ObjectMapper objectMapper, JsonLocation jsonLocation) {
            LinkedHashMap<String, Value> linkedHashMap = new LinkedHashMap<String, Value>();
            Iterator iterator = jsonNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                linkedHashMap.put((String)entry.getKey(), Deserializer.toValueOrNullV((JsonNode)entry.getValue(), objectMapper));
            }
            return new Value.ObjectV(linkedHashMap);
        }
    }

    static class ArrayDeserializer
    extends TreeDeserializer<Value.ArrayV> {
        ArrayDeserializer() {
        }

        @Override
        Value.ArrayV deserializeTree(JsonParser jsonParser, JsonNode jsonNode, ObjectMapper objectMapper, JsonLocation jsonLocation) {
            ArrayList<Value> arrayList = new ArrayList<Value>();
            Iterator iterator = jsonNode.elements();
            while (iterator.hasNext()) {
                arrayList.add(Deserializer.toValueOrNullV((JsonNode)iterator.next(), objectMapper));
            }
            return new Value.ArrayV(arrayList);
        }
    }

    static class ValueDeserializer
    extends TreeDeserializer<Value> {
        ValueDeserializer() {
        }

        @Override
        Value deserializeTree(JsonParser jsonParser, JsonNode jsonNode, ObjectMapper objectMapper, JsonLocation jsonLocation) throws JsonParseException {
            switch (jsonNode.getNodeType()) {
                case OBJECT: {
                    return this.deserializeSpecial(jsonNode, objectMapper);
                }
                case ARRAY: {
                    return (Value)objectMapper.convertValue((Object)jsonNode, Value.ArrayV.class);
                }
                case STRING: {
                    return (Value)objectMapper.convertValue((Object)jsonNode, Value.StringV.class);
                }
                case BOOLEAN: {
                    return (Value)objectMapper.convertValue((Object)jsonNode, Value.BooleanV.class);
                }
                case NUMBER: {
                    return jsonNode.isDouble() ? (Value)objectMapper.convertValue((Object)jsonNode, Value.DoubleV.class) : (Value)objectMapper.convertValue((Object)jsonNode, Value.LongV.class);
                }
                case NULL: {
                    return Value.NullV.NULL;
                }
            }
            throw new JsonParseException(jsonParser, "Cannot deserialize as a Value", jsonLocation);
        }

        private Value deserializeSpecial(JsonNode jsonNode, ObjectMapper objectMapper) {
            String string;
            if (jsonNode.size() == 0) {
                return (Value)objectMapper.convertValue((Object)jsonNode, Value.ObjectV.class);
            }
            switch (string = (String)jsonNode.fieldNames().next()) {
                case "@ref": {
                    return this.deserializeRefs(jsonNode);
                }
                case "@set": {
                    return (Value)objectMapper.convertValue((Object)jsonNode, Value.SetRefV.class);
                }
                case "@ts": {
                    return (Value)objectMapper.convertValue((Object)jsonNode, Value.TimeV.class);
                }
                case "@date": {
                    return (Value)objectMapper.convertValue((Object)jsonNode, Value.DateV.class);
                }
                case "@bytes": {
                    return (Value)objectMapper.convertValue((Object)jsonNode, Value.BytesV.class);
                }
                case "@query": {
                    return (Value)objectMapper.convertValue((Object)jsonNode, Value.QueryV.class);
                }
                case "@obj": {
                    return (Value)objectMapper.convertValue((Object)jsonNode.get("@obj"), Value.ObjectV.class);
                }
            }
            return (Value)objectMapper.convertValue((Object)jsonNode, Value.ObjectV.class);
        }

        private Value.RefV deserializeRefs(JsonNode jsonNode) {
            if (jsonNode == null) {
                return null;
            }
            JsonNode jsonNode2 = jsonNode.get("@ref");
            if (jsonNode2 != null) {
                return this.makeRef(jsonNode2);
            }
            throw new IllegalArgumentException(String.format("Malformed @ref: %s", jsonNode));
        }

        private Value.RefV makeRef(JsonNode jsonNode) {
            JsonNode jsonNode2 = jsonNode.get("id");
            Value.RefV refV = this.deserializeRefs(jsonNode.get("collection"));
            Value.RefV refV2 = this.deserializeRefs(jsonNode.get("database"));
            String string = jsonNode2.textValue();
            if (refV == null && refV2 == null) {
                return Value.Native.fromName(string);
            }
            return new Value.RefV(string, refV, refV2);
        }
    }

    private static abstract class TreeDeserializer<T>
    extends JsonDeserializer<T> {
        private TreeDeserializer() {
        }

        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonLocation jsonLocation = jsonParser.getTokenLocation();
            ObjectMapper objectMapper = (ObjectMapper)jsonParser.getCodec();
            JsonNode jsonNode = (JsonNode)objectMapper.readTree(jsonParser);
            return this.deserializeTree(jsonParser, jsonNode, objectMapper, jsonLocation);
        }

        abstract T deserializeTree(JsonParser var1, JsonNode var2, ObjectMapper var3, JsonLocation var4) throws JsonParseException;
    }
}

