/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.errors.FaunaException;
import com.faunadb.client.types.Codec;
import com.faunadb.client.types.Codecs;
import com.faunadb.client.types.Enums;
import com.faunadb.client.types.Result;
import com.faunadb.client.types.Value;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public final class Encoder {
    private final Stack<Object> stack = new Stack();

    private Encoder() {
    }

    public static Result<Value> encode(Object object) {
        try {
            return Result.success(new Encoder().encodeImpl(object));
        }
        catch (Exception exception) {
            return Result.fail(exception.getMessage(), exception);
        }
    }

    Value encodeImpl(Object object) {
        if (object == null) {
            return Value.NullV.NULL;
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (this.contains(object)) {
            throw new FaunaException(String.format("Self reference loop detected for object \"%s\"", object));
        }
        try {
            this.stack.push(object);
            Value value = this.encodeIntern(object);
            return value;
        }
        finally {
            this.stack.pop();
        }
    }

    private boolean contains(Object object) {
        for (Object e : this.stack) {
            if (e != object) continue;
            return true;
        }
        return false;
    }

    private Value encodeIntern(Object object) {
        Class<Enum> clazz = object.getClass();
        if (clazz.isEnum()) {
            return Enums.getEncodingMap(clazz).get(object);
        }
        if (clazz == byte[].class) {
            return Codec.BYTES.encode((byte[])object).get();
        }
        if (clazz.isArray()) {
            return this.wrapArray(object);
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return this.wrapIterable((Iterable)object);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.wrapMap((Map)object);
        }
        return Codecs.getEncoder(this, clazz).encode(object).get();
    }

    private Value wrapMap(Map<?, ?> map) {
        HashMap<String, Value> hashMap = new HashMap<String, Value>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            hashMap.put(entry.getKey().toString(), this.encodeImpl(entry.getValue()));
        }
        return new Value.ObjectV(hashMap);
    }

    private Value wrapIterable(Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        ArrayList<Value> arrayList = new ArrayList<Value>();
        while (iterator.hasNext()) {
            arrayList.add(this.encodeImpl(iterator.next()));
        }
        return new Value.ArrayV(arrayList);
    }

    private Value wrapArray(Object object) {
        int n = Array.getLength(object);
        ArrayList<Value> arrayList = new ArrayList<Value>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.encodeImpl(Array.get(object, i)));
        }
        return new Value.ArrayV(arrayList);
    }
}

