/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import com.faunadb.client.types.FaunaEnum;
import com.faunadb.client.types.Value;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class Enums {
    private static final ConcurrentHashMap<Class<?>, Map<Enum, Value.StringV>> ENCODING_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Map<String, Enum>> DECODING_MAP = new ConcurrentHashMap();

    private Enums() {
    }

    public static Map<Enum, Value.StringV> getEncodingMap(Class<Enum> clazz) {
        Map<Enum, Value.StringV> map = ENCODING_MAP.get(clazz);
        if (map == null) {
            map = new EnumMap<Enum, Value.StringV>(clazz);
            for (Enum enum_ : clazz.getEnumConstants()) {
                try {
                    Field field = clazz.getField(enum_.name());
                    FaunaEnum faunaEnum = field.getAnnotation(FaunaEnum.class);
                    String string = faunaEnum != null ? faunaEnum.value() : enum_.name();
                    map.put(enum_, new Value.StringV(string));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            ENCODING_MAP.put(clazz, map);
        }
        return map;
    }

    public static Map<String, Enum> getDecodingMap(Class<Enum> clazz) {
        Map<String, Enum> map = DECODING_MAP.get(clazz);
        if (map == null) {
            map = new HashMap<String, Enum>();
            for (Map.Entry<Enum, Value.StringV> entry : Enums.getEncodingMap(clazz).entrySet()) {
                map.put((String)entry.getValue().value, entry.getKey());
            }
            DECODING_MAP.put(clazz, map);
        }
        return map;
    }
}

