/*
 * Decompiled with CFR 0.152.
 */
package com.faunadb.client.types;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Result<T> {
    public static <T> Result<T> success(T t) {
        return new Success<T>(t);
    }

    public static <T> Result<T> fail(String string) {
        return new Failure(string, null);
    }

    public static <T> Result<T> fail(String string, Throwable throwable) {
        return new Failure(string, throwable);
    }

    private Result() {
    }

    public abstract boolean isSuccess();

    public abstract boolean isFailure();

    public abstract T get();

    public abstract Optional<T> getOptional();

    public abstract T getOrElse(Supplier<T> var1);

    public T orElseGet(Supplier<T> supplier) {
        return this.getOrElse(supplier);
    }

    public abstract <U> Result<U> map(Function<T, U> var1);

    public abstract <U> Result<U> flatMap(Function<T, Result<U>> var1);

    public T orNull() {
        return this.getOptional().orElse(null);
    }

    private static final class Failure<A>
    extends Result<A> {
        private final String error;
        private final Throwable cause;

        private Failure(String string, Throwable throwable) {
            this.error = string;
            this.cause = throwable;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public A get() {
            throw new IllegalStateException(this.error, this.cause);
        }

        @Override
        public Optional<A> getOptional() {
            return Optional.empty();
        }

        @Override
        public A getOrElse(Supplier<A> supplier) {
            return supplier.get();
        }

        @Override
        public <U> Result<U> map(Function<A, U> function) {
            return new Failure<A>(this.error, this.cause);
        }

        @Override
        public <U> Result<U> flatMap(Function<A, Result<U>> function) {
            return new Failure<A>(this.error, this.cause);
        }

        public boolean equals(Object object) {
            return object instanceof Failure && this.error.equals(((Failure)object).error);
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        public String toString() {
            return this.error;
        }
    }

    private static final class Success<A>
    extends Result<A> {
        private final A value;

        private Success(A a) {
            this.value = a;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public A get() {
            return this.value;
        }

        @Override
        public Optional<A> getOptional() {
            return Optional.of(this.value);
        }

        @Override
        public A getOrElse(Supplier<A> supplier) {
            return this.value;
        }

        @Override
        public <U> Result<U> map(Function<A, U> function) {
            return new Success<U>(function.apply(this.value));
        }

        @Override
        public <U> Result<U> flatMap(Function<A, Result<U>> function) {
            return function.apply(this.value);
        }

        public boolean equals(Object object) {
            return object instanceof Success && this.value.equals(((Success)object).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

