/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public final class SerialPort {
    private static boolean isAndroid;
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    public static final int MARK_PARITY = 3;
    public static final int SPACE_PARITY = 4;
    public static final int ONE_STOP_BIT = 1;
    public static final int ONE_POINT_FIVE_STOP_BITS = 2;
    public static final int TWO_STOP_BITS = 3;
    public static final int FLOW_CONTROL_DISABLED = 0;
    public static final int FLOW_CONTROL_RTS_ENABLED = 1;
    public static final int FLOW_CONTROL_CTS_ENABLED = 16;
    public static final int FLOW_CONTROL_DSR_ENABLED = 256;
    public static final int FLOW_CONTROL_DTR_ENABLED = 4096;
    public static final int FLOW_CONTROL_XONXOFF_IN_ENABLED = 65536;
    public static final int FLOW_CONTROL_XONXOFF_OUT_ENABLED = 0x100000;
    public static final int TIMEOUT_NONBLOCKING = 0;
    public static final int TIMEOUT_READ_SEMI_BLOCKING = 1;
    public static final int TIMEOUT_WRITE_SEMI_BLOCKING = 16;
    public static final int TIMEOUT_READ_BLOCKING = 256;
    public static final int TIMEOUT_WRITE_BLOCKING = 4096;
    public static final int LISTENING_EVENT_DATA_AVAILABLE = 1;
    public static final int LISTENING_EVENT_DATA_RECEIVED = 16;
    public static final int LISTENING_EVENT_DATA_WRITTEN = 256;
    private volatile int baudRate = 9600;
    private volatile int dataBits = 8;
    private volatile int stopBits = 1;
    private volatile int parity = 0;
    private volatile int eventFlags = 0;
    private volatile int timeoutMode = 0;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile int flowControl = 0;
    private volatile SerialPortInputStream inputStream = null;
    private volatile SerialPortOutputStream outputStream = null;
    private volatile SerialPortDataListener userDataListener = null;
    private volatile SerialPortEventListener serialEventListener = null;
    private volatile String portString;
    private volatile String comPort;
    private volatile long portHandle = -1L;
    private volatile boolean isOpened = false;

    public static native SerialPort[] getCommPorts();

    public static SerialPort getCommPort(String portDescriptor) {
        if (portDescriptor.contains("COM")) {
            portDescriptor = "\\\\.\\" + portDescriptor.substring(portDescriptor.lastIndexOf(92) + 1);
        }
        SerialPort serialPort = new SerialPort();
        serialPort.comPort = portDescriptor;
        serialPort.portString = "User-Specified Port";
        return serialPort;
    }

    public final boolean openPort() {
        try {
            String grantPermissions = "chmod 666 " + this.getSystemPortName() + "\nexit\n";
            Process process = Runtime.getRuntime().exec("su -c " + grantPermissions);
            process.waitFor();
        }
        catch (Exception e) {
            return false;
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isOpened && this.openPortNative()) {
            this.inputStream = new SerialPortInputStream();
            this.outputStream = new SerialPortOutputStream();
            if (this.serialEventListener != null) {
                this.serialEventListener.startListening();
            }
        }
        return this.isOpened;
    }

    public final boolean closePort() {
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
        }
        if (this.isOpened && this.closePortNative()) {
            this.inputStream = null;
            this.outputStream = null;
        }
        return !this.isOpened;
    }

    private final native boolean openPortNative();

    private final native boolean closePortNative();

    private final native boolean configPort();

    private final native boolean configFlowControl();

    private final native boolean configTimeouts();

    private final native boolean configEventFlags();

    private final native int waitForEvent();

    public final native int bytesAvailable();

    public final native int readBytes(byte[] var1, long var2);

    public final native int writeBytes(byte[] var1, long var2);

    private SerialPort() {
    }

    public final boolean addDataListener(SerialPortDataListener listener) {
        if (this.userDataListener != null) {
            return false;
        }
        this.userDataListener = listener;
        this.serialEventListener = new SerialPortEventListener(this.userDataListener instanceof SerialPortPacketListener ? ((SerialPortPacketListener)this.userDataListener).getPacketSize() : 0);
        this.eventFlags = 0;
        if ((listener.getListeningEvents() & 1) > 0) {
            this.eventFlags |= 1;
        }
        if ((listener.getListeningEvents() & 0x10) > 0) {
            this.eventFlags |= 0x10;
        }
        if ((listener.getListeningEvents() & 0x100) > 0) {
            this.eventFlags |= 0x100;
        }
        if (this.isOpened) {
            this.configEventFlags();
            this.serialEventListener.startListening();
        }
        return true;
    }

    public final void removeDataListener() {
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
            this.serialEventListener = null;
        }
        this.userDataListener = null;
        this.eventFlags = 0;
        if (this.isOpened) {
            this.configEventFlags();
        }
    }

    public final InputStream getInputStream() {
        return this.inputStream;
    }

    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final void setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity) {
        this.baudRate = newBaudRate;
        this.dataBits = newDataBits;
        this.stopBits = newStopBits;
        this.parity = newParity;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.configPort();
        }
    }

    public final void setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        this.timeoutMode = newTimeoutMode;
        this.readTimeout = newReadTimeout;
        this.writeTimeout = newWriteTimeout;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.configTimeouts();
        }
    }

    public final void setBaudRate(int newBaudRate) {
        this.baudRate = newBaudRate;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort();
        }
    }

    public final void setNumDataBits(int newDataBits) {
        this.dataBits = newDataBits;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort();
        }
    }

    public final void setNumStopBits(int newStopBits) {
        this.stopBits = newStopBits;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort();
        }
    }

    public final void setFlowControl(int newFlowControlSettings) {
        this.flowControl = newFlowControlSettings;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configFlowControl();
        }
    }

    public final void setParity(int newParity) {
        this.parity = newParity;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort();
        }
    }

    public final String getDescriptivePortName() {
        return this.portString.trim();
    }

    public final String getSystemPortName() {
        return this.comPort.substring(this.comPort.lastIndexOf(92) + 1);
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final int getNumDataBits() {
        return this.dataBits;
    }

    public final int getNumStopBits() {
        return this.stopBits;
    }

    public final int getParity() {
        return this.parity;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final int getFlowControlSettings() {
        return this.flowControl;
    }

    static {
        String line;
        isAndroid = false;
        String OS = System.getProperty("os.name").toLowerCase();
        String libraryPath = "";
        String fileName = "";
        String tempFileDirectory = System.getProperty("java.io.tmpdir");
        if (tempFileDirectory.charAt(tempFileDirectory.length() - 1) != '\\' && tempFileDirectory.charAt(tempFileDirectory.length() - 1) != '/') {
            tempFileDirectory = tempFileDirectory + "/";
        }
        if (System.getProperty("java.vm.vendor").toLowerCase().contains("android")) {
            try {
                BufferedReader buildPropertiesFile = new BufferedReader(new FileReader("/system/build.prop"));
                while ((line = buildPropertiesFile.readLine()) != null) {
                    if (!line.contains("ro.product.cpu.abi") && !line.contains("ro.product.cpu.abi2") && !line.contains("ro.product.cpu.abilist") && !line.contains("ro.product.cpu.abilist64") && !line.contains("ro.product.cpu.abilist32")) continue;
                    libraryPath = line.indexOf(44) == -1 ? "Android/" + line.substring(line.indexOf(61) + 1) : "Android/" + line.substring(line.indexOf(61) + 1, line.indexOf(44));
                    break;
                }
                buildPropertiesFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            isAndroid = true;
            if (libraryPath.isEmpty()) {
                libraryPath = "Android/armeabi";
            }
            fileName = "libjSerialComm.so";
        } else if (OS.indexOf("win") >= 0) {
            libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? "Windows/x86_64" : "Windows/x86";
            fileName = "jSerialComm.dll";
        } else if (OS.indexOf("mac") >= 0) {
            libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? "OSX/x86_64" : "OSX/x86";
            fileName = "libjSerialComm.jnilib";
        } else if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0) {
            if (System.getProperty("os.arch").indexOf("arm") >= 0) {
                File linkerFile;
                try {
                    BufferedReader cpuPropertiesFile = new BufferedReader(new FileReader("/proc/cpuinfo"));
                    while ((line = cpuPropertiesFile.readLine()) != null) {
                        if (!line.contains("ARMv")) continue;
                        libraryPath = "Linux/armv" + line.substring(line.indexOf("ARMv") + 4, line.indexOf("ARMv") + 5);
                        break;
                    }
                    cpuPropertiesFile.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (libraryPath.isEmpty()) {
                    libraryPath = "Linux/armv6";
                }
                if ((linkerFile = new File("/lib/ld-linux-armhf.so.3")).exists()) {
                    libraryPath = libraryPath + "-hf";
                }
            } else {
                libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? "Linux/x86_64" : "Linux/x86";
            }
            fileName = "libjSerialComm.so";
        } else {
            System.err.println("This operating system is not supported by the jSerialComm library.");
            System.exit(-1);
        }
        String tempFileName = tempFileDirectory + new Date().getTime() + "-" + fileName;
        File tempNativeLibrary = new File(tempFileName);
        tempNativeLibrary.deleteOnExit();
        try {
            int numBytesRead;
            InputStream fileContents = SerialPort.class.getResourceAsStream("/" + libraryPath + "/" + fileName);
            FileOutputStream destinationFileContents = new FileOutputStream(tempNativeLibrary);
            byte[] transferBuffer = new byte[4096];
            while ((numBytesRead = fileContents.read(transferBuffer)) > 0) {
                destinationFileContents.write(transferBuffer, 0, numBytesRead);
            }
            fileContents.close();
            destinationFileContents.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.load(tempFileName);
    }

    private final class SerialPortOutputStream
    extends OutputStream {
        @Override
        public final void write(int b) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[]{(byte)(b & 0xFF)};
            if (SerialPort.this.writeBytes(buffer, 1L) < 0) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
        }

        @Override
        public final void write(byte[] b) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[len];
            System.arraycopy(b, off, buffer, 0, len);
            if (SerialPort.this.writeBytes(buffer, len) < 0) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
        }
    }

    private final class SerialPortInputStream
    extends InputStream {
        @Override
        public final int available() throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            return SerialPort.this.bytesAvailable();
        }

        @Override
        public final int read() throws IOException {
            byte[] buffer = new byte[1];
            while (SerialPort.this.isOpened) {
                int bytesRead = SerialPort.this.readBytes(buffer, 1L);
                if (bytesRead > 0) {
                    return buffer[0] & 0xFF;
                }
                try {
                    Thread.sleep(2L);
                }
                catch (Exception exception) {}
            }
            throw new IOException("This port appears to have been shutdown or disconnected.");
        }

        @Override
        public final int read(byte[] b) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            return this.read(b, 0, b.length);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            if (len == 0) {
                return 0;
            }
            byte[] buffer = new byte[len];
            int numRead = SerialPort.this.readBytes(buffer, len);
            if (numRead > 0) {
                System.arraycopy(buffer, 0, b, off, numRead);
            }
            return numRead;
        }

        @Override
        public final long skip(long n) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[(int)n];
            return SerialPort.this.readBytes(buffer, n);
        }
    }

    private final class SerialPortEventListener {
        private volatile boolean isListening = false;
        private final byte[] dataPacket;
        private volatile int dataPacketIndex = 0;
        private Thread serialEventThread = null;

        public SerialPortEventListener(int packetSizeToReceive) {
            this.dataPacket = new byte[packetSizeToReceive];
        }

        public final void startListening() {
            if (this.isListening) {
                return;
            }
            this.isListening = true;
            this.dataPacketIndex = 0;
            this.serialEventThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SerialPortEventListener.this.isListening && SerialPort.this.isOpened) {
                        try {
                            SerialPortEventListener.this.waitForSerialEvent();
                        }
                        catch (NullPointerException e) {
                            SerialPortEventListener.this.isListening = false;
                        }
                    }
                    SerialPortEventListener.this.isListening = false;
                }
            });
            this.serialEventThread.start();
        }

        public final void stopListening() {
            if (!this.isListening) {
                return;
            }
            this.isListening = false;
            try {
                this.serialEventThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.serialEventThread = null;
        }

        public final void waitForSerialEvent() throws NullPointerException {
            switch (SerialPort.this.waitForEvent()) {
                case 1: {
                    if ((SerialPort.this.eventFlags & 0x10) > 0) {
                        int numBytesAvailable;
                        while ((numBytesAvailable = SerialPort.this.bytesAvailable()) > 0) {
                            byte[] newBytes = new byte[numBytesAvailable];
                            int newBytesIndex = 0;
                            int bytesRemaining = SerialPort.this.readBytes(newBytes, newBytes.length);
                            while (bytesRemaining >= this.dataPacket.length - this.dataPacketIndex) {
                                System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, this.dataPacket.length - this.dataPacketIndex);
                                bytesRemaining -= this.dataPacket.length - this.dataPacketIndex;
                                newBytesIndex += this.dataPacket.length - this.dataPacketIndex;
                                this.dataPacketIndex = 0;
                                SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])this.dataPacket.clone()));
                            }
                            if (bytesRemaining <= 0) continue;
                            System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, bytesRemaining);
                            this.dataPacketIndex += bytesRemaining;
                        }
                        break;
                    }
                    if ((SerialPort.this.eventFlags & 1) <= 0) break;
                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 1));
                    break;
                }
                case 256: {
                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 256));
                    break;
                }
            }
        }
    }
}

