/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;

public final class SerialPort {
    private static volatile boolean isAndroid;
    private static volatile boolean isLinuxOrMac;
    private static volatile boolean isWindows;
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    public static final int MARK_PARITY = 3;
    public static final int SPACE_PARITY = 4;
    public static final int ONE_STOP_BIT = 1;
    public static final int ONE_POINT_FIVE_STOP_BITS = 2;
    public static final int TWO_STOP_BITS = 3;
    public static final int FLOW_CONTROL_DISABLED = 0;
    public static final int FLOW_CONTROL_RTS_ENABLED = 1;
    public static final int FLOW_CONTROL_CTS_ENABLED = 16;
    public static final int FLOW_CONTROL_DSR_ENABLED = 256;
    public static final int FLOW_CONTROL_DTR_ENABLED = 4096;
    public static final int FLOW_CONTROL_XONXOFF_IN_ENABLED = 65536;
    public static final int FLOW_CONTROL_XONXOFF_OUT_ENABLED = 0x100000;
    public static final int TIMEOUT_NONBLOCKING = 0;
    public static final int TIMEOUT_READ_SEMI_BLOCKING = 1;
    public static final int TIMEOUT_WRITE_SEMI_BLOCKING = 16;
    public static final int TIMEOUT_READ_BLOCKING = 256;
    public static final int TIMEOUT_WRITE_BLOCKING = 4096;
    public static final int TIMEOUT_SCANNER = 65536;
    public static final int LISTENING_EVENT_DATA_AVAILABLE = 1;
    public static final int LISTENING_EVENT_DATA_RECEIVED = 16;
    public static final int LISTENING_EVENT_DATA_WRITTEN = 256;
    private volatile long portHandle = -1L;
    private volatile int baudRate = 9600;
    private volatile int dataBits = 8;
    private volatile int stopBits = 1;
    private volatile int parity = 0;
    private volatile int eventFlags = 0;
    private volatile int timeoutMode = 0;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile int flowControl = 0;
    private volatile SerialPortInputStream inputStream = null;
    private volatile SerialPortOutputStream outputStream = null;
    private volatile SerialPortDataListener userDataListener = null;
    private volatile SerialPortEventListener serialEventListener = null;
    private volatile String portString;
    private volatile String comPort;
    private volatile boolean isOpened = false;

    private static boolean isSymbolicLink(File file) throws IOException {
        File canonicalFile = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !canonicalFile.getCanonicalFile().equals(canonicalFile.getAbsoluteFile());
    }

    public static native SerialPort[] getCommPorts();

    public static SerialPort getCommPort(String portDescriptor) {
        try {
            if (portDescriptor.startsWith("~" + File.separator)) {
                portDescriptor = System.getProperty("user.home") + portDescriptor.substring(1);
            }
            if (isWindows) {
                portDescriptor = "\\\\.\\" + portDescriptor.substring(portDescriptor.lastIndexOf(92) + 1);
            } else if (SerialPort.isSymbolicLink(new File(portDescriptor))) {
                portDescriptor = new File(portDescriptor).getCanonicalPath();
            } else if (portDescriptor.contains("/pts/")) {
                portDescriptor = "/dev/pts/" + portDescriptor.substring(portDescriptor.lastIndexOf(47) + 1);
            } else if (!new File(portDescriptor).exists()) {
                portDescriptor = "/dev/" + portDescriptor.substring(portDescriptor.lastIndexOf(47) + 1);
            }
        }
        catch (Exception e) {
            SerialPort serialPort = new SerialPort();
            serialPort.comPort = "/dev/null";
            serialPort.portString = "Bad Port";
            return serialPort;
        }
        SerialPort serialPort = new SerialPort();
        serialPort.comPort = portDescriptor;
        serialPort.portString = "User-Specified Port";
        return serialPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean openPort() {
        if (this.isOpened) {
            return true;
        }
        if (isAndroid) {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec("su");
                DataOutputStream writer = new DataOutputStream(process.getOutputStream());
                writer.writeBytes("chmod 666 " + this.comPort + "\n");
                writer.writeBytes("exit\n");
                writer.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while (reader.readLine() != null) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (process == null) {
                    return false;
                }
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.portHandle = this.openPortNative();
        if (this.portHandle > 0L) {
            this.inputStream = new SerialPortInputStream();
            this.outputStream = new SerialPortOutputStream();
            if (this.serialEventListener != null) {
                this.serialEventListener.startListening();
            }
        }
        return this.isOpened;
    }

    public final boolean closePort() {
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
        }
        if (this.isOpened && this.closePortNative(this.portHandle)) {
            this.inputStream = null;
            this.outputStream = null;
            this.portHandle = -1L;
        }
        return !this.isOpened;
    }

    public final boolean isOpen() {
        return this.isOpened;
    }

    private static native void initializeLibrary();

    private static native void uninitializeLibrary();

    private final native long openPortNative();

    private final native boolean closePortNative(long var1);

    private final native boolean configPort(long var1);

    private final native boolean configFlowControl(long var1);

    private final native boolean configTimeouts(long var1);

    private final native boolean configEventFlags(long var1);

    private final native int waitForEvent(long var1);

    private final native int bytesAvailable(long var1);

    private final native int readBytes(long var1, byte[] var3, long var4);

    private final native int writeBytes(long var1, byte[] var3, long var4);

    public final int bytesAvailable() {
        return this.bytesAvailable(this.portHandle);
    }

    public final int readBytes(byte[] buffer, long bytesToRead) {
        return this.readBytes(this.portHandle, buffer, bytesToRead);
    }

    public final int writeBytes(byte[] buffer, long bytesToWrite) {
        return this.writeBytes(this.portHandle, buffer, bytesToWrite);
    }

    private SerialPort() {
    }

    public final boolean addDataListener(SerialPortDataListener listener) {
        if (this.userDataListener != null) {
            return false;
        }
        this.userDataListener = listener;
        this.serialEventListener = new SerialPortEventListener(this.userDataListener instanceof SerialPortPacketListener ? ((SerialPortPacketListener)this.userDataListener).getPacketSize() : 0);
        this.eventFlags = 0;
        if ((listener.getListeningEvents() & 1) > 0) {
            this.eventFlags |= 1;
        }
        if ((listener.getListeningEvents() & 0x10) > 0) {
            this.eventFlags |= 0x10;
        }
        if ((listener.getListeningEvents() & 0x100) > 0) {
            this.eventFlags |= 0x100;
        }
        if (this.isOpened) {
            this.configEventFlags(this.portHandle);
            this.serialEventListener.startListening();
        }
        return true;
    }

    public final void removeDataListener() {
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
            this.serialEventListener = null;
        }
        this.userDataListener = null;
        this.eventFlags = 0;
        if (this.isOpened) {
            this.configEventFlags(this.portHandle);
        }
    }

    public final InputStream getInputStream() {
        return this.inputStream;
    }

    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final void setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity) {
        this.baudRate = newBaudRate;
        this.dataBits = newDataBits;
        this.stopBits = newStopBits;
        this.parity = newParity;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        this.timeoutMode = newTimeoutMode;
        if (isWindows) {
            this.readTimeout = newReadTimeout;
            this.writeTimeout = newWriteTimeout;
        } else {
            this.readTimeout = Math.round((float)newReadTimeout / 100.0f) * 100;
        }
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configTimeouts(this.portHandle);
        }
    }

    public final void setBaudRate(int newBaudRate) {
        this.baudRate = newBaudRate;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setNumDataBits(int newDataBits) {
        this.dataBits = newDataBits;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setNumStopBits(int newStopBits) {
        this.stopBits = newStopBits;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setFlowControl(int newFlowControlSettings) {
        this.flowControl = newFlowControlSettings;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configFlowControl(this.portHandle);
        }
    }

    public final void setParity(int newParity) {
        this.parity = newParity;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final String getDescriptivePortName() {
        return this.portString.trim();
    }

    public final String getSystemPortName() {
        return isWindows ? this.comPort.substring(this.comPort.lastIndexOf(92) + 1) : this.comPort.substring(this.comPort.lastIndexOf(47) + 1);
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final int getNumDataBits() {
        return this.dataBits;
    }

    public final int getNumStopBits() {
        return this.stopBits;
    }

    public final int getParity() {
        return this.parity;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final int getFlowControlSettings() {
        return this.flowControl;
    }

    static {
        String line;
        File directory;
        isAndroid = false;
        isLinuxOrMac = false;
        isWindows = false;
        String OS = System.getProperty("os.name").toLowerCase();
        String libraryPath = "";
        String fileName = "";
        String tempFileDirectory = System.getProperty("java.io.tmpdir");
        if (tempFileDirectory.charAt(tempFileDirectory.length() - 1) != '\\' && tempFileDirectory.charAt(tempFileDirectory.length() - 1) != '/') {
            tempFileDirectory = tempFileDirectory + "/";
        }
        if ((directory = new File(tempFileDirectory)).exists()) {
            File[] directoryListing;
            for (File listing : directoryListing = directory.listFiles()) {
                if (!listing.isFile() || !listing.toString().contains("jSerialComm")) continue;
                listing.delete();
            }
        }
        if (System.getProperty("java.vm.vendor").toLowerCase().contains("android")) {
            try {
                BufferedReader buildPropertiesFile = new BufferedReader(new FileReader("/system/build.prop"));
                while ((line = buildPropertiesFile.readLine()) != null) {
                    if (line.contains("#") || !line.contains("ro.product.cpu.abi") && !line.contains("ro.product.cpu.abi2") && !line.contains("ro.product.cpu.abilist") && !line.contains("ro.product.cpu.abilist64") && !line.contains("ro.product.cpu.abilist32")) continue;
                    libraryPath = line.indexOf(44) == -1 ? "Android/" + line.substring(line.indexOf(61) + 1) : "Android/" + line.substring(line.indexOf(61) + 1, line.indexOf(44));
                    break;
                }
                buildPropertiesFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (libraryPath.isEmpty()) {
                libraryPath = "Android/armeabi";
            }
            isAndroid = true;
            fileName = "libjSerialComm.so";
        } else if (OS.indexOf("win") >= 0) {
            libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? "Windows/x86_64" : "Windows/x86";
            isWindows = true;
            fileName = "jSerialComm.dll";
        } else if (OS.indexOf("mac") >= 0) {
            libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? "OSX/x86_64" : "OSX/x86";
            isLinuxOrMac = true;
            fileName = "libjSerialComm.jnilib";
        } else if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0) {
            if (System.getProperty("os.arch").indexOf("arm") >= 0) {
                File linkerFile;
                try {
                    BufferedReader cpuPropertiesFile = new BufferedReader(new FileReader("/proc/cpuinfo"));
                    while ((line = cpuPropertiesFile.readLine()) != null) {
                        if (!line.contains("ARMv")) continue;
                        libraryPath = "Linux/armv" + line.substring(line.indexOf("ARMv") + 4, line.indexOf("ARMv") + 5);
                        break;
                    }
                    cpuPropertiesFile.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (libraryPath.isEmpty()) {
                    libraryPath = "Linux/armv6";
                }
                if ((linkerFile = new File("/lib/ld-linux-armhf.so.3")).exists()) {
                    libraryPath = libraryPath + "-hf";
                }
            } else {
                libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? "Linux/x86_64" : "Linux/x86";
            }
            isLinuxOrMac = true;
            fileName = "libjSerialComm.so";
        } else {
            System.err.println("This operating system is not supported by the jSerialComm library.");
            System.exit(-1);
        }
        String tempFileName = tempFileDirectory + new Date().getTime() + "-" + fileName;
        File tempNativeLibrary = new File(tempFileName);
        tempNativeLibrary.deleteOnExit();
        try {
            int numBytesRead;
            InputStream fileContents = SerialPort.class.getResourceAsStream("/" + libraryPath + "/" + fileName);
            FileOutputStream destinationFileContents = new FileOutputStream(tempNativeLibrary);
            byte[] transferBuffer = new byte[4096];
            while ((numBytesRead = fileContents.read(transferBuffer)) > 0) {
                destinationFileContents.write(transferBuffer, 0, numBytesRead);
            }
            fileContents.close();
            destinationFileContents.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.load(tempFileName);
        SerialPort.initializeLibrary();
    }

    private final class SerialPortOutputStream
    extends OutputStream {
        @Override
        public final void write(int b) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[]{(byte)(b & 0xFF)};
            if (SerialPort.this.writeBytes(SerialPort.this.portHandle, buffer, 1L) < 0) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
        }

        @Override
        public final void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[len];
            System.arraycopy(b, off, buffer, 0, len);
            if (SerialPort.this.writeBytes(SerialPort.this.portHandle, buffer, len) < 0) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
        }
    }

    private final class SerialPortInputStream
    extends InputStream {
        @Override
        public final int available() throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            return SerialPort.this.bytesAvailable(SerialPort.this.portHandle);
        }

        @Override
        public final int read() throws IOException {
            byte[] buffer = new byte[1];
            while (SerialPort.this.isOpened) {
                int bytesRead = SerialPort.this.readBytes(SerialPort.this.portHandle, buffer, 1L);
                if (bytesRead > 0) {
                    return buffer[0] & 0xFF;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
            throw new IOException("This port appears to have been shutdown or disconnected.");
        }

        @Override
        public final int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            if (len == 0) {
                return 0;
            }
            byte[] buffer = new byte[len];
            int numRead = SerialPort.this.readBytes(SerialPort.this.portHandle, buffer, len);
            if (numRead > 0) {
                System.arraycopy(buffer, 0, b, off, numRead);
            }
            return numRead;
        }

        @Override
        public final long skip(long n) throws IOException {
            if (!SerialPort.this.isOpened) {
                throw new IOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[(int)n];
            return SerialPort.this.readBytes(SerialPort.this.portHandle, buffer, n);
        }
    }

    private final class SerialPortEventListener {
        private volatile boolean isListening = false;
        private final byte[] dataPacket;
        private volatile int dataPacketIndex = 0;
        private Thread serialEventThread = null;

        public SerialPortEventListener(int packetSizeToReceive) {
            this.dataPacket = new byte[packetSizeToReceive];
        }

        public final void startListening() {
            if (this.isListening) {
                return;
            }
            this.isListening = true;
            this.dataPacketIndex = 0;
            this.serialEventThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SerialPortEventListener.this.isListening && SerialPort.this.isOpened) {
                        try {
                            SerialPortEventListener.this.waitForSerialEvent();
                        }
                        catch (NullPointerException e) {
                            SerialPortEventListener.this.isListening = false;
                        }
                    }
                    SerialPortEventListener.this.isListening = false;
                }
            });
            this.serialEventThread.start();
        }

        public final void stopListening() {
            if (!this.isListening) {
                return;
            }
            this.isListening = false;
            int oldEventFlags = SerialPort.this.eventFlags;
            SerialPort.this.eventFlags = 0;
            SerialPort.this.configEventFlags(SerialPort.this.portHandle);
            try {
                this.serialEventThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.serialEventThread = null;
            SerialPort.this.eventFlags = oldEventFlags;
        }

        public final void waitForSerialEvent() throws NullPointerException {
            switch (SerialPort.this.waitForEvent(SerialPort.this.portHandle)) {
                case 1: {
                    if ((SerialPort.this.eventFlags & 0x10) > 0) {
                        int numBytesAvailable;
                        while ((numBytesAvailable = SerialPort.this.bytesAvailable(SerialPort.this.portHandle)) > 0) {
                            byte[] newBytes = new byte[numBytesAvailable];
                            int newBytesIndex = 0;
                            int bytesRemaining = SerialPort.this.readBytes(SerialPort.this.portHandle, newBytes, newBytes.length);
                            while (bytesRemaining >= this.dataPacket.length - this.dataPacketIndex) {
                                System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, this.dataPacket.length - this.dataPacketIndex);
                                bytesRemaining -= this.dataPacket.length - this.dataPacketIndex;
                                newBytesIndex += this.dataPacket.length - this.dataPacketIndex;
                                this.dataPacketIndex = 0;
                                SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])this.dataPacket.clone()));
                            }
                            if (bytesRemaining <= 0) continue;
                            System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, bytesRemaining);
                            this.dataPacketIndex += bytesRemaining;
                        }
                        break;
                    }
                    if ((SerialPort.this.eventFlags & 1) <= 0) break;
                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 1));
                    break;
                }
                case 256: {
                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 256));
                    break;
                }
            }
        }
    }
}

