/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortDataListenerWithExceptions;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortIOException;
import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import com.fazecast.jSerialComm.SerialPortMessageListenerWithExceptions;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import com.fazecast.jSerialComm.SerialPortThreadFactory;
import com.fazecast.jSerialComm.SerialPortTimeoutException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

public class SerialPort {
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    public static final int MARK_PARITY = 3;
    public static final int SPACE_PARITY = 4;
    public static final int ONE_STOP_BIT = 1;
    public static final int ONE_POINT_FIVE_STOP_BITS = 2;
    public static final int TWO_STOP_BITS = 3;
    public static final int FLOW_CONTROL_DISABLED = 0;
    public static final int FLOW_CONTROL_RTS_ENABLED = 1;
    public static final int FLOW_CONTROL_CTS_ENABLED = 16;
    public static final int FLOW_CONTROL_DSR_ENABLED = 256;
    public static final int FLOW_CONTROL_DTR_ENABLED = 4096;
    public static final int FLOW_CONTROL_XONXOFF_IN_ENABLED = 65536;
    public static final int FLOW_CONTROL_XONXOFF_OUT_ENABLED = 0x100000;
    public static final int TIMEOUT_NONBLOCKING = 0;
    public static final int TIMEOUT_READ_SEMI_BLOCKING = 1;
    public static final int TIMEOUT_READ_BLOCKING = 16;
    public static final int TIMEOUT_WRITE_BLOCKING = 256;
    public static final int TIMEOUT_SCANNER = 4096;
    public static final int LISTENING_EVENT_TIMED_OUT = 0;
    public static final int LISTENING_EVENT_DATA_AVAILABLE = 1;
    public static final int LISTENING_EVENT_DATA_RECEIVED = 16;
    public static final int LISTENING_EVENT_DATA_WRITTEN = 256;
    public static final int LISTENING_EVENT_BREAK_INTERRUPT = 65536;
    public static final int LISTENING_EVENT_CARRIER_DETECT = 131072;
    public static final int LISTENING_EVENT_CTS = 262144;
    public static final int LISTENING_EVENT_DSR = 524288;
    public static final int LISTENING_EVENT_RING_INDICATOR = 0x100000;
    public static final int LISTENING_EVENT_FRAMING_ERROR = 0x200000;
    public static final int LISTENING_EVENT_FIRMWARE_OVERRUN_ERROR = 0x400000;
    public static final int LISTENING_EVENT_SOFTWARE_OVERRUN_ERROR = 0x800000;
    public static final int LISTENING_EVENT_PARITY_ERROR = 0x1000000;
    public static final int LISTENING_EVENT_PORT_DISCONNECTED = 0x10000000;
    private static final ReentrantLock lock = new ReentrantLock(true);
    private static final String versionString = "2.10.0";
    private static final String tmpdirAppIdProperty = "fazecast.jSerialComm.appid";
    private static final List<Thread> shutdownHooks = new ArrayList<Thread>();
    private static boolean isWindows = false;
    private static boolean isAndroid = false;
    private static volatile boolean isShuttingDown = false;
    private volatile long portHandle = 0L;
    private volatile int baudRate = 9600;
    private volatile int dataBits = 8;
    private volatile int stopBits = 1;
    private volatile int parity = 0;
    private volatile int eventFlags = 0;
    private volatile int timeoutMode = 0;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile int flowControl = 0;
    private volatile int sendDeviceQueueSize = 4096;
    private volatile int receiveDeviceQueueSize = 4096;
    private volatile int vendorID;
    private volatile int productID;
    private volatile int safetySleepTimeMS = 200;
    private volatile int rs485DelayBefore = 0;
    private volatile int rs485DelayAfter = 0;
    private volatile byte xonStartChar = (byte)17;
    private volatile byte xoffStopChar = (byte)19;
    private volatile SerialPortDataListener userDataListener = null;
    private volatile SerialPortEventListener serialEventListener = null;
    private volatile String comPort;
    private volatile String friendlyName;
    private volatile String portDescription;
    private volatile String portLocation;
    private volatile String serialNumber;
    private volatile boolean eventListenerRunning = false;
    private volatile boolean disableConfig = false;
    private volatile boolean disableExclusiveLock = false;
    private volatile boolean rs485Mode = false;
    private volatile boolean rs485ActiveHigh = true;
    private volatile boolean rs485RxDuringTx = false;
    private volatile boolean rs485EnableTermination = false;
    private volatile boolean isRtsEnabled = true;
    private volatile boolean isDtrEnabled = true;
    private volatile boolean autoFlushIOBuffers = false;
    private volatile boolean requestElevatedPermissions = false;

    private static boolean isSymbolicLink(File file) throws IOException {
        File canonicalFile = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !canonicalFile.getCanonicalFile().equals(canonicalFile.getAbsoluteFile());
    }

    private static void cleanUpDirectory(File path) {
        File[] files;
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            for (File file : files) {
                if (file.getName().equals(versionString)) continue;
                SerialPort.cleanUpDirectory(file);
            }
        }
        if (!path.getName().equals(versionString)) {
            path.delete();
        }
    }

    private static boolean loadNativeLibrary(String absoluteLibraryPath, Vector<String> errorMessages) {
        try {
            System.load(absoluteLibraryPath);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            errorMessages.add(e.getMessage());
            return false;
        }
        catch (Exception e) {
            errorMessages.add(e.getMessage());
            return false;
        }
    }

    public final String toString() {
        return this.getPortDescription();
    }

    public static String getVersion() {
        return versionString;
    }

    public static void addShutdownHook(Thread hook) {
        lock.lock();
        try {
            shutdownHooks.add(hook);
        }
        finally {
            lock.unlock();
        }
    }

    public static SerialPort[] getCommPorts() {
        lock.lock();
        try {
            SerialPort[] serialPortArray = SerialPort.getCommPortsNative();
            return serialPortArray;
        }
        finally {
            lock.unlock();
        }
    }

    public static SerialPort getCommPort(String portDescriptor) throws SerialPortInvalidPortException {
        lock.lock();
        try {
            if (portDescriptor.startsWith("~" + File.separator)) {
                portDescriptor = System.getProperty("user.home") + portDescriptor.substring(1);
            }
            if (isWindows) {
                portDescriptor = "\\\\.\\" + portDescriptor.substring(portDescriptor.lastIndexOf(92) + 1);
            } else if (SerialPort.isSymbolicLink(new File(portDescriptor))) {
                portDescriptor = new File(portDescriptor).getCanonicalPath();
            } else if (!new File(portDescriptor).exists()) {
                portDescriptor = "/dev/" + portDescriptor;
                if (!new File(portDescriptor).exists()) {
                    portDescriptor = "/dev/" + portDescriptor.substring(portDescriptor.lastIndexOf(47) + 1);
                }
                if (!new File(portDescriptor).exists()) {
                    throw new IOException();
                }
            }
            SerialPort serialPort = new SerialPort();
            serialPort.comPort = portDescriptor;
            serialPort.productID = -1;
            serialPort.vendorID = -1;
            serialPort.friendlyName = "User-Specified Port";
            serialPort.portDescription = "User-Specified Port";
            serialPort.serialNumber = "Unknown";
            serialPort.portLocation = "0-0";
            serialPort.retrievePortDetails();
            SerialPort serialPort2 = serialPort;
            return serialPort2;
        }
        catch (Exception e) {
            throw new SerialPortInvalidPortException("Unable to create a serial port object from the invalid port descriptor: " + portDescriptor, e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public final boolean openPort(int safetySleepTime, int deviceSendQueueSize, int deviceReceiveQueueSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean openPort(int safetySleepTime) {
        lock.lock();
        try {
            boolean bl = this.openPort(safetySleepTime, this.sendDeviceQueueSize, this.receiveDeviceQueueSize);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean openPort() {
        lock.lock();
        try {
            boolean bl = this.openPort(0);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean closePort() {
        lock.lock();
        try {
            if (this.serialEventListener != null) {
                this.serialEventListener.stopListening();
            }
            if (this.portHandle != 0L) {
                this.portHandle = this.closePortNative(this.portHandle);
            }
            boolean bl = this.portHandle == 0L;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean isOpen() {
        lock.lock();
        try {
            boolean bl = this.portHandle != 0L;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final void disablePortConfiguration() {
        lock.lock();
        try {
            this.disableConfig = true;
        }
        finally {
            lock.unlock();
        }
    }

    public final void disableExclusiveLock() {
        lock.lock();
        try {
            this.disableExclusiveLock = true;
        }
        finally {
            lock.unlock();
        }
    }

    public final void allowElevatedPermissionsRequest() {
        lock.lock();
        try {
            this.requestElevatedPermissions = true;
        }
        finally {
            lock.unlock();
        }
    }

    public final int getLastErrorLocation() {
        lock.lock();
        try {
            int n = this.getLastErrorLocation(this.portHandle);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public final int getLastErrorCode() {
        lock.lock();
        try {
            int n = this.getLastErrorCode(this.portHandle);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private static native void uninitializeLibrary();

    private static native SerialPort[] getCommPortsNative();

    private native void retrievePortDetails();

    private native long openPortNative();

    private native long closePortNative(long var1);

    private native boolean configPort(long var1);

    private native boolean flushRxTxBuffers(long var1);

    private native int waitForEvent(long var1);

    private native int bytesAvailable(long var1);

    private native int bytesAwaitingWrite(long var1);

    private native int readBytes(long var1, byte[] var3, int var4, int var5, int var6, int var7);

    private native int writeBytes(long var1, byte[] var3, int var4, int var5, int var6);

    private native void setEventListeningStatus(long var1, boolean var3);

    private native boolean setBreak(long var1);

    private native boolean clearBreak(long var1);

    private native boolean setRTS(long var1);

    private native boolean clearRTS(long var1);

    private native boolean setDTR(long var1);

    private native boolean clearDTR(long var1);

    private native boolean getCTS(long var1);

    private native boolean getDSR(long var1);

    private native boolean getDCD(long var1);

    private native boolean getDTR(long var1);

    private native boolean getRTS(long var1);

    private native boolean getRI(long var1);

    private native int getLastErrorLocation(long var1);

    private native int getLastErrorCode(long var1);

    public final int bytesAvailable() {
        return this.portHandle != 0L ? this.bytesAvailable(this.portHandle) : -1;
    }

    public final int bytesAwaitingWrite() {
        return this.portHandle != 0L ? this.bytesAwaitingWrite(this.portHandle) : -1;
    }

    public final int readBytes(byte[] buffer, int bytesToRead) {
        return this.portHandle != 0L ? this.readBytes(this.portHandle, buffer, bytesToRead, 0, this.timeoutMode, this.readTimeout) : -1;
    }

    public final int readBytes(byte[] buffer, int bytesToRead, int offset) {
        return this.portHandle != 0L ? this.readBytes(this.portHandle, buffer, bytesToRead, offset, this.timeoutMode, this.readTimeout) : -1;
    }

    public final int writeBytes(byte[] buffer, int bytesToWrite) {
        int totalNumWritten;
        int numWritten;
        for (totalNumWritten = 0; this.portHandle != 0L && totalNumWritten != bytesToWrite && (numWritten = this.writeBytes(this.portHandle, buffer, bytesToWrite - totalNumWritten, totalNumWritten, this.timeoutMode)) > 0; totalNumWritten += numWritten) {
        }
        return this.portHandle != 0L && totalNumWritten >= 0 ? totalNumWritten : -1;
    }

    public final int writeBytes(byte[] buffer, int bytesToWrite, int offset) {
        int totalNumWritten;
        int numWritten;
        for (totalNumWritten = 0; this.portHandle != 0L && totalNumWritten != bytesToWrite && (numWritten = this.writeBytes(this.portHandle, buffer, bytesToWrite - totalNumWritten, offset + totalNumWritten, this.timeoutMode)) > 0; totalNumWritten += numWritten) {
        }
        return this.portHandle != 0L && totalNumWritten >= 0 ? totalNumWritten : -1;
    }

    public final int getDeviceWriteBufferSize() {
        return this.sendDeviceQueueSize;
    }

    public final int getDeviceReadBufferSize() {
        return this.receiveDeviceQueueSize;
    }

    public final boolean setBreak() {
        return this.portHandle != 0L && this.setBreak(this.portHandle);
    }

    public final boolean clearBreak() {
        return this.portHandle != 0L && this.clearBreak(this.portHandle);
    }

    public final boolean setRTS() {
        this.isRtsEnabled = true;
        return this.portHandle != 0L ? this.setRTS(this.portHandle) : true;
    }

    public final boolean clearRTS() {
        this.isRtsEnabled = false;
        return this.portHandle != 0L ? this.clearRTS(this.portHandle) : true;
    }

    public final boolean setDTR() {
        this.isDtrEnabled = true;
        return this.portHandle != 0L ? this.setDTR(this.portHandle) : true;
    }

    public final boolean clearDTR() {
        this.isDtrEnabled = false;
        return this.portHandle != 0L ? this.clearDTR(this.portHandle) : true;
    }

    public final boolean getCTS() {
        return this.portHandle != 0L && this.getCTS(this.portHandle);
    }

    public final boolean getDSR() {
        return this.portHandle != 0L && this.getDSR(this.portHandle);
    }

    public final boolean getDCD() {
        return this.portHandle != 0L && this.getDCD(this.portHandle);
    }

    public final boolean getDTR() {
        return this.portHandle != 0L && this.getDTR(this.portHandle);
    }

    public final boolean getRTS() {
        return this.portHandle != 0L && this.getRTS(this.portHandle);
    }

    public final boolean getRI() {
        return this.portHandle != 0L && this.getRI(this.portHandle);
    }

    private SerialPort() {
    }

    public final boolean addDataListener(SerialPortDataListener listener) {
        lock.lock();
        try {
            if (this.userDataListener != null) {
                boolean bl = false;
                return bl;
            }
            this.userDataListener = listener;
            this.eventFlags = listener.getListeningEvents();
            if ((this.eventFlags & 0x10) > 0) {
                this.eventFlags |= 1;
            }
            SerialPortEventListener serialPortEventListener = this.userDataListener instanceof SerialPortPacketListener ? new SerialPortEventListener(((SerialPortPacketListener)this.userDataListener).getPacketSize()) : (this.serialEventListener = this.userDataListener instanceof SerialPortMessageListener ? new SerialPortEventListener(((SerialPortMessageListener)this.userDataListener).getMessageDelimiter(), ((SerialPortMessageListener)this.userDataListener).delimiterIndicatesEndOfMessage()) : new SerialPortEventListener());
            if (this.portHandle != 0L) {
                this.configPort(this.portHandle);
                this.serialEventListener.startListening();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final void flushDataListener() {
        lock.lock();
        try {
            if (this.serialEventListener != null) {
                this.serialEventListener.resetBuffers();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public final void removeDataListener() {
        lock.lock();
        try {
            this.eventFlags = 0;
            if (this.serialEventListener != null) {
                this.serialEventListener.stopListening();
                this.serialEventListener = null;
                if (this.portHandle != 0L) {
                    this.configPort(this.portHandle);
                }
            }
            this.userDataListener = null;
        }
        finally {
            lock.unlock();
        }
    }

    public final InputStream getInputStream() {
        return new SerialPortInputStream(false);
    }

    public final InputStream getInputStreamWithSuppressedTimeoutExceptions() {
        return new SerialPortInputStream(true);
    }

    public final OutputStream getOutputStream() {
        return new SerialPortOutputStream();
    }

    public final boolean flushIOBuffers() {
        lock.lock();
        try {
            this.autoFlushIOBuffers = true;
            if (this.portHandle != 0L) {
                boolean bl = this.flushRxTxBuffers(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity) {
        return this.setComPortParameters(newBaudRate, newDataBits, newStopBits, newParity, this.rs485Mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity, boolean useRS485Mode) {
        lock.lock();
        try {
            this.baudRate = newBaudRate;
            this.dataBits = newDataBits;
            this.stopBits = newStopBits;
            this.parity = newParity;
            this.rs485Mode = useRS485Mode;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        lock.lock();
        try {
            this.timeoutMode = newTimeoutMode;
            if (isWindows) {
                this.readTimeout = newReadTimeout;
                this.writeTimeout = newWriteTimeout;
            } else {
                this.readTimeout = newReadTimeout > 0 && newReadTimeout <= 100 ? 100 : Math.round((float)newReadTimeout / 100.0f) * 100;
            }
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean setBaudRate(int newBaudRate) {
        lock.lock();
        try {
            this.baudRate = newBaudRate;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean setNumDataBits(int newDataBits) {
        lock.lock();
        try {
            this.dataBits = newDataBits;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean setNumStopBits(int newStopBits) {
        lock.lock();
        try {
            this.stopBits = newStopBits;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean setFlowControl(int newFlowControlSettings) {
        lock.lock();
        try {
            this.flowControl = newFlowControlSettings;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean setParity(int newParity) {
        lock.lock();
        try {
            this.parity = newParity;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setRs485ModeParameters(boolean useRS485Mode, boolean rs485RtsActiveHigh, int delayBeforeSendMicroseconds, int delayAfterSendMicroseconds) {
        lock.lock();
        try {
            boolean bl = this.setRs485ModeParameters(useRS485Mode, rs485RtsActiveHigh, false, false, delayBeforeSendMicroseconds, delayAfterSendMicroseconds);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setRs485ModeParameters(boolean useRS485Mode, boolean rs485RtsActiveHigh, boolean enableTermination, boolean rxDuringTx, int delayBeforeSendMicroseconds, int delayAfterSendMicroseconds) {
        lock.lock();
        try {
            this.rs485Mode = useRS485Mode;
            this.rs485ActiveHigh = rs485RtsActiveHigh;
            this.rs485EnableTermination = enableTermination;
            this.rs485RxDuringTx = rxDuringTx;
            this.rs485DelayBefore = delayBeforeSendMicroseconds;
            this.rs485DelayAfter = delayAfterSendMicroseconds;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setXonXoffCharacters(byte xonStartCharacter, byte xoffStopCharacter) {
        lock.lock();
        try {
            this.xonStartChar = xonStartCharacter;
            this.xoffStopChar = xoffStopCharacter;
            if (this.portHandle != 0L) {
                if (this.safetySleepTimeMS > 0) {
                    try {
                        Thread.sleep(this.safetySleepTimeMS);
                    }
                    catch (Exception e) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean bl = this.configPort(this.portHandle);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public final String getDescriptivePortName() {
        return this.friendlyName.trim();
    }

    public final String getSystemPortName() {
        return isWindows ? this.comPort.substring(this.comPort.lastIndexOf(92) + 1) : this.comPort.substring(this.comPort.lastIndexOf(47) + 1);
    }

    public final String getSystemPortPath() {
        return this.comPort;
    }

    public final String getPortDescription() {
        return this.portDescription.trim();
    }

    public final String getPortLocation() {
        return this.portLocation;
    }

    public final int getVendorID() {
        return this.vendorID;
    }

    public final int getProductID() {
        return this.productID;
    }

    public final String getSerialNumber() {
        return this.serialNumber;
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final int getNumDataBits() {
        return this.dataBits;
    }

    public final int getNumStopBits() {
        return this.stopBits;
    }

    public final int getParity() {
        return this.parity;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final int getFlowControlSettings() {
        return this.flowControl;
    }

    static {
        String[] architectures = null;
        String libraryPath = "";
        String libraryFileName = "";
        String OS = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        String manualLibraryPath = System.getProperty("jSerialComm.library.path", "");
        String tempFileDirectory = System.getProperty("java.io.tmpdir");
        String userHomeDirectory = System.getProperty("user.home");
        if (!tempFileDirectory.endsWith("\\") && !tempFileDirectory.endsWith("/")) {
            tempFileDirectory = tempFileDirectory + File.separator;
        }
        if (!userHomeDirectory.endsWith("\\") && !userHomeDirectory.endsWith("/")) {
            userHomeDirectory = userHomeDirectory + File.separator;
        }
        if (!(manualLibraryPath.isEmpty() || manualLibraryPath.endsWith("\\") || manualLibraryPath.endsWith("/"))) {
            manualLibraryPath = manualLibraryPath + File.separator;
        }
        tempFileDirectory = tempFileDirectory + "jSerialComm" + File.separator + System.getProperty(tmpdirAppIdProperty, "");
        userHomeDirectory = userHomeDirectory + ".jSerialComm" + File.separator + System.getProperty(tmpdirAppIdProperty, "");
        if (!tempFileDirectory.endsWith("\\") && !tempFileDirectory.endsWith("/")) {
            tempFileDirectory = tempFileDirectory + File.separator;
        }
        if (!userHomeDirectory.endsWith("\\") && !userHomeDirectory.endsWith("/")) {
            userHomeDirectory = userHomeDirectory + File.separator;
        }
        SerialPort.cleanUpDirectory(new File(tempFileDirectory));
        SerialPort.cleanUpDirectory(new File(userHomeDirectory));
        tempFileDirectory = tempFileDirectory + versionString + File.separator;
        userHomeDirectory = userHomeDirectory + versionString + File.separator;
        if (System.getProperty("java.vm.vendor").toLowerCase().contains("android")) {
            isAndroid = true;
            libraryPath = "Android";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"arm64-v8a", "armeabi-v7a", "x86_64", "x86"};
        } else if (OS.contains("win")) {
            isWindows = true;
            libraryPath = "Windows";
            libraryFileName = "jSerialComm.dll";
            architectures = new String[]{"aarch64", "armv7", "x86_64", "x86"};
        } else if (OS.contains("mac")) {
            libraryPath = "OSX";
            libraryFileName = "libjSerialComm.jnilib";
            architectures = new String[]{"aarch64", "x86_64", "x86"};
        } else if (OS.contains("sunos") || OS.contains("solaris")) {
            libraryPath = "Solaris";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"sparcv9_64", "sparcv8plus_32", "x86_64", "x86"};
        } else if (OS.contains("freebsd")) {
            libraryPath = "FreeBSD";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"arm64", "x86_64", "x86"};
        } else if (OS.contains("openbsd")) {
            libraryPath = "OpenBSD";
            libraryFileName = "libjSerialComm.so";
            architectures = new String[]{"amd64", "x86"};
        } else if (OS.contains("nix") || OS.contains("nux")) {
            libraryPath = "Linux";
            libraryFileName = "libjSerialComm.so";
            architectures = !System.getProperty("os.arch_full", "").isEmpty() ? new String[]{System.getProperty("os.arch_full").toLowerCase()} : (arch.contains("86") || arch.contains("amd") ? new String[]{"x86_64", "x86", "armv5", "armv6", "armv6hf", "armv7", "armv7hf", "armv8_64", "armv8_32", "ppc64le"} : new String[]{"armv5", "armv6", "armv6hf", "armv7", "armv7hf", "armv8_64", "x86_64", "armv8_32", "ppc64le", "x86"});
        } else {
            System.err.println("This operating system is not supported by the jSerialComm library.");
            System.exit(-1);
        }
        boolean libraryLoaded = false;
        Vector<String> errorMessages = new Vector<String>();
        if (!manualLibraryPath.isEmpty()) {
            for (int i = 0; !libraryLoaded && i < architectures.length; ++i) {
                libraryLoaded = SerialPort.loadNativeLibrary(new File(manualLibraryPath + libraryPath + File.separator + architectures[i] + File.separator + libraryFileName).getAbsolutePath(), errorMessages);
            }
            if (!libraryLoaded) {
                libraryLoaded = SerialPort.loadNativeLibrary(new File(manualLibraryPath + libraryFileName).getAbsolutePath(), errorMessages);
            }
        }
        for (int attempt = 0; !libraryLoaded && attempt < 2; ++attempt) {
            File nativeLibrary = new File((attempt == 0 ? tempFileDirectory : userHomeDirectory) + libraryFileName);
            libraryLoaded = nativeLibrary.exists() && SerialPort.loadNativeLibrary(nativeLibrary.getAbsolutePath(), errorMessages);
        }
        String attempt1Library = "";
        for (int attempt = 0; !libraryLoaded && attempt < 2; ++attempt) {
            File tempNativeLibrary = new File((attempt == 0 ? tempFileDirectory : userHomeDirectory) + libraryFileName);
            if (attempt == 0) {
                attempt1Library = tempNativeLibrary.getAbsolutePath();
            }
            if (!tempNativeLibrary.getParentFile().exists() && !tempNativeLibrary.getParentFile().mkdirs()) continue;
            tempNativeLibrary.getParentFile().setReadable(true, false);
            tempNativeLibrary.getParentFile().setWritable(true, true);
            tempNativeLibrary.getParentFile().setExecutable(true, false);
            for (int i = 0; !libraryLoaded && i < architectures.length; ++i) {
                InputStream fileContents = SerialPort.class.getResourceAsStream("/" + libraryPath + "/" + architectures[i] + "/" + libraryFileName);
                if (fileContents == null) continue;
                try {
                    int numBytesRead;
                    tempNativeLibrary.delete();
                    FileOutputStream destinationFileContents = new FileOutputStream(tempNativeLibrary);
                    byte[] transferBuffer = new byte[4096];
                    while ((numBytesRead = fileContents.read(transferBuffer)) > 0) {
                        destinationFileContents.write(transferBuffer, 0, numBytesRead);
                    }
                    destinationFileContents.close();
                    fileContents.close();
                    tempNativeLibrary.setReadable(true, false);
                    tempNativeLibrary.setWritable(false, false);
                    tempNativeLibrary.setExecutable(true, false);
                    errorMessages.add("Loading for arch: " + architectures[i]);
                    libraryLoaded = SerialPort.loadNativeLibrary(tempNativeLibrary.getAbsolutePath(), errorMessages);
                    if (!libraryLoaded) continue;
                    errorMessages.add("Successfully loaded!");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (libraryLoaded) continue;
            tempNativeLibrary.delete();
            if (attempt <= 0) continue;
            StringBuilder errorMessage = new StringBuilder("Cannot load native library. Errors as follows:\n");
            for (int i = 0; i < errorMessages.size(); ++i) {
                errorMessage.append('[').append(i + 1).append("]: ").append(errorMessages.get(i)).append('\n');
            }
            throw new UnsatisfiedLinkError(errorMessage.toString());
        }
        Runtime.getRuntime().addShutdownHook(SerialPortThreadFactory.get().newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Thread hook : shutdownHooks) {
                        hook.start();
                        hook.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                isShuttingDown = true;
                SerialPort.uninitializeLibrary();
            }
        }));
    }

    private final class SerialPortOutputStream
    extends OutputStream {
        private final byte[] byteBuffer = new byte[1];

        @Override
        public final void write(int b) throws SerialPortIOException, SerialPortTimeoutException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            this.byteBuffer[0] = (byte)(b & 0xFF);
            int bytesWritten = SerialPort.this.writeBytes(SerialPort.this.portHandle, this.byteBuffer, 1, 0, SerialPort.this.timeoutMode);
            if (bytesWritten < 0) {
                throw new SerialPortIOException("No bytes written. This port appears to have been shutdown or disconnected.");
            }
            if (bytesWritten == 0) {
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }

        @Override
        public final void write(byte[] b) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            int numWritten;
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the write buffer.");
            }
            if (len < 0 || off < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException("The specified write offset plus length extends past the end of the specified buffer.");
            }
            for (int totalNumWritten = 0; totalNumWritten != len; totalNumWritten += numWritten) {
                if (SerialPort.this.portHandle == 0L) {
                    throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
                }
                numWritten = SerialPort.this.writeBytes(SerialPort.this.portHandle, b, len - totalNumWritten, off + totalNumWritten, SerialPort.this.timeoutMode);
                if (numWritten < 0) {
                    throw new SerialPortIOException("No bytes written. This port appears to have been shutdown or disconnected.");
                }
                if (numWritten != 0) continue;
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }
    }

    private final class SerialPortInputStream
    extends InputStream {
        private final boolean timeoutExceptionsSuppressed;
        private final byte[] byteBuffer = new byte[1];

        public SerialPortInputStream(boolean suppressReadTimeoutExceptions) {
            this.timeoutExceptionsSuppressed = suppressReadTimeoutExceptions;
        }

        @Override
        public final int available() throws SerialPortIOException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            return SerialPort.this.bytesAvailable();
        }

        @Override
        public final int read() throws SerialPortIOException, SerialPortTimeoutException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            int numRead = SerialPort.this.readBytes(this.byteBuffer, 1);
            if (numRead == 0) {
                if (this.timeoutExceptionsSuppressed) {
                    return -1;
                }
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead < 0 ? -1 : this.byteBuffer[0] & 0xFF;
        }

        @Override
        public final int read(byte[] b) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (b.length == 0) {
                return 0;
            }
            int numRead = SerialPort.this.readBytes(b, b.length);
            if (numRead == 0 && !this.timeoutExceptionsSuppressed) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead;
        }

        @Override
        public final int read(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (len < 0 || off < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException("The specified read offset plus length extends past the end of the specified buffer.");
            }
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (b.length == 0 || len == 0) {
                return 0;
            }
            int numRead = SerialPort.this.readBytes(b, len, off);
            if (numRead == 0 && !this.timeoutExceptionsSuppressed) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead;
        }

        @Override
        public final long skip(long n) throws SerialPortIOException {
            if (SerialPort.this.portHandle == 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            long bytesSkipped = 0L;
            int bufferSize = n > 4096L ? 4096 : (int)n;
            byte[] buffer = new byte[bufferSize];
            long bytesRead = 1L;
            for (long i = 0L; bytesRead > 0L && i < n; i += (long)bufferSize) {
                bytesRead = SerialPort.this.readBytes(buffer, (int)Math.min(n - i, (long)bufferSize));
                if (bytesRead <= 0L) continue;
                bytesSkipped += bytesRead;
            }
            return bytesSkipped;
        }
    }

    private final class SerialPortEventListener {
        private final boolean messageEndIsDelimited;
        private final byte[] dataPacket;
        private final byte[] delimiters;
        private final ByteArrayOutputStream messageBytes = new ByteArrayOutputStream();
        private int dataPacketIndex = 0;
        private int delimiterIndex = 0;
        private Thread serialEventThread = null;

        public SerialPortEventListener() {
            this.dataPacket = new byte[0];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(int packetSizeToReceive) {
            this.dataPacket = new byte[packetSizeToReceive];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(byte[] messageDelimiters, boolean delimiterForMessageEnd) {
            this.dataPacket = new byte[0];
            this.delimiters = messageDelimiters;
            this.messageEndIsDelimited = delimiterForMessageEnd;
        }

        public final void startListening() {
            if (SerialPort.this.eventListenerRunning) {
                return;
            }
            SerialPort.this.eventListenerRunning = true;
            this.resetBuffers();
            SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, true);
            this.serialEventThread = SerialPortThreadFactory.get().newThread(new Runnable(){

                @Override
                public void run() {
                    while (SerialPort.this.eventListenerRunning && !isShuttingDown) {
                        try {
                            SerialPortEventListener.this.waitForSerialEvent();
                        }
                        catch (Exception e) {
                            SerialPort.this.eventListenerRunning = false;
                            if (SerialPort.this.userDataListener instanceof SerialPortDataListenerWithExceptions) {
                                ((SerialPortDataListenerWithExceptions)SerialPort.this.userDataListener).catchException(e);
                                continue;
                            }
                            if (!(SerialPort.this.userDataListener instanceof SerialPortMessageListenerWithExceptions)) continue;
                            ((SerialPortMessageListenerWithExceptions)SerialPort.this.userDataListener).catchException(e);
                        }
                    }
                }
            });
            this.serialEventThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stopListening() {
            lock.lock();
            try {
                if (!SerialPort.this.eventListenerRunning) {
                    return;
                }
                SerialPort.this.eventListenerRunning = false;
                int oldTimeoutMode = SerialPort.this.timeoutMode;
                int oldEventFlags = SerialPort.this.eventFlags;
                SerialPort.this.timeoutMode = 0;
                SerialPort.this.eventFlags = 0;
                SerialPort.this.configPort(SerialPort.this.portHandle);
                SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, false);
                try {
                    if (!Thread.currentThread().equals(this.serialEventThread)) {
                        do {
                            this.serialEventThread.join(500L);
                            if (!this.serialEventThread.isAlive()) continue;
                            this.serialEventThread.interrupt();
                        } while (this.serialEventThread.isAlive());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.serialEventThread = null;
                SerialPort.this.timeoutMode = oldTimeoutMode;
                SerialPort.this.eventFlags = oldEventFlags;
                SerialPort.this.configPort(SerialPort.this.portHandle);
            }
            finally {
                lock.unlock();
            }
        }

        public final void resetBuffers() {
            this.messageBytes.reset();
            this.dataPacketIndex = 0;
            this.delimiterIndex = 0;
        }

        public final void waitForSerialEvent() throws Exception {
            int event = SerialPort.this.waitForEvent(SerialPort.this.portHandle) & SerialPort.this.eventFlags;
            if ((event & 1) > 0 && (SerialPort.this.eventFlags & 0x10) > 0) {
                int numBytesAvailable;
                event &= 0xFFFFFFEE;
                while (SerialPort.this.eventListenerRunning && (numBytesAvailable = SerialPort.this.bytesAvailable()) > 0) {
                    int newBytesIndex = 0;
                    byte[] newBytes = new byte[numBytesAvailable];
                    int bytesRemaining = SerialPort.this.readBytes(newBytes, newBytes.length);
                    if (bytesRemaining <= 0) continue;
                    if (this.delimiters.length > 0) {
                        int startIndex = 0;
                        for (int offset = 0; offset < bytesRemaining; ++offset) {
                            if (newBytes[offset] == this.delimiters[this.delimiterIndex]) {
                                byte[] byteArray;
                                if (++this.delimiterIndex != this.delimiters.length) continue;
                                this.messageBytes.write(newBytes, startIndex, 1 + offset - startIndex);
                                byte[] byArray = byteArray = this.messageEndIsDelimited ? this.messageBytes.toByteArray() : Arrays.copyOf(this.messageBytes.toByteArray(), this.messageBytes.size() - this.delimiters.length);
                                if (byteArray.length > 0 && (this.messageEndIsDelimited || this.delimiters[0] == byteArray[0])) {
                                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, byteArray));
                                }
                                startIndex = offset + 1;
                                this.messageBytes.reset();
                                this.delimiterIndex = 0;
                                if (this.messageEndIsDelimited) continue;
                                this.messageBytes.write(this.delimiters, 0, this.delimiters.length);
                                continue;
                            }
                            if (this.delimiterIndex == 0) continue;
                            this.delimiterIndex = newBytes[offset] == this.delimiters[0] ? 1 : 0;
                        }
                        this.messageBytes.write(newBytes, startIndex, bytesRemaining - startIndex);
                        continue;
                    }
                    if (this.dataPacket.length == 0) {
                        SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])newBytes.clone()));
                        continue;
                    }
                    while (bytesRemaining >= this.dataPacket.length - this.dataPacketIndex) {
                        System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, this.dataPacket.length - this.dataPacketIndex);
                        bytesRemaining -= this.dataPacket.length - this.dataPacketIndex;
                        newBytesIndex += this.dataPacket.length - this.dataPacketIndex;
                        this.dataPacketIndex = 0;
                        SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])this.dataPacket.clone()));
                    }
                    if (bytesRemaining <= 0) continue;
                    System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, bytesRemaining);
                    this.dataPacketIndex += bytesRemaining;
                }
            }
            if (SerialPort.this.eventListenerRunning && !isShuttingDown && event != 0) {
                SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, event));
            }
        }
    }
}

