/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortDataListenerWithExceptions;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortIOException;
import com.fazecast.jSerialComm.SerialPortInvalidPortException;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import com.fazecast.jSerialComm.SerialPortMessageListenerWithExceptions;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import com.fazecast.jSerialComm.SerialPortTimeoutException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public final class SerialPort {
    private static final String versionString = "2.8.2";
    private static final String tmpdirAppIdProperty = "fazecast.jSerialComm.appid";
    private static volatile boolean isAndroid = false;
    private static volatile boolean isWindows = false;
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    public static final int MARK_PARITY = 3;
    public static final int SPACE_PARITY = 4;
    public static final int ONE_STOP_BIT = 1;
    public static final int ONE_POINT_FIVE_STOP_BITS = 2;
    public static final int TWO_STOP_BITS = 3;
    public static final int FLOW_CONTROL_DISABLED = 0;
    public static final int FLOW_CONTROL_RTS_ENABLED = 1;
    public static final int FLOW_CONTROL_CTS_ENABLED = 16;
    public static final int FLOW_CONTROL_DSR_ENABLED = 256;
    public static final int FLOW_CONTROL_DTR_ENABLED = 4096;
    public static final int FLOW_CONTROL_XONXOFF_IN_ENABLED = 65536;
    public static final int FLOW_CONTROL_XONXOFF_OUT_ENABLED = 0x100000;
    public static final int TIMEOUT_NONBLOCKING = 0;
    public static final int TIMEOUT_READ_SEMI_BLOCKING = 1;
    public static final int TIMEOUT_READ_BLOCKING = 16;
    public static final int TIMEOUT_WRITE_BLOCKING = 256;
    public static final int TIMEOUT_SCANNER = 4096;
    public static final int LISTENING_EVENT_TIMED_OUT = 0;
    public static final int LISTENING_EVENT_DATA_AVAILABLE = 1;
    public static final int LISTENING_EVENT_DATA_RECEIVED = 16;
    public static final int LISTENING_EVENT_DATA_WRITTEN = 256;
    public static final int LISTENING_EVENT_BREAK_INTERRUPT = 65536;
    public static final int LISTENING_EVENT_CARRIER_DETECT = 131072;
    public static final int LISTENING_EVENT_CTS = 262144;
    public static final int LISTENING_EVENT_DSR = 524288;
    public static final int LISTENING_EVENT_RING_INDICATOR = 0x100000;
    public static final int LISTENING_EVENT_FRAMING_ERROR = 0x200000;
    public static final int LISTENING_EVENT_FIRMWARE_OVERRUN_ERROR = 0x400000;
    public static final int LISTENING_EVENT_SOFTWARE_OVERRUN_ERROR = 0x800000;
    public static final int LISTENING_EVENT_PARITY_ERROR = 0x1000000;
    public static final int LISTENING_EVENT_PORT_DISCONNECTED = 0x10000000;
    private volatile long portHandle = 0L;
    private volatile int baudRate = 9600;
    private volatile int dataBits = 8;
    private volatile int stopBits = 1;
    private volatile int parity = 0;
    private volatile int eventFlags = 0;
    private volatile int timeoutMode = 0;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile int flowControl = 0;
    private volatile int sendDeviceQueueSize = 4096;
    private volatile int receiveDeviceQueueSize = 4096;
    private volatile int safetySleepTimeMS = 200;
    private volatile int rs485DelayBefore = 0;
    private volatile int rs485DelayAfter = 0;
    private volatile byte xonStartChar = (byte)17;
    private volatile byte xoffStopChar = (byte)19;
    private volatile SerialPortDataListener userDataListener = null;
    private volatile SerialPortEventListener serialEventListener = null;
    private volatile String comPort;
    private volatile String friendlyName;
    private volatile String portDescription;
    private volatile String portLocation;
    private volatile boolean eventListenerRunning = false;
    private volatile boolean disableConfig = false;
    private volatile boolean disableExclusiveLock = false;
    private volatile boolean rs485Mode = false;
    private volatile boolean rs485ActiveHigh = true;
    private volatile boolean rs485RxDuringTx = false;
    private volatile boolean rs485EnableTermination = false;
    private volatile boolean isRtsEnabled = true;
    private volatile boolean isDtrEnabled = true;
    private volatile boolean autoFlushIOBuffers = false;
    private SerialPortInputStream inputStream = null;
    private SerialPortOutputStream outputStream = null;

    private static final boolean isSymbolicLink(File file) throws IOException {
        File canonicalFile = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !canonicalFile.getCanonicalFile().equals(canonicalFile.getAbsoluteFile());
    }

    private static final void deleteDirectory(File path) {
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                SerialPort.deleteDirectory(file);
            }
        }
        path.delete();
    }

    public final String toString() {
        return this.getPortDescription();
    }

    public static final String getVersion() {
        return versionString;
    }

    public static final synchronized native SerialPort[] getCommPorts();

    public static final SerialPort getCommPort(String portDescriptor) throws SerialPortInvalidPortException {
        try {
            if (portDescriptor.startsWith("~" + File.separator)) {
                portDescriptor = System.getProperty("user.home") + portDescriptor.substring(1);
            }
            if (isWindows) {
                portDescriptor = "\\\\.\\" + portDescriptor.substring(portDescriptor.lastIndexOf(92) + 1);
            } else if (SerialPort.isSymbolicLink(new File(portDescriptor))) {
                portDescriptor = new File(portDescriptor).getCanonicalPath();
            } else if (!new File(portDescriptor).exists()) {
                portDescriptor = "/dev/" + portDescriptor;
                if (!new File(portDescriptor).exists()) {
                    portDescriptor = "/dev/" + portDescriptor.substring(portDescriptor.lastIndexOf(47) + 1);
                }
                if (!new File(portDescriptor).exists()) {
                    throw new IOException();
                }
            }
        }
        catch (Exception e) {
            throw new SerialPortInvalidPortException("Unable to create a serial port object from the invalid port descriptor: " + portDescriptor, e);
        }
        SerialPort serialPort = new SerialPort();
        serialPort.comPort = portDescriptor;
        serialPort.friendlyName = "User-Specified Port";
        serialPort.portDescription = "User-Specified Port";
        return serialPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized boolean openPort(int safetySleepTime, int deviceSendQueueSize, int deviceReceiveQueueSize) {
        Class<SerialPort> clazz = SerialPort.class;
        synchronized (SerialPort.class) {
            File portFile;
            this.safetySleepTimeMS = safetySleepTime;
            this.sendDeviceQueueSize = deviceSendQueueSize > 0 ? deviceSendQueueSize : this.sendDeviceQueueSize;
            int n = this.receiveDeviceQueueSize = deviceReceiveQueueSize > 0 ? deviceReceiveQueueSize : this.receiveDeviceQueueSize;
            if (this.portHandle > 0L) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this.configPort(this.portHandle);
            }
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            File file = portFile = isAndroid ? new File(this.comPort) : null;
            if (!(portFile == null || portFile.canRead() && portFile.canWrite())) {
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec("su");
                    DataOutputStream writer = new DataOutputStream(process.getOutputStream());
                    writer.writeBytes("chmod 666 " + this.comPort + "\n");
                    writer.writeBytes("exit\n");
                    writer.flush();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while (reader.readLine() != null) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    boolean bl = false;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return bl;
                }
                finally {
                    if (process == null) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return false;
                    }
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return false;
                    }
                    try {
                        process.getInputStream().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return false;
                    }
                    try {
                        process.getOutputStream().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return false;
                    }
                    try {
                        process.getErrorStream().close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return false;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return false;
                    }
                }
            }
            if ((this.portHandle = this.openPortNative()) > 0L && this.serialEventListener != null) {
                this.serialEventListener.startListening();
            }
            if (this.portHandle <= 0L) return false;
            return true;
        }
    }

    public final boolean openPort(int safetySleepTime) {
        return this.openPort(safetySleepTime, this.sendDeviceQueueSize, this.receiveDeviceQueueSize);
    }

    public final boolean openPort() {
        return this.openPort(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean closePort() {
        Class<SerialPort> clazz = SerialPort.class;
        synchronized (SerialPort.class) {
            if (this.serialEventListener != null) {
                this.serialEventListener.stopListening();
            }
            if (this.portHandle > 0L) {
                this.portHandle = this.closePortNative(this.portHandle);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.portHandle <= 0L;
        }
    }

    public final synchronized boolean isOpen() {
        return this.portHandle > 0L;
    }

    public final synchronized void disablePortConfiguration() {
        this.disableConfig = true;
    }

    public final synchronized void disableExclusiveLock() {
        this.disableExclusiveLock = true;
    }

    public final synchronized int getLastErrorLocation() {
        return this.portHandle != 0L ? this.getLastErrorLocation(this.portHandle > 0L ? this.portHandle : -this.portHandle) : -1;
    }

    public final synchronized int getLastErrorCode() {
        return this.portHandle != 0L ? this.getLastErrorCode(this.portHandle > 0L ? this.portHandle : -this.portHandle) : 0;
    }

    private static native void initializeLibrary();

    private static native void uninitializeLibrary();

    private final native long openPortNative();

    private final native long closePortNative(long var1);

    private final native boolean configPort(long var1);

    private final native boolean configTimeouts(long var1, int var3, int var4, int var5, int var6);

    private final native boolean flushRxTxBuffers(long var1);

    private final native int waitForEvent(long var1);

    private final native int bytesAvailable(long var1);

    private final native int bytesAwaitingWrite(long var1);

    private final native int readBytes(long var1, byte[] var3, long var4, long var6, int var8, int var9);

    private final native int writeBytes(long var1, byte[] var3, long var4, long var6, int var8);

    private final native void setEventListeningStatus(long var1, boolean var3);

    private final native boolean setBreak(long var1);

    private final native boolean clearBreak(long var1);

    private final native boolean setRTS(long var1);

    private final native boolean clearRTS(long var1);

    private final native boolean presetRTS();

    private final native boolean preclearRTS();

    private final native boolean setDTR(long var1);

    private final native boolean clearDTR(long var1);

    private final native boolean presetDTR();

    private final native boolean preclearDTR();

    private final native boolean getCTS(long var1);

    private final native boolean getDSR(long var1);

    private final native boolean getDCD(long var1);

    private final native boolean getDTR(long var1);

    private final native boolean getRTS(long var1);

    private final native boolean getRI(long var1);

    private final native int getLastErrorLocation(long var1);

    private final native int getLastErrorCode(long var1);

    public final int bytesAvailable() {
        return this.portHandle > 0L ? this.bytesAvailable(this.portHandle) : -1;
    }

    public final int bytesAwaitingWrite() {
        return this.portHandle > 0L ? this.bytesAwaitingWrite(this.portHandle) : -1;
    }

    public final int readBytes(byte[] buffer, long bytesToRead) {
        return this.portHandle > 0L ? this.readBytes(this.portHandle, buffer, bytesToRead, 0L, this.timeoutMode, this.readTimeout) : -1;
    }

    public final int readBytes(byte[] buffer, long bytesToRead, long offset) {
        return this.portHandle > 0L ? this.readBytes(this.portHandle, buffer, bytesToRead, offset, this.timeoutMode, this.readTimeout) : -1;
    }

    public final int writeBytes(byte[] buffer, long bytesToWrite) {
        int numWritten;
        int totalNumWritten = 0;
        while (this.portHandle > 0L && (long)totalNumWritten != bytesToWrite && (numWritten = this.writeBytes(this.portHandle, buffer, bytesToWrite - (long)totalNumWritten, totalNumWritten, this.timeoutMode)) > 0) {
            totalNumWritten += numWritten;
        }
        return this.portHandle > 0L && totalNumWritten >= 0 ? totalNumWritten : -1;
    }

    public final int writeBytes(byte[] buffer, long bytesToWrite, long offset) {
        int numWritten;
        int totalNumWritten = 0;
        while (this.portHandle > 0L && (long)totalNumWritten != bytesToWrite && (numWritten = this.writeBytes(this.portHandle, buffer, bytesToWrite - (long)totalNumWritten, offset + (long)totalNumWritten, this.timeoutMode)) > 0) {
            totalNumWritten += numWritten;
        }
        return this.portHandle > 0L && totalNumWritten >= 0 ? totalNumWritten : -1;
    }

    public final int getDeviceWriteBufferSize() {
        return this.sendDeviceQueueSize;
    }

    public final int getDeviceReadBufferSize() {
        return this.receiveDeviceQueueSize;
    }

    public final boolean setBreak() {
        return this.portHandle > 0L && this.setBreak(this.portHandle);
    }

    public final boolean clearBreak() {
        return this.portHandle > 0L && this.clearBreak(this.portHandle);
    }

    public final boolean setRTS() {
        this.isRtsEnabled = true;
        return this.portHandle > 0L ? this.setRTS(this.portHandle) : this.presetRTS();
    }

    public final boolean clearRTS() {
        this.isRtsEnabled = false;
        return this.portHandle > 0L ? this.clearRTS(this.portHandle) : this.preclearRTS();
    }

    public final boolean setDTR() {
        this.isDtrEnabled = true;
        return this.portHandle > 0L ? this.setDTR(this.portHandle) : this.presetDTR();
    }

    public final boolean clearDTR() {
        this.isDtrEnabled = false;
        return this.portHandle > 0L ? this.clearDTR(this.portHandle) : this.preclearDTR();
    }

    public final boolean getCTS() {
        return this.portHandle > 0L && this.getCTS(this.portHandle);
    }

    public final boolean getDSR() {
        return this.portHandle > 0L && this.getDSR(this.portHandle);
    }

    public final boolean getDCD() {
        return this.portHandle > 0L && this.getDCD(this.portHandle);
    }

    public final boolean getDTR() {
        return this.portHandle > 0L && this.getDTR(this.portHandle);
    }

    public final boolean getRTS() {
        return this.portHandle > 0L && this.getRTS(this.portHandle);
    }

    public final boolean getRI() {
        return this.portHandle > 0L && this.getRI(this.portHandle);
    }

    private SerialPort() {
    }

    public final synchronized boolean addDataListener(SerialPortDataListener listener) {
        if (this.userDataListener != null) {
            return false;
        }
        this.userDataListener = listener;
        this.eventFlags = listener.getListeningEvents();
        if ((this.eventFlags & 0x10) > 0) {
            this.eventFlags |= 1;
        }
        SerialPortEventListener serialPortEventListener = this.userDataListener instanceof SerialPortPacketListener ? new SerialPortEventListener(((SerialPortPacketListener)this.userDataListener).getPacketSize()) : (this.serialEventListener = this.userDataListener instanceof SerialPortMessageListener ? new SerialPortEventListener(((SerialPortMessageListener)this.userDataListener).getMessageDelimiter(), ((SerialPortMessageListener)this.userDataListener).delimiterIndicatesEndOfMessage()) : new SerialPortEventListener());
        if (this.portHandle > 0L) {
            this.configTimeouts(this.portHandle, this.timeoutMode, this.readTimeout, this.writeTimeout, this.eventFlags);
            this.serialEventListener.startListening();
        }
        return true;
    }

    public final synchronized void removeDataListener() {
        this.eventFlags = 0;
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
            this.serialEventListener = null;
            this.configTimeouts(this.portHandle, this.timeoutMode, this.readTimeout, this.writeTimeout, this.eventFlags);
        }
        this.userDataListener = null;
    }

    public final InputStream getInputStream() {
        this.inputStream = new SerialPortInputStream(false);
        return this.inputStream;
    }

    public final InputStream getInputStreamWithSuppressedTimeoutExceptions() {
        this.inputStream = new SerialPortInputStream(true);
        return this.inputStream;
    }

    public final OutputStream getOutputStream() {
        this.outputStream = new SerialPortOutputStream();
        return this.outputStream;
    }

    public final synchronized boolean flushIOBuffers() {
        this.autoFlushIOBuffers = true;
        if (this.portHandle > 0L) {
            return this.flushRxTxBuffers(this.portHandle);
        }
        return true;
    }

    public final boolean setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity) {
        return this.setComPortParameters(newBaudRate, newDataBits, newStopBits, newParity, this.rs485Mode);
    }

    public final synchronized boolean setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity, boolean useRS485Mode) {
        this.baudRate = newBaudRate;
        this.dataBits = newDataBits;
        this.stopBits = newStopBits;
        this.parity = newParity;
        this.rs485Mode = useRS485Mode;
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        this.timeoutMode = newTimeoutMode;
        if (isWindows) {
            this.readTimeout = newReadTimeout;
            this.writeTimeout = newWriteTimeout;
        } else {
            this.readTimeout = newReadTimeout > 0 && newReadTimeout <= 100 ? 100 : Math.round((float)newReadTimeout / 100.0f) * 100;
        }
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configTimeouts(this.portHandle, this.timeoutMode, this.readTimeout, this.writeTimeout, this.eventFlags);
        }
        return true;
    }

    public final synchronized boolean setBaudRate(int newBaudRate) {
        this.baudRate = newBaudRate;
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setNumDataBits(int newDataBits) {
        this.dataBits = newDataBits;
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setNumStopBits(int newStopBits) {
        this.stopBits = newStopBits;
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setFlowControl(int newFlowControlSettings) {
        this.flowControl = newFlowControlSettings;
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setParity(int newParity) {
        this.parity = newParity;
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setRs485ModeParameters(boolean useRS485Mode, boolean rs485RtsActiveHigh, int delayBeforeSendMicroseconds, int delayAfterSendMicroseconds) {
        return this.setRs485ModeParameters(useRS485Mode, rs485RtsActiveHigh, false, false, delayBeforeSendMicroseconds, delayAfterSendMicroseconds);
    }

    public final synchronized boolean setRs485ModeParameters(boolean useRS485Mode, boolean rs485RtsActiveHigh, boolean enableTermination, boolean rxDuringTx, int delayBeforeSendMicroseconds, int delayAfterSendMicroseconds) {
        this.rs485Mode = useRS485Mode;
        this.rs485ActiveHigh = rs485RtsActiveHigh;
        this.rs485EnableTermination = enableTermination;
        this.rs485RxDuringTx = rxDuringTx;
        this.rs485DelayBefore = delayBeforeSendMicroseconds;
        this.rs485DelayAfter = delayAfterSendMicroseconds;
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final synchronized boolean setXonXoffCharacters(byte xonStartCharacter, byte xoffStopCharacter) {
        this.xonStartChar = xonStartCharacter;
        this.xoffStopChar = xoffStopCharacter;
        if (this.portHandle > 0L) {
            if (this.safetySleepTimeMS > 0) {
                try {
                    Thread.sleep(this.safetySleepTimeMS);
                }
                catch (Exception e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.configPort(this.portHandle);
        }
        return true;
    }

    public final String getDescriptivePortName() {
        return this.friendlyName.trim();
    }

    public final String getSystemPortName() {
        return isWindows ? this.comPort.substring(this.comPort.lastIndexOf(92) + 1) : this.comPort.substring(this.comPort.lastIndexOf(47) + 1);
    }

    public final String getSystemPortPath() {
        return this.comPort;
    }

    public final String getPortDescription() {
        return this.portDescription.trim();
    }

    public final String getPortLocation() {
        return this.portLocation;
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final int getNumDataBits() {
        return this.dataBits;
    }

    public final int getNumStopBits() {
        return this.stopBits;
    }

    public final int getParity() {
        return this.parity;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final int getFlowControlSettings() {
        return this.flowControl;
    }

    /*
     * Unable to fully structure code
     */
    static {
        OS = System.getProperty("os.name").toLowerCase();
        arch = System.getProperty("os.arch").toLowerCase();
        libraryPath = "";
        fileName = "";
        backupLibraryPath = "";
        tempFileDirectory = System.getProperty("java.io.tmpdir");
        userHomeDirectory = System.getProperty("user.home");
        if (!tempFileDirectory.endsWith("\\") && !tempFileDirectory.endsWith("/")) {
            tempFileDirectory = tempFileDirectory + "/";
        }
        if (!userHomeDirectory.endsWith("\\") && !userHomeDirectory.endsWith("/")) {
            userHomeDirectory = userHomeDirectory + "/";
        }
        tempFileDirectory = tempFileDirectory + "jSerialComm/" + System.getProperty("fazecast.jSerialComm.appid", "");
        userHomeDirectory = userHomeDirectory + ".jSerialComm/" + System.getProperty("fazecast.jSerialComm.appid", "");
        if (!tempFileDirectory.endsWith("\\") && !tempFileDirectory.endsWith("/")) {
            tempFileDirectory = tempFileDirectory + "/";
        }
        if (!userHomeDirectory.endsWith("\\") && !userHomeDirectory.endsWith("/")) {
            userHomeDirectory = userHomeDirectory + "/";
        }
        SerialPort.deleteDirectory(new File(tempFileDirectory));
        SerialPort.deleteDirectory(new File(userHomeDirectory));
        if (System.getProperty("java.vm.vendor").toLowerCase().contains("android")) {
            try {
                getpropProcess = Runtime.getRuntime().exec("getprop");
                buildProperties = new BufferedReader(new InputStreamReader(getpropProcess.getInputStream()));
                while ((line = buildProperties.readLine()) != null) {
                    if (!line.contains("[ro.product.cpu.abi]:") && !line.contains("[ro.product.cpu.abi2]:") && !line.contains("[ro.product.cpu.abilist]:") && !line.contains("[ro.product.cpu.abilist64]:") && !line.contains("[ro.product.cpu.abilist32]:")) continue;
                    libraryPath = "Android/" + line.split(":")[1].trim().replace("[", "").replace("]", "").split(",")[0];
                    break;
                }
                getpropProcess.waitFor();
                buildProperties.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (libraryPath.isEmpty()) {
                libraryPath = "Android/armeabi";
            }
            SerialPort.isAndroid = true;
            fileName = "libjSerialComm.so";
        } else if (OS.indexOf("win") >= 0) {
            if (arch.equals("aarch64") || arch.equals("arm64")) {
                libraryPath = "Windows/aarch64";
            } else if (arch.indexOf("arm") >= 0) {
                libraryPath = "Windows/armv7";
            } else if (arch.indexOf("64") >= 0) {
                libraryPath = "Windows/x86_64";
                backupLibraryPath = "Windows/x86";
            } else {
                libraryPath = "Windows/x86";
                backupLibraryPath = "Windows/x86_64";
            }
            SerialPort.isWindows = true;
            fileName = "jSerialComm.dll";
        } else if (OS.indexOf("mac") >= 0) {
            if (arch.equals("aarch64") || arch.equals("arm64")) {
                libraryPath = "OSX/aarch64";
                backupLibraryPath = "OSX/x86_64";
            } else if (arch.indexOf("64") >= 0) {
                libraryPath = "OSX/x86_64";
                backupLibraryPath = "OSX/x86";
            } else {
                libraryPath = "OSX/x86";
            }
            fileName = "libjSerialComm.jnilib";
        } else if (OS.indexOf("sunos") >= 0 || OS.indexOf("solaris") >= 0) {
            if (arch.indexOf("sparcv9") >= 0) {
                libraryPath = "Solaris/sparcv9_64";
                backupLibraryPath = "Solaris/sparcv8plus_32";
            } else if (arch.indexOf("sparc") >= 0) {
                libraryPath = "Solaris/sparcv8plus_32";
            } else if (arch.indexOf("64") >= 0) {
                libraryPath = "Solaris/x86_64";
                backupLibraryPath = "Solaris/x86";
            } else {
                libraryPath = "Solaris/x86";
                backupLibraryPath = "Solaris/x86_64";
            }
            fileName = "libjSerialComm.so";
        } else if (OS.indexOf("bsd") >= 0) {
            if (arch.equals("aarch64") || arch.equals("arm64")) {
                libraryPath = "FreeBSD/arm64";
            }
            if (arch.indexOf("64") >= 0) {
                libraryPath = "FreeBSD/x86_64";
                backupLibraryPath = "FreeBSD/x86";
            } else {
                libraryPath = "FreeBSD/x86";
            }
            fileName = "libjSerialComm.so";
        } else if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0) {
            if (!System.getProperty("os.arch_full", "").isEmpty()) {
                libraryPath = "Linux/" + System.getProperty("os.arch_full").toLowerCase();
            } else if (arch.indexOf("arm") >= 0) {
                try {
                    cpuPropertiesFile = new BufferedReader(new FileReader("/proc/cpuinfo"));
                    while ((line = cpuPropertiesFile.readLine()) != null) {
                        if (line.contains("ARMv")) {
                            libraryPath = "Linux/armv" + line.substring(line.indexOf("ARMv") + 4, line.indexOf("ARMv") + 5);
                            break;
                        }
                        if (line.contains("ARM") && line.contains("(v")) {
                            libraryPath = "Linux/armv" + line.substring(line.indexOf("(v") + 2, line.indexOf("(v") + 3);
                            break;
                        }
                        if (!line.contains("aarch")) continue;
                        libraryPath = "Linux/armv8_";
                        backupLibraryPath = "Linux/armv8_";
                        break;
                    }
                    cpuPropertiesFile.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (libraryPath.isEmpty()) {
                    libraryPath = "Linux/armv6";
                } else if (libraryPath.contains("Linux/armv8")) {
                    if (System.getProperty("sun.arch.data.model") != null) {
                        libraryPath = libraryPath + (System.getProperty("sun.arch.data.model").indexOf("64") >= 0 ? "64" : "32");
                        backupLibraryPath = backupLibraryPath + (System.getProperty("sun.arch.data.model").indexOf("64") >= 0 ? "32" : "64");
                    } else {
                        libraryPath = libraryPath + (arch.indexOf("64") >= 0 ? "64" : "32");
                        backupLibraryPath = backupLibraryPath + (arch.indexOf("64") >= 0 ? "32" : "64");
                    }
                } else {
                    try {
                        linkerFile = new File("/lib/ld-linux-armhf.so.3");
                        if (linkerFile.exists()) {
                            backupLibraryPath = libraryPath;
                            libraryPath = libraryPath + "hf";
                        } else {
                            pb = new ProcessBuilder(new String[]{"/bin/sh", "-c", "ls /lib/ld-linux*"});
                            p = pb.start();
                            p.waitFor();
                            br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                            line = br.readLine();
                            if (line != null && line.contains("armhf")) {
                                backupLibraryPath = libraryPath;
                                libraryPath = libraryPath + "hf";
                            } else {
                                pb = new ProcessBuilder(new String[]{"/bin/sh", "-c", "ldd /usr/bin/ld | grep ld-"});
                                p = pb.start();
                                p.waitFor();
                                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                line = br.readLine();
                                if (line != null && line.contains("armhf")) {
                                    backupLibraryPath = libraryPath;
                                    libraryPath = libraryPath + "hf";
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (arch.indexOf("aarch32") >= 0) {
                libraryPath = "Linux/armv8_32";
            } else if (arch.indexOf("aarch64") >= 0) {
                libraryPath = "Linux/armv8_64";
                backupLibraryPath = "Linux/armv8_32";
            } else if (arch.indexOf("ppc64le") >= 0) {
                libraryPath = "Linux/ppc64le";
            } else if (arch.indexOf("64") >= 0) {
                libraryPath = "Linux/x86_64";
                backupLibraryPath = "Linux/x86";
            } else {
                libraryPath = "Linux/x86";
            }
            fileName = "libjSerialComm.so";
        } else {
            System.err.println("This operating system is not supported by the jSerialComm library.");
            System.exit(-1);
        }
        try {
            libraryLoaded = false;
            for (attempt = 0; !libraryLoaded && attempt < 2; ++attempt) {
                block85: {
                    tempNativeLibrary = new File((attempt == 0 ? tempFileDirectory : userHomeDirectory) + new Date().getTime() + "-" + fileName);
                    tempBackupNativeLibrary = new File((attempt == 0 ? tempFileDirectory : userHomeDirectory) + new Date().getTime() + "-backup-" + fileName);
                    if (!tempNativeLibrary.getParentFile().mkdirs()) continue;
                    tempNativeLibrary.getParentFile().setReadable(true, false);
                    tempNativeLibrary.getParentFile().setWritable(true, false);
                    tempNativeLibrary.getParentFile().setExecutable(true, false);
                    tempBackupNativeLibrary.deleteOnExit();
                    tempNativeLibrary.deleteOnExit();
                    fileContents = SerialPort.class.getResourceAsStream("/" + libraryPath + "/" + fileName);
                    v0 = backupFileContents = backupLibraryPath.isEmpty() != false ? null : SerialPort.class.getResourceAsStream("/" + backupLibraryPath + "/" + fileName);
                    if (fileContents == null && SerialPort.isAndroid) {
                        libraryPath = libraryPath.replace("Android/", "lib/");
                        fileContents = SerialPort.class.getResourceAsStream("/" + libraryPath + "/" + fileName);
                    }
                    if (fileContents == null) {
                        System.err.println("Could not locate or access the native jSerialComm shared library.");
                        System.err.println("If you are using multiple projects with interdependencies, you may need to fix your build settings to ensure that library resources are copied properly.");
                        continue;
                    }
                    destinationFileContents = new FileOutputStream(tempNativeLibrary);
                    transferBuffer = new byte[4096];
                    while ((numBytesRead = fileContents.read(transferBuffer)) > 0) {
                        destinationFileContents.write(transferBuffer, 0, numBytesRead);
                    }
                    destinationFileContents.close();
                    fileContents.close();
                    tempNativeLibrary.setReadable(true, false);
                    tempNativeLibrary.setWritable(false, false);
                    tempNativeLibrary.setExecutable(true, false);
                    libraryLoaded = true;
                    try {
                        System.load(tempNativeLibrary.getAbsolutePath());
                    }
                    catch (UnsatisfiedLinkError e) {
                        libraryLoaded = false;
                        if (backupFileContents != null || attempt <= 0) break block85;
                        throw new UnsatisfiedLinkError("Cannot load native library " + tempNativeLibrary.getAbsolutePath() + " with expected architecture: " + libraryPath);
                    }
                }
                if (backupFileContents != null) {
                    if (!libraryLoaded) {
                        destinationFileContents = new FileOutputStream(tempBackupNativeLibrary);
                        while ((numBytesRead = backupFileContents.read(transferBuffer)) > 0) {
                            destinationFileContents.write(transferBuffer, 0, numBytesRead);
                        }
                        destinationFileContents.close();
                        backupFileContents.close();
                        tempBackupNativeLibrary.setReadable(true, false);
                        tempBackupNativeLibrary.setWritable(false, false);
                        tempBackupNativeLibrary.setExecutable(true, false);
                        libraryLoaded = true;
                        try {
                            System.load(tempBackupNativeLibrary.getAbsolutePath());
                        }
                        catch (UnsatisfiedLinkError e) {
                            libraryLoaded = false;
                            if (attempt <= 0) ** GOTO lbl249
                            throw new UnsatisfiedLinkError("Cannot load native libraries " + tempNativeLibrary.getAbsolutePath() + " or " + tempBackupNativeLibrary.getAbsolutePath() + " with expected architectures: " + libraryPath + " or " + backupLibraryPath);
                        }
                    } else {
                        backupFileContents.close();
                    }
                }
lbl249:
                // 5 sources

                if (!libraryLoaded) continue;
                SerialPort.initializeLibrary();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SerialPort.uninitializeLibrary();
            }
        });
    }

    private final class SerialPortOutputStream
    extends OutputStream {
        private byte[] byteBuffer = new byte[1];

        @Override
        public final void write(int b) throws SerialPortIOException, SerialPortTimeoutException {
            if (SerialPort.this.portHandle <= 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            this.byteBuffer[0] = (byte)(b & 0xFF);
            int bytesWritten = SerialPort.this.writeBytes(SerialPort.this.portHandle, this.byteBuffer, 1L, 0L, SerialPort.this.timeoutMode);
            if (bytesWritten < 0) {
                throw new SerialPortIOException("No bytes written. This port appears to have been shutdown or disconnected.");
            }
            if (bytesWritten == 0) {
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }

        @Override
        public final void write(byte[] b) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            int numWritten;
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the write buffer.");
            }
            if (len < 0 || off < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException("The specified write offset plus length extends past the end of the specified buffer.");
            }
            for (int totalNumWritten = 0; totalNumWritten != len; totalNumWritten += numWritten) {
                if (SerialPort.this.portHandle <= 0L) {
                    throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
                }
                numWritten = SerialPort.this.writeBytes(SerialPort.this.portHandle, b, len - totalNumWritten, off + totalNumWritten, SerialPort.this.timeoutMode);
                if (numWritten < 0) {
                    throw new SerialPortIOException("No bytes written. This port appears to have been shutdown or disconnected.");
                }
                if (numWritten != 0) continue;
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }
    }

    private final class SerialPortInputStream
    extends InputStream {
        private final boolean timeoutExceptionsSuppressed;
        private byte[] byteBuffer = new byte[1];

        public SerialPortInputStream(boolean suppressReadTimeoutExceptions) {
            this.timeoutExceptionsSuppressed = suppressReadTimeoutExceptions;
        }

        @Override
        public final int available() throws SerialPortIOException {
            if (SerialPort.this.portHandle <= 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            return SerialPort.this.bytesAvailable(SerialPort.this.portHandle);
        }

        @Override
        public final int read() throws SerialPortIOException, SerialPortTimeoutException {
            if (SerialPort.this.portHandle <= 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            int numRead = SerialPort.this.readBytes(SerialPort.this.portHandle, this.byteBuffer, 1L, 0L, SerialPort.this.timeoutMode, SerialPort.this.readTimeout);
            if (numRead == 0) {
                if (this.timeoutExceptionsSuppressed) {
                    return -1;
                }
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead < 0 ? -1 : this.byteBuffer[0] & 0xFF;
        }

        @Override
        public final int read(byte[] b) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (SerialPort.this.portHandle <= 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (b.length == 0) {
                return 0;
            }
            int numRead = SerialPort.this.readBytes(SerialPort.this.portHandle, b, b.length, 0L, SerialPort.this.timeoutMode, SerialPort.this.readTimeout);
            if (numRead == 0 && !this.timeoutExceptionsSuppressed) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead;
        }

        @Override
        public final int read(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (len < 0 || off < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException("The specified read offset plus length extends past the end of the specified buffer.");
            }
            if (SerialPort.this.portHandle <= 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (b.length == 0 || len == 0) {
                return 0;
            }
            int numRead = SerialPort.this.readBytes(SerialPort.this.portHandle, b, len, off, SerialPort.this.timeoutMode, SerialPort.this.readTimeout);
            if (numRead == 0 && !this.timeoutExceptionsSuppressed) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead;
        }

        @Override
        public final long skip(long n) throws SerialPortIOException {
            if (SerialPort.this.portHandle <= 0L) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[(int)n];
            return SerialPort.this.readBytes(SerialPort.this.portHandle, buffer, n, 0L, SerialPort.this.timeoutMode, SerialPort.this.readTimeout);
        }
    }

    private final class SerialPortEventListener {
        private final boolean messageEndIsDelimited;
        private final byte[] dataPacket;
        private final byte[] delimiters;
        private volatile ByteArrayOutputStream messageBytes = new ByteArrayOutputStream();
        private volatile int dataPacketIndex = 0;
        private volatile int delimiterIndex = 0;
        private Thread serialEventThread = null;

        public SerialPortEventListener() {
            this.dataPacket = new byte[0];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(int packetSizeToReceive) {
            this.dataPacket = new byte[packetSizeToReceive];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(byte[] messageDelimiters, boolean delimiterForMessageEnd) {
            this.dataPacket = new byte[0];
            this.delimiters = messageDelimiters;
            this.messageEndIsDelimited = delimiterForMessageEnd;
        }

        public final void startListening() {
            if (SerialPort.this.eventListenerRunning) {
                return;
            }
            SerialPort.this.eventListenerRunning = true;
            this.dataPacketIndex = 0;
            SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, true);
            this.serialEventThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SerialPort.this.eventListenerRunning) {
                        try {
                            SerialPortEventListener.this.waitForSerialEvent();
                        }
                        catch (Exception e) {
                            SerialPort.this.eventListenerRunning = false;
                            if (SerialPort.this.userDataListener instanceof SerialPortDataListenerWithExceptions) {
                                ((SerialPortDataListenerWithExceptions)SerialPort.this.userDataListener).catchException(e);
                                continue;
                            }
                            if (!(SerialPort.this.userDataListener instanceof SerialPortMessageListenerWithExceptions)) continue;
                            ((SerialPortMessageListenerWithExceptions)SerialPort.this.userDataListener).catchException(e);
                        }
                    }
                }
            });
            this.serialEventThread.start();
        }

        public final void stopListening() {
            if (!SerialPort.this.eventListenerRunning) {
                return;
            }
            SerialPort.this.eventListenerRunning = false;
            SerialPort.this.configTimeouts(SerialPort.this.portHandle, 0, 0, 0, 0);
            SerialPort.this.setEventListeningStatus(SerialPort.this.portHandle, false);
            try {
                this.serialEventThread.join(500L);
                if (this.serialEventThread.isAlive()) {
                    this.serialEventThread.interrupt();
                }
                this.serialEventThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.serialEventThread = null;
        }

        public final void waitForSerialEvent() throws Exception {
            int event = SerialPort.this.waitForEvent(SerialPort.this.portHandle) & SerialPort.this.eventFlags;
            if ((event & 1) > 0 && (SerialPort.this.eventFlags & 0x10) > 0) {
                int numBytesAvailable;
                event &= 0xFFFFFFEE;
                while (SerialPort.this.eventListenerRunning && (numBytesAvailable = SerialPort.this.bytesAvailable(SerialPort.this.portHandle)) > 0) {
                    int newBytesIndex = 0;
                    byte[] newBytes = new byte[numBytesAvailable];
                    int bytesRemaining = SerialPort.this.readBytes(SerialPort.this.portHandle, newBytes, newBytes.length, 0L, SerialPort.this.timeoutMode, SerialPort.this.readTimeout);
                    if (this.delimiters.length > 0) {
                        int startIndex = 0;
                        for (int offset = 0; offset < bytesRemaining; ++offset) {
                            if (newBytes[offset] == this.delimiters[this.delimiterIndex]) {
                                byte[] byteArray;
                                if (++this.delimiterIndex != this.delimiters.length) continue;
                                this.messageBytes.write(newBytes, startIndex, 1 + offset - startIndex);
                                byte[] byArray = byteArray = this.messageEndIsDelimited ? this.messageBytes.toByteArray() : Arrays.copyOf(this.messageBytes.toByteArray(), this.messageBytes.size() - this.delimiters.length);
                                if (byteArray.length > 0 && (this.messageEndIsDelimited || this.delimiters[0] == byteArray[0])) {
                                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, byteArray));
                                }
                                startIndex = offset + 1;
                                this.messageBytes.reset();
                                this.delimiterIndex = 0;
                                if (this.messageEndIsDelimited) continue;
                                this.messageBytes.write(this.delimiters, 0, this.delimiters.length);
                                continue;
                            }
                            if (this.delimiterIndex == 0) continue;
                            this.delimiterIndex = newBytes[offset] == this.delimiters[0] ? 1 : 0;
                        }
                        this.messageBytes.write(newBytes, startIndex, bytesRemaining - startIndex);
                        continue;
                    }
                    if (this.dataPacket.length == 0) {
                        SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])newBytes.clone()));
                        continue;
                    }
                    while (bytesRemaining >= this.dataPacket.length - this.dataPacketIndex) {
                        System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, this.dataPacket.length - this.dataPacketIndex);
                        bytesRemaining -= this.dataPacket.length - this.dataPacketIndex;
                        newBytesIndex += this.dataPacket.length - this.dataPacketIndex;
                        this.dataPacketIndex = 0;
                        SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])this.dataPacket.clone()));
                    }
                    if (bytesRemaining <= 0) continue;
                    System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, bytesRemaining);
                    this.dataPacketIndex += bytesRemaining;
                }
            }
            if (event != 0) {
                SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, event));
            }
        }
    }
}

