/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot;

import com.fedepot.cache.Cache;
import com.fedepot.cache.Ehcache;
import com.fedepot.env.Env;
import com.fedepot.event.EventEmitter;
import com.fedepot.event.EventType;
import com.fedepot.exception.ExceptionHandler;
import com.fedepot.ioc.ContainerBuilder;
import com.fedepot.ioc.IContainer;
import com.fedepot.ioc.IContainerBuilder;
import com.fedepot.mvc.Constants;
import com.fedepot.mvc.annotation.RoutePrefix;
import com.fedepot.mvc.controller.APIController;
import com.fedepot.mvc.controller.Controller;
import com.fedepot.mvc.controller.IController;
import com.fedepot.mvc.http.HttpContext;
import com.fedepot.mvc.http.HttpSessionManager;
import com.fedepot.mvc.http.Session;
import com.fedepot.mvc.http.SessionManager;
import com.fedepot.mvc.middleware.Middleware;
import com.fedepot.mvc.route.RouteManager;
import com.fedepot.mvc.template.BeetlTemplateEngine;
import com.fedepot.mvc.template.JtwigTemplateEngine;
import com.fedepot.mvc.template.TemplateEngine;
import com.fedepot.mvc.template.TemplateEngineFactory;
import com.fedepot.server.NettyServer;
import com.fedepot.util.FileKit;
import com.fedepot.util.ReflectKit;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Razor {
    private static final Logger log = LoggerFactory.getLogger(Razor.class);
    private Env env = Env.fromXml();
    private Class<?> appClass;
    private IContainerBuilder iocBuilder;
    private IContainer ioc;
    private NettyServer nettyServer = new NettyServer();
    private final Set<String> statics = new HashSet<String>(Stream.of(Constants.DEFAULT_STATICS, (List)this.env.getObject("razor.web.statics").orElse(Collections.EMPTY_LIST)).flatMap(Collection::stream).collect(Collectors.toList()));
    private final Map<String, String> staticsMap = new HashMap<String, String>();
    private final Set<Middleware> rootMiddlewares = new HashSet<Middleware>();
    private final Map<String, Set<Middleware>> pathMiddlewares = new HashMap<String, Set<Middleware>>();
    private SessionManager sessionManager = new HttpSessionManager(Ehcache.newInstance("_SESSION_"), this);
    private ExceptionHandler exceptionHandler = null;
    private final EventEmitter eventEmitter = EventEmitter.newInstance();
    private final Set<Class<?>> registerClassQueue = new HashSet();
    private final Set<Object> registerInstanceQueue = new HashSet<Object>();

    public static Razor self() {
        return new Razor();
    }

    public Razor listen(@NonNull String host, int port) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.env.set("razor.server.host", host);
        this.env.set("razor.server.port", port);
        return this;
    }

    public void start(@NonNull Class<?> appClass, String[] args) {
        if (appClass == null) {
            throw new NullPointerException("appClass");
        }
        this.start(appClass, this.env.get("razor.server.host", "0.0.0.0"), this.env.getInt("razor.server.port", Constants.DEFAULT_SERVER_PORT), args);
    }

    public void start(@NonNull Class<?> appClass, @NonNull String host, int port, String[] args) {
        if (appClass == null) {
            throw new NullPointerException("appClass");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.eventEmitter.emit(EventType.APP_START, this);
        try {
            this.env.set("razor.server.host", host);
            assert (port >= 80) : "Port should be a positive value and greater or equal to 80";
            this.env.set("razor.server.port", port);
            this.appClass = appClass;
            this.startUp();
            new Thread(() -> {
                try {
                    this.nettyServer.run(this, args);
                    this.eventEmitter.emit(EventType.APP_STARTED, this);
                }
                catch (Exception e) {
                    log.error("Run razor in new thread failed, error: {}", (Object)e.getMessage());
                }
            }).start();
        }
        catch (Exception e) {
            log.error("Run razor failed, error: {}", (Object)e.getMessage());
        }
    }

    public void stop() {
        this.eventEmitter.emit(EventType.APP_STOP, this);
        this.nettyServer.shutdown();
    }

    public Razor addStatic(String ... rules) {
        this.statics.addAll(Arrays.asList(rules));
        return this;
    }

    public Razor mapStatic(String routePrefix, String folder) {
        if (!routePrefix.startsWith("/")) {
            routePrefix = "/".concat(routePrefix);
        }
        if (!folder.startsWith("/")) {
            folder = "/".concat(folder);
        }
        this.staticsMap.put(routePrefix, folder);
        return this;
    }

    public Razor webRoot(String webDir) {
        boolean useOuterWebRoot = false;
        if (webDir.startsWith("/") || Pattern.compile("^([a-zA-Z]):".concat(File.separator + File.separator)).matcher(webDir).find()) {
            useOuterWebRoot = true;
        } else if (!Pattern.compile("^([^/.])([0-9a-zA-Z_]*)([^/.])$").matcher(webDir).find()) {
            log.error("Relative web folder name should only include numbers, latin letters, _ or /, and should not start or end with /");
            return this;
        }
        try {
            this.env.set("razor.web.root", webDir);
            this.env.set("razor.web.root.outer", useOuterWebRoot);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return this;
    }

    public Razor indexs(List<String> indexs) {
        try {
            this.env.set("razor.web.indexs", indexs);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return this;
    }

    public Razor ssl(boolean ssl) {
        try {
            this.env.set("razor.server.ssl", ssl);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return this;
    }

    public Razor gzip(boolean gzip) {
        try {
            this.env.set("razor.server.gzip", gzip);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return this;
    }

    public Razor set404(String template) {
        this.env.set("razor.web.template.404", template);
        return this;
    }

    public Razor use(Middleware middleware) {
        if (middleware.getPriority() < 0) {
            middleware.setPriority(this.rootMiddlewares.size());
        }
        this.rootMiddlewares.add(middleware);
        return this;
    }

    public Razor use(@NonNull String path, Middleware middleware) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        Set<Middleware> exists = this.pathMiddlewares.get(path);
        if (exists == null) {
            exists = new HashSet<Middleware>();
        }
        if (middleware.getPriority() < 0) {
            middleware.setPriority(this.rootMiddlewares.size() + exists.size());
        }
        exists.add(middleware);
        this.pathMiddlewares.put(path, exists);
        return this;
    }

    public Razor useTemplateEngine(TemplateEngine templateEngine) {
        TemplateEngineFactory.setTemplateEngine(templateEngine);
        return this;
    }

    public Razor useTemplateEngine(String name) {
        switch (name) {
            case "Jtwig": {
                this.useTemplateEngine(new JtwigTemplateEngine());
                break;
            }
            default: {
                this.useTemplateEngine(new BeetlTemplateEngine());
            }
        }
        return this;
    }

    public Razor use(@NonNull Class<? extends IController> controllerClass, Middleware middleware) {
        if (controllerClass == null) {
            throw new NullPointerException("controllerClass");
        }
        String routePrefix = "/";
        RoutePrefix routePrefixAnnotation = controllerClass.getAnnotation(RoutePrefix.class);
        if (routePrefixAnnotation != null) {
            routePrefix = routePrefixAnnotation.value();
        }
        if (!routePrefix.startsWith("/")) {
            routePrefix = "/".concat(routePrefix);
        }
        return this.use(routePrefix.concat("/*"), middleware);
    }

    public void registerClass(Class<?> clazz) {
        this.registerClassQueue.add(clazz);
    }

    public void registerInstance(Object instance) {
        if (this.registerInstanceQueue.stream().anyMatch(x -> x.getClass() == instance.getClass())) {
            return;
        }
        this.registerInstanceQueue.add(instance);
    }

    private void initIoc() {
        this.iocBuilder = ContainerBuilder.getInstance(this.appClass);
        this.iocBuilder.autoRegister(Controller.class);
        this.iocBuilder.autoRegister(APIController.class);
        this.iocBuilder.autoRegister(ExceptionHandler.class);
        this.iocBuilder.autoRegister(Session.class);
        this.iocBuilder.autoRegister(SessionManager.class);
        this.iocBuilder.autoRegister(Cache.class);
        this.iocBuilder.registerInstance(this);
        this.registerClassQueue.forEach(this.iocBuilder::autoRegister);
        this.registerInstanceQueue.forEach(this.iocBuilder::registerInstance);
        this.ioc = this.iocBuilder.build();
    }

    private void initMiddlewares() {
        Reflections reflections = ReflectKit.getReflections(this.appClass);
        Set controllers = reflections.getSubTypesOf(IController.class);
        controllers.forEach(controller -> {
            try {
                Method method = controller.getMethod("registerMiddlewares", (Class<?>)controller);
                Set middlewares = (Set)method.invoke(null, new Object[0]);
                middlewares.forEach(middleware -> this.use((Class<? extends IController>)controller, (Middleware)middleware));
            }
            catch (NoSuchMethodException e) {
                log.info(e.toString());
            }
            catch (Exception e) {
                log.error(e.toString());
            }
        });
    }

    private void initRoutes() {
        RouteManager.getInstance(this).registerRoutes();
    }

    private void initImplements() {
        Set sessionManagers;
        Reflections reflections = ReflectKit.getReflections(this.appClass);
        Set exceptionHandlers = reflections.getSubTypesOf(ExceptionHandler.class);
        if (exceptionHandlers.size() > 0) {
            this.exceptionHandler = (ExceptionHandler)((Object)this.ioc.resolve((Class)exceptionHandlers.iterator().next()));
        }
        if ((sessionManagers = reflections.getSubTypesOf(SessionManager.class)).size() > 0) {
            this.sessionManager = (SessionManager)((Object)this.ioc.resolve((Class)sessionManagers.iterator().next()));
        }
    }

    private void initRuntime() {
        Optional<String> webRoot = this.env.get("razor.web.root");
        boolean useOuterWebRoot = this.env.getBool("razor.web.root.outer", false);
        if (!useOuterWebRoot || !webRoot.isPresent()) {
            String webAbsPath = Constants.APP_CLASS_PATH.concat(File.separator).concat(this.env.get("razor.web.root", "WWW"));
            this.env.set("razor.runtime.web.root.path", webAbsPath);
        } else {
            this.env.set("razor.runtime.web.root.path", webRoot.get());
        }
        String templateAbsPath = Constants.APP_CLASS_PATH.concat(File.separator).concat(this.env.get("razor.web.template.root", "WEB-INF/templates"));
        this.env.set("razor.runtime.web.template.root.path", templateAbsPath);
        String[] templates = new String[]{"razor.web.template.403", "razor.web.template.404", "razor.web.template.500", "razor.web.template.502"};
        String[] keys = new String[]{"razor.runtime.web.html.403", "razor.runtime.web.html.404", "razor.runtime.web.html.500", "razor.runtime.web.html.502"};
        for (int i = 0; i < templates.length; ++i) {
            if (this.env.get(templates[i]).isPresent()) {
                String html = FileKit.read(templateAbsPath.concat(this.env.get(templates[i]).get()));
                if (html == null) continue;
                this.env.set(keys[i], html);
                continue;
            }
            this.env.set(keys[i], "");
        }
    }

    private void startUp() {
        HttpContext.init(this);
        this.initIoc();
        this.initMiddlewares();
        this.initRoutes();
        this.initImplements();
        this.initRuntime();
        log.info("App use web root folder: {}", (Object)this.env.get("razor.web.root", "WWW"));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("App is shutting down!");
            this.stop();
        }));
    }

    private Razor() {
    }

    public Env getEnv() {
        return this.env;
    }

    public Class<?> getAppClass() {
        return this.appClass;
    }

    public IContainer getIoc() {
        return this.ioc;
    }

    public Set<String> getStatics() {
        return this.statics;
    }

    public Map<String, String> getStaticsMap() {
        return this.staticsMap;
    }

    public Set<Middleware> getRootMiddlewares() {
        return this.rootMiddlewares;
    }

    public Map<String, Set<Middleware>> getPathMiddlewares() {
        return this.pathMiddlewares;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public EventEmitter getEventEmitter() {
        return this.eventEmitter;
    }
}

