/*
 * Decompiled with CFR 0.152.
 */
package com.fedepot.cache;

import com.fedepot.cache.Cache;
import com.fedepot.event.EventEmitter;
import com.fedepot.event.EventType;
import com.fedepot.ioc.annotation.IocIgnore;
import com.fedepot.mvc.Constants;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Optional;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IocIgnore
public class Ehcache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(Ehcache.class);
    private static Ehcache instance;
    private static String DEFAULT_GROUP;
    private CacheManager cacheManager;

    private Ehcache(String group) {
        String configXmlPath = Constants.APP_CLASS_PATH.concat("/WEB-INF/ehcache.xml");
        URL appXmlUrl = Ehcache.class.getResource("/WEB-INF/ehcache.xml");
        try {
            Configuration configuration;
            if (appXmlUrl != null) {
                log.info("Ehcache use configuration from file {}", (Object)configXmlPath);
                configuration = ConfigurationFactory.parseConfiguration((InputStream)appXmlUrl.openStream());
            } else {
                configXmlPath = Constants.RAZOR_CLASS_PATH.concat("/ehcache_default.xml");
                log.info("Ehcache configuration file is not exist, use {} instead.", (Object)configXmlPath);
                configuration = ConfigurationFactory.parseConfiguration((InputStream)Ehcache.class.getResourceAsStream("/ehcache_default.xml"));
            }
            this.cacheManager = CacheManager.create((Configuration)configuration);
            if (!this.cacheManager.cacheExists(DEFAULT_GROUP)) {
                this.cacheManager.addCache(DEFAULT_GROUP);
            }
            if (!this.cacheManager.cacheExists(group)) {
                this.cacheManager.addCache(group);
            }
            EventEmitter.newInstance().on(EventType.APP_STOP, e -> {
                log.info("Persist as app shutting down");
                this.shutdown();
            });
        }
        catch (Exception e2) {
            log.error("Ehcache configuration initialize failed", (Throwable)e2);
        }
    }

    public static synchronized Ehcache newInstance(String group) {
        if (instance == null) {
            instance = new Ehcache(group);
        }
        if (!Ehcache.instance.cacheManager.cacheExists(group)) {
            Ehcache.instance.cacheManager.addCache(group);
        }
        return instance;
    }

    private net.sf.ehcache.Cache cacher(String group) {
        net.sf.ehcache.Cache cacher = this.cacheManager.getCache(group);
        if (cacher == null) {
            log.error("Cache group {} is not exist", (Object)group);
        }
        return cacher;
    }

    @Override
    public void add(String key, Object value, int expires) {
        this.add(key, value, expires, DEFAULT_GROUP);
    }

    @Override
    public void add(String key, Object value, int expires, String group) {
        net.sf.ehcache.Cache cacher = this.cacher(group);
        if (cacher != null) {
            Element element = new Element((Object)key, value);
            element.setTimeToLive(expires);
            cacher.put(element);
        }
    }

    @Override
    public boolean safeAdd(String key, Object value, int expires) {
        return this.safeAdd(key, value, expires, DEFAULT_GROUP);
    }

    @Override
    public boolean safeAdd(String key, Object value, int expires, String group) {
        try {
            this.add(key, value, expires);
            return true;
        }
        catch (Exception e) {
            log.error(e.toString());
            return false;
        }
    }

    @Override
    public void delete(String key) {
        this.delete(key, DEFAULT_GROUP);
    }

    @Override
    public void delete(String key, String group) {
        net.sf.ehcache.Cache cacher = this.cacher(group);
        if (cacher != null) {
            cacher.remove((Serializable)((Object)key));
        }
    }

    @Override
    public Object get(String key, Object defaultValue) {
        return this.get(key, DEFAULT_GROUP, defaultValue);
    }

    @Override
    public Object get(String key, String group, Object defaultValue) {
        return this.get(key, group).orElse(defaultValue);
    }

    @Override
    public Optional<Object> get(String key) {
        return this.get(key, DEFAULT_GROUP);
    }

    @Override
    public Optional<Object> get(String key, String group) {
        Element element;
        net.sf.ehcache.Cache cacher = this.cacher(group);
        if (cacher != null && (element = cacher.get((Serializable)((Object)key))) != null) {
            return Optional.ofNullable(element.getObjectValue());
        }
        return Optional.empty();
    }

    @Override
    public long incr(String key, int by) {
        return this.incr(key, DEFAULT_GROUP, by);
    }

    @Override
    public synchronized long incr(String key, String group, int by) {
        net.sf.ehcache.Cache cacher = this.cacher(group);
        if (cacher != null) {
            Element element = cacher.get((Serializable)((Object)key));
            if (element == null) {
                return -1L;
            }
            long newValue = ((Number)element.getObjectValue()).longValue() + (long)by;
            Element newEle = new Element((Serializable)((Object)key), (Serializable)Long.valueOf(newValue));
            newEle.setTimeToLive(element.getTimeToLive());
            cacher.put(newEle);
            return newValue;
        }
        return -1L;
    }

    @Override
    public long decr(String key, int by) {
        return this.decr(key, DEFAULT_GROUP, by);
    }

    @Override
    public synchronized long decr(String key, String group, int by) {
        net.sf.ehcache.Cache cacher = this.cacher(group);
        if (cacher != null) {
            Element element = cacher.get((Serializable)((Object)key));
            if (element == null) {
                return -1L;
            }
            long newValue = ((Number)element.getObjectValue()).longValue() - (long)by;
            Element newEle = new Element((Serializable)((Object)key), (Serializable)Long.valueOf(newValue));
            newEle.setTimeToLive(element.getTimeToLive());
            cacher.put(newEle);
            return newValue;
        }
        return -1L;
    }

    @Override
    public void clear() {
        String[] groups;
        for (String group : groups = this.cacheManager.getCacheNames()) {
            if (!this.cacheManager.cacheExists(group)) continue;
            this.cacheManager.getCache(group).flush();
        }
    }

    @Override
    public void clear(String group) {
        this.cacher(group).flush();
    }

    @Override
    public void shutdown() {
        this.cacheManager.shutdown();
    }

    static {
        DEFAULT_GROUP = "_default_";
    }
}

